/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.generator.oa;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.annotator.generator.AnnotationGenerator;
import org.dataone.annotator.matcher.ConceptItem;
import org.dataone.annotator.matcher.ConceptMatcher;
import org.dataone.annotator.matcher.ConceptMatcherFactory;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.types.v1.Identifier;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.Party;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;

public class OAAnnotationGenerator
extends AnnotationGenerator {
    private static Log log = LogFactory.getLog(OAAnnotationGenerator.class);
    private ConceptMatcher conceptMatcher = ConceptMatcherFactory.getMatcher(1);
    private ConceptMatcher orcidMatcher = ConceptMatcherFactory.getMatcher(3);

    @Override
    public Map<Identifier, String> generateAnnotations(Identifier metadataPid) throws Exception {
        DataPackage dataPackage = this.getDataPackage(metadataPid);
        String annotationUri = "http://annotation/" + metadataPid.getValue();
        Identifier annotationPid = new Identifier();
        annotationPid.setValue(annotationUri);
        OntModel m = ModelFactory.createOntologyModel();
        Ontology ont = m.createOntology(annotationUri);
        ont.addImport(m.createResource(oboe));
        m.addSubModel(OntDocumentManager.getInstance().getModel(oboe));
        ont.addImport(m.createResource(oboe_sbc));
        m.addSubModel(OntDocumentManager.getInstance().getModel(oboe_sbc));
        ont.addImport(m.createResource(oa));
        m.addSubModel(OntDocumentManager.getInstance().getModel(oa));
        ont.addImport(m.createResource(dcterms));
        m.addSubModel(OntDocumentManager.getInstance().getModel(dcterms));
        ont.addImport(m.createResource(foaf));
        m.addSubModel(OntDocumentManager.getInstance().getModel(foaf));
        ont.addImport(m.createResource(prov));
        ont.addImport(m.createResource(cito));
        ObjectProperty hasBodyProperty = m.getObjectProperty(oa + "hasBody");
        ObjectProperty hasTargetProperty = m.getObjectProperty(oa + "hasTarget");
        ObjectProperty hasSourceProperty = m.getObjectProperty(oa + "hasSource");
        ObjectProperty hasSelectorProperty = m.getObjectProperty(oa + "hasSelector");
        ObjectProperty annotatedByProperty = m.getObjectProperty(oa + "annotatedBy");
        Property identifierProperty = m.getProperty(dcterms + "identifier");
        Property conformsToProperty = m.getProperty(dcterms + "conformsTo");
        Property wasAttributedTo = m.getProperty(prov + "wasAttributedTo");
        Property nameProperty = m.getProperty(foaf + "name");
        Property rdfValue = m.getProperty(rdf + "value");
        ObjectProperty ofCharacteristic = m.getObjectProperty(oboe_core + "ofCharacteristic");
        ObjectProperty usesStandard = m.getObjectProperty(oboe_core + "usesStandard");
        ObjectProperty ofEntity = m.getObjectProperty(oboe_core + "ofEntity");
        ObjectProperty hasMeasurement = m.getObjectProperty(oboe_core + "hasMeasurement");
        OntClass entityClass = m.getOntClass(oboe_core + "Entity");
        OntClass observationClass = m.getOntClass(oboe_core + "Observation");
        OntClass measurementClass = m.getOntClass(oboe_core + "Measurement");
        OntClass characteristicClass = m.getOntClass(oboe_core + "Characteristic");
        OntClass standardClass = m.getOntClass(oboe_core + "Standard");
        OntClass annotationClass = m.getOntClass(oa + "Annotation");
        OntClass specificResourceClass = m.getOntClass(oa + "SpecificResource");
        OntClass fragmentSelectorClass = m.getOntClass(oa + "FragmentSelector");
        Resource provEntityClass = m.getResource(prov + "Entity");
        Resource personClass = m.getResource(prov + "Person");
        Individual meta1 = m.createIndividual(ont.getURI() + "#meta", provEntityClass);
        meta1.addProperty(identifierProperty, metadataPid.getValue());
        Individual p1 = null;
        List creators = dataPackage.getCreators();
        if (creators != null && creators.size() > 0) {
            String creatorText = ((Party)creators.get(0)).getOrganization() + " " + ((Party)creators.get(0)).getSurName() + " " + ((Party)creators.get(0)).getGivenNames();
            List<ConceptItem> concepts = this.orcidMatcher.getConcepts(creatorText, null, null);
            if (concepts != null) {
                String orcidUri = concepts.get(0).getUri().toString();
                p1 = m.createIndividual(orcidUri, personClass);
                p1.addProperty(identifierProperty, orcidUri);
            } else {
                p1 = m.createIndividual(ont.getURI() + "#person", personClass);
            }
            if (((Party)creators.get(0)).getSurName() != null) {
                p1.addProperty(nameProperty, ((Party)creators.get(0)).getSurName());
            } else if (((Party)creators.get(0)).getOrganization() != null) {
                p1.addProperty(nameProperty, ((Party)creators.get(0)).getOrganization());
            }
        }
        if (p1 != null) {
            meta1.addProperty(wasAttributedTo, p1);
        }
        int entityCount = 1;
        Entity[] entities = dataPackage.getEntityList();
        if (entities != null) {
            for (Entity entity : entities) {
                String entityName = entity.getName();
                Individual o1 = m.createIndividual(ont.getURI() + "#observation" + entityCount, (Resource)observationClass);
                Resource entityConcept = this.lookupEntity(entityClass, entity);
                if (entityConcept != null) {
                    AllValuesFromRestriction avfr = m.createAllValuesFromRestriction(null, (Property)ofEntity, entityConcept);
                    o1.addOntClass((Resource)avfr);
                }
                log.debug((Object)("Entity name: " + entityName));
                Attribute[] attributes = entity.getAttributeList().getAttributes();
                int attributeCount = 1;
                if (attributes != null) {
                    for (Attribute attribute : attributes) {
                        String cnt = entityCount + "_" + attributeCount;
                        String attributeName = attribute.getName();
                        String attributeLabel = attribute.getLabel();
                        String attributeDefinition = attribute.getDefinition();
                        String attributeType = attribute.getAttributeType();
                        String attributeScale = attribute.getMeasurementScale();
                        String attributeUnitType = attribute.getUnitType();
                        String attributeUnit = attribute.getUnit();
                        String attributeDomain = attribute.getDomain().getClass().getSimpleName();
                        log.debug((Object)("Attribute name: " + attributeName));
                        log.debug((Object)("Attribute label: " + attributeLabel));
                        log.debug((Object)("Attribute definition: " + attributeDefinition));
                        log.debug((Object)("Attribute type: " + attributeType));
                        log.debug((Object)("Attribute scale: " + attributeScale));
                        log.debug((Object)("Attribute unit type: " + attributeUnitType));
                        log.debug((Object)("Attribute unit: " + attributeUnit));
                        log.debug((Object)("Attribute domain: " + attributeDomain));
                        Resource standard = this.lookupStandard(standardClass, attribute);
                        Resource characteristic = this.lookupCharacteristic(characteristicClass, attribute);
                        if (standard != null || characteristic != null) {
                            AllValuesFromRestriction avfr;
                            Individual m1 = m.createIndividual(ont.getURI() + "#measurement" + cnt, (Resource)measurementClass);
                            Individual a1 = m.createIndividual(ont.getURI() + "#annotation" + cnt, (Resource)annotationClass);
                            Individual t1 = m.createIndividual(ont.getURI() + "#target" + cnt, (Resource)specificResourceClass);
                            String xpointer = "xpointer(/eml/dataSet/dataTable[" + entityCount + "]/attributeList/attribute[" + attributeCount + "])";
                            Individual s1 = m.createIndividual(ont.getURI() + "#" + xpointer, (Resource)fragmentSelectorClass);
                            s1.addLiteral(rdfValue, (Object)xpointer);
                            s1.addProperty(conformsToProperty, "http://tools.ietf.org/rfc/rfc3023");
                            a1.addProperty((Property)hasBodyProperty, (RDFNode)m1);
                            a1.addProperty((Property)hasTargetProperty, (RDFNode)t1);
                            t1.addProperty((Property)hasSourceProperty, (RDFNode)meta1);
                            t1.addProperty((Property)hasSelectorProperty, (RDFNode)s1);
                            if (standard != null) {
                                avfr = m.createAllValuesFromRestriction(null, (Property)usesStandard, standard);
                                m1.addOntClass((Resource)avfr);
                            }
                            if (characteristic != null) {
                                avfr = m.createAllValuesFromRestriction(null, (Property)ofCharacteristic, characteristic);
                                m1.addOntClass((Resource)avfr);
                            }
                            o1.addProperty((Property)hasMeasurement, (RDFNode)m1);
                        }
                        ++attributeCount;
                    }
                }
                ++entityCount;
            }
        }
        StringWriter sw = new StringWriter();
        m.write((Writer)sw, null);
        HashMap<Identifier, String> annotations = new HashMap<Identifier, String>();
        annotations.put(annotationPid, sw.toString());
        return annotations;
    }

    private Resource lookupStandard(OntClass standardClass, Attribute attribute) throws Exception {
        String unit = attribute.getUnit().toLowerCase();
        List<ConceptItem> concepts = this.conceptMatcher.getConcepts(unit, null, null);
        return ResourceFactory.createResource((String)concepts.get(0).getUri().toString());
    }

    private Resource lookupCharacteristic(OntClass characteristicClass, Attribute attribute) throws Exception {
        String label = attribute.getLabel().toLowerCase();
        String definition = attribute.getDefinition();
        String text = label + " " + definition;
        List<ConceptItem> concepts = this.conceptMatcher.getConcepts(text, null, null);
        return ResourceFactory.createResource((String)concepts.get(0).getUri().toString());
    }

    private Resource lookupEntity(OntClass entityClass, Entity entity) throws Exception {
        String name = entity.getName();
        String definition = entity.getDefinition();
        List<ConceptItem> concepts = this.conceptMatcher.getConcepts(definition, null, null);
        return ResourceFactory.createResource((String)concepts.get(0).getUri().toString());
    }

    private DataPackage getDataPackage(Identifier pid) throws Exception {
        CNode cnode = D1Client.getCN();
        InputStream emlStream = cnode.get(null, pid);
        Eml200DataPackageParser parser = new Eml200DataPackageParser();
        parser.parse(emlStream);
        emlStream.close();
        DataPackage dataPackage = parser.getDataPackage();
        return dataPackage;
    }

    private void summarize(List<Identifier> identifiers) {
        for (Identifier pid : identifiers) {
            log.debug((Object)("Parsing pid: " + pid.getValue()));
            try {
                DataPackage dataPackage = this.getDataPackage(pid);
                String title = dataPackage.getTitle();
                log.debug((Object)("Title: " + title));
                Entity[] entities = dataPackage.getEntityList();
                if (entities == null) continue;
                for (Entity entity : entities) {
                    Attribute[] attributes;
                    String entityName = entity.getName();
                    log.debug((Object)("Entity name: " + entityName));
                    for (Attribute attribute : attributes = entity.getAttributeList().getAttributes()) {
                        String attributeName = attribute.getName();
                        String attributeLabel = attribute.getLabel();
                        String attributeDefinition = attribute.getDefinition();
                        String attributeType = attribute.getAttributeType();
                        String attributeScale = attribute.getMeasurementScale();
                        String attributeUnitType = attribute.getUnitType();
                        String attributeUnit = attribute.getUnit();
                        String attributeDomain = attribute.getDomain().getClass().getSimpleName();
                        log.debug((Object)("Attribute name: " + attributeName));
                        log.debug((Object)("Attribute label: " + attributeLabel));
                        log.debug((Object)("Attribute definition: " + attributeDefinition));
                        log.debug((Object)("Attribute type: " + attributeType));
                        log.debug((Object)("Attribute scale: " + attributeScale));
                        log.debug((Object)("Attribute unit type: " + attributeUnitType));
                        log.debug((Object)("Attribute unit: " + attributeUnit));
                        log.debug((Object)("Attribute domain: " + attributeDomain));
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)("error parsing metadata for: " + pid.getValue()), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        OAAnnotationGenerator.testGenerate();
        System.exit(0);
    }

    public static void testGenerate() throws Exception {
        Identifier metadataPid = new Identifier();
        metadataPid.setValue("tao.1.4");
        OAAnnotationGenerator ds = new OAAnnotationGenerator();
        String rdfString = ds.generateAnnotations(metadataPid).values().iterator().next();
        log.info((Object)("RDF annotation: \n" + rdfString));
    }

    public static void testSummary() throws Exception {
        OAAnnotationGenerator ds = new OAAnnotationGenerator();
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        ds.summarize(identifiers);
        System.exit(0);
    }
}

