/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.store;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.dataone.annotator.store.AnnotationPredicate;
import org.dataone.annotator.store.AnnotatorStore;
import org.dataone.annotator.store.FileBasedCache;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;

public class JsonAnnotatorStore
implements AnnotatorStore {
    public static Log log = LogFactory.getLog(JsonAnnotatorStore.class);
    public static final String ANNOTATION_FORMAT_ID = "http://docs.annotatorjs.org/en/v1.2.x/annotation-format.html";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private MNode storageNode = null;
    private Session session;

    public JsonAnnotatorStore(Session session) throws BaseException {
        this.session = session;
        NodeReference nodeRef = null;
        String nodeId = Settings.getConfiguration().getString("annotator.nodeid");
        if (nodeId != null) {
            nodeRef = new NodeReference();
            nodeRef.setValue(nodeId);
        }
        if (nodeRef == null) {
            block0: for (Node node : D1Client.getCN().listNodes().getNodeList()) {
                if (!node.getType().equals((Object)NodeType.MN)) continue;
                for (Service service : node.getServices().getServiceList()) {
                    if (!service.getName().equalsIgnoreCase("MNStorage") || !service.getAvailable().booleanValue()) continue;
                    nodeRef = node.getIdentifier();
                    continue block0;
                }
            }
        }
        this.storageNode = D1Client.getMN((NodeReference)nodeRef);
    }

    private SystemMetadata computeSystemMetadata(JSONObject annotation) throws Exception {
        SystemMetadata sysmeta = new SystemMetadata();
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(ANNOTATION_FORMAT_ID);
        sysmeta.setFormatId(formatId);
        BigInteger size = BigInteger.valueOf(annotation.toJSONString().getBytes(DEFAULT_ENCODING).length);
        sysmeta.setSize(size);
        Checksum checksum = ChecksumUtil.checksum((byte[])annotation.toJSONString().getBytes(DEFAULT_ENCODING), (String)"MD5");
        sysmeta.setChecksum(checksum);
        Subject rightsHolder = this.session.getSubject();
        sysmeta.setRightsHolder(rightsHolder);
        sysmeta.setSubmitter(rightsHolder);
        NodeReference authoritativeMemberNode = this.storageNode.getCapabilities().getIdentifier();
        sysmeta.setAuthoritativeMemberNode(authoritativeMemberNode);
        sysmeta.setOriginMemberNode(authoritativeMemberNode);
        sysmeta.setDateSysMetadataModified(DateTimeMarshaller.deserializeDateToUTC((String)annotation.get((Object)"updated").toString()));
        sysmeta.setDateUploaded(DateTimeMarshaller.deserializeDateToUTC((String)annotation.get((Object)"created").toString()));
        AccessPolicy accessPolicy = new AccessPolicy();
        JSONObject permissions = (JSONObject)annotation.get((Object)"permissions");
        JSONArray readList = (JSONArray)permissions.get((Object)"read");
        for (Object read : readList) {
            AccessRule accessRule = new AccessRule();
            Subject user = new Subject();
            String username = read.toString();
            if (username.equals("group:__world__")) {
                user.setValue("public");
            }
            accessRule.addSubject(user);
            accessRule.addPermission(Permission.READ);
            accessPolicy.addAllow(accessRule);
        }
        sysmeta.setAccessPolicy(accessPolicy);
        return sysmeta;
    }

    @Override
    public String create(String annotationContent) throws Exception {
        JSONObject annotation = (JSONObject)JSONValue.parse((String)annotationContent);
        Identifier pid = this.storageNode.generateIdentifier(this.session, "UUID", "annotation");
        Identifier sid = this.storageNode.generateIdentifier(this.session, "UUID", "annotation");
        annotation.put((Object)"id", (Object)sid.getValue());
        annotation.put((Object)"user", (Object)this.session.getSubject().getValue());
        ((JSONArray)((JSONObject)annotation.get((Object)"permissions")).get((Object)"admin")).add((Object)this.session.getSubject().getValue());
        ((JSONArray)((JSONObject)annotation.get((Object)"permissions")).get((Object)"update")).add((Object)this.session.getSubject().getValue());
        ((JSONArray)((JSONObject)annotation.get((Object)"permissions")).get((Object)"delete")).add((Object)this.session.getSubject().getValue());
        Date now = Calendar.getInstance().getTime();
        annotation.put((Object)"created", (Object)DateTimeMarshaller.serializeDateToUTC((Date)now));
        annotation.put((Object)"updated", (Object)DateTimeMarshaller.serializeDateToUTC((Date)now));
        SystemMetadata sysmeta = this.computeSystemMetadata(annotation);
        sysmeta.setIdentifier(pid);
        sysmeta.setSeriesId(sid);
        log.warn((Object)("Session subject: " + this.session.getSubject().getValue()));
        log.warn((Object)("Creating annotation created by: " + sysmeta.getRightsHolder().getValue()));
        ByteArrayInputStream object = new ByteArrayInputStream(annotation.toJSONString().getBytes(DEFAULT_ENCODING));
        this.storageNode.create(this.session, pid, (InputStream)object, sysmeta);
        return sid.getValue();
    }

    @Override
    public String read(String id) throws Exception {
        Identifier sid = new Identifier();
        sid.setValue(id);
        InputStream object = FileBasedCache.get(id);
        if (object == null) {
            object = this.storageNode.get(this.session, sid);
            FileBasedCache.cache(id, object);
            object = FileBasedCache.get(id);
        }
        return IOUtils.toString((InputStream)object, (String)DEFAULT_ENCODING);
    }

    @Override
    public String update(String id, String partialAnnotationContent) throws Exception {
        JSONObject partialAnnotation = (JSONObject)JSONValue.parse((String)partialAnnotationContent);
        Identifier givenIdentifier = new Identifier();
        givenIdentifier.setValue(id);
        SystemMetadata originalSystemMetadata = this.storageNode.getSystemMetadata(this.session, givenIdentifier);
        Identifier originalPid = originalSystemMetadata.getIdentifier();
        Identifier sid = originalSystemMetadata.getSeriesId();
        Identifier pid = this.storageNode.generateIdentifier(this.session, "UUID", "annotation");
        String annotationContent = this.read(id);
        JSONObject annotation = (JSONObject)JSONValue.parse((String)annotationContent);
        annotation.putAll((Map)partialAnnotation);
        annotation.put((Object)"id", (Object)sid.getValue());
        annotation.put((Object)"user", (Object)this.session.getSubject().getValue());
        Date now = Calendar.getInstance().getTime();
        annotation.put((Object)"updated", (Object)DateTimeMarshaller.serializeDateToUTC((Date)now));
        SystemMetadata sysmeta = this.computeSystemMetadata(annotation);
        sysmeta.setIdentifier(pid);
        sysmeta.setSeriesId(sid);
        sysmeta.setObsoletes(originalPid);
        ByteArrayInputStream object = new ByteArrayInputStream(annotation.toJSONString().getBytes(DEFAULT_ENCODING));
        this.storageNode.update(this.session, originalPid, (InputStream)object, pid, sysmeta);
        FileBasedCache.remove(id);
        return annotation.toJSONString();
    }

    @Override
    public void delete(String id) throws Exception {
        Identifier sid = new Identifier();
        sid.setValue(id);
        this.storageNode.archive(this.session, sid);
        FileBasedCache.remove(id);
    }

    @Override
    public String search(String query) throws Exception {
        return this.searchIndex(query, false);
    }

    private String searchList(String query) throws Exception {
        JSONObject results = new JSONObject();
        String annotationsContent = this.index();
        JSONArray annotations = (JSONArray)JSONValue.parse((String)annotationsContent);
        ArrayList<AnnotationPredicate> predicates = new ArrayList<AnnotationPredicate>();
        List criteria = URLEncodedUtils.parse((String)query, (Charset)Charset.forName(DEFAULT_ENCODING));
        for (NameValuePair pair : criteria) {
            if (pair.getName().equals("limit") || pair.getName().equals("offset")) continue;
            predicates.add(new AnnotationPredicate(pair.getName(), pair.getValue()));
        }
        Predicate allPredicate = PredicateUtils.allPredicate(predicates);
        CollectionUtils.filter((Collection)annotations, (Predicate)allPredicate);
        results.put((Object)"total", (Object)annotations.size());
        results.put((Object)"rows", (Object)annotations);
        return results.toJSONString();
    }

    private String searchIndex(String query, boolean isList) throws Exception {
        String solrQuery = "q=" + URLEncoder.encode("formatId:\"http://docs.annotatorjs.org/en/v1.2.x/annotation-format.html\"", DEFAULT_ENCODING);
        ArrayList<AnnotationPredicate> predicates = new ArrayList<AnnotationPredicate>();
        List criteria = URLEncodedUtils.parse((String)query, (Charset)Charset.forName(DEFAULT_ENCODING));
        for (NameValuePair pair : criteria) {
            if (pair.getName().equals("limit") || pair.getName().equals("offset")) continue;
            if (pair.getName().equals("uri")) {
                String pid = pair.getValue();
                String resolveToken = "/resolve/";
                String objectToken = "/object/";
                if (pid.contains(resolveToken)) {
                    pid = pid.split(resolveToken)[1];
                } else if (pid.contains(objectToken)) {
                    pid = pid.split(objectToken)[1];
                }
                solrQuery = solrQuery + URLEncoder.encode("+sem_annotates:\"" + pid + "\"", DEFAULT_ENCODING);
            }
            predicates.add(new AnnotationPredicate(pair.getName(), pair.getValue()));
        }
        solrQuery = solrQuery + URLEncoder.encode("-obsoletedBy:*", DEFAULT_ENCODING);
        solrQuery = solrQuery + "&fl=id,sem_annotates,sem_annotated_by&wt=json&rows=10000";
        log.debug((Object)("solrQuery = " + solrQuery));
        InputStream solrResultStream = this.storageNode.query(this.session, "solr", solrQuery);
        JSONObject solrResults = (JSONObject)JSONValue.parse((InputStream)solrResultStream);
        log.debug((Object)("solrResults = " + solrResults.toJSONString()));
        JSONArray annotations = new JSONArray();
        if (solrResults != null && solrResults.containsKey((Object)"response")) {
            JSONArray solrDocs = (JSONArray)((JSONObject)solrResults.get((Object)"response")).get((Object)"docs");
            log.debug((Object)("solrDocs = " + solrDocs.toJSONString()));
            for (Object solrDoc : solrDocs) {
                log.debug((Object)("solrDoc = " + solrDoc.toString()));
                String id = ((JSONObject)solrDoc).get((Object)"id").toString();
                log.debug((Object)("id = " + id));
                String annotationContent = this.read(id);
                JSONObject annotation = (JSONObject)JSONValue.parse((String)annotationContent);
                log.debug((Object)("annotation = " + annotation));
                annotations.add((Object)annotation);
            }
        }
        Predicate allPredicate = PredicateUtils.allPredicate(predicates);
        CollectionUtils.filter((Collection)annotations, (Predicate)allPredicate);
        if (isList) {
            return annotations.toJSONString();
        }
        JSONObject results = new JSONObject();
        results.put((Object)"total", (Object)annotations.size());
        results.put((Object)"rows", (Object)annotations);
        return results.toJSONString();
    }

    @Override
    public String root() {
        JSONObject versionInfo = new JSONObject();
        versionInfo.put((Object)"name", (Object)"Metacat Annotator Store API");
        versionInfo.put((Object)"version", (Object)"1.2.9");
        return versionInfo.toJSONString();
    }

    @Override
    public String index() throws Exception {
        String query = "limit=-1";
        return this.searchIndex(query, true);
    }

    @Override
    public boolean exists(String id) throws Exception {
        try {
            String object = this.read(id);
            return object != null;
        }
        catch (NotFound e) {
            return false;
        }
    }
}

