/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Probability;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityDataModel;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityDefaultModel;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;

public class ProbabilityFactory {
    public static Probability createIndexModel(Model dataModel, Config config) {
        ProbabilityIndexModel probability = new ProbabilityIndexModel();
        probability.create(dataModel, config);
        return probability;
    }

    public static Probability createIndexModel(Model dataModel) {
        return ProbabilityFactory.createIndexModel(dataModel, new Config());
    }

    public static Model createIndex(Model dataModel, Config config) {
        ProbabilityIndexModel probability = new ProbabilityIndexModel();
        return probability.index(dataModel, config);
    }

    public static Model createIndex(Model dataModel) {
        return ProbabilityFactory.createIndex(dataModel, new Config());
    }

    public static Model createIndex(Graph dataGraph, Config config) {
        return ProbabilityFactory.createIndex(ModelFactory.createModelForGraph((Graph)dataGraph), config);
    }

    public static Model createIndex(Graph dataGraph) {
        return ProbabilityFactory.createIndex(ModelFactory.createModelForGraph((Graph)dataGraph), new Config());
    }

    public static Probability loadDefaultModel(Model dataModel, Model indexModel, Config config) {
        ProbabilityDefaultModel probability = new ProbabilityDefaultModel(dataModel, indexModel, config);
        return probability;
    }

    public static Probability loadDefaultModel(Graph dataGraph, Model indexModel, Config config) {
        return ProbabilityFactory.loadDefaultModel(ModelFactory.createModelForGraph((Graph)dataGraph), indexModel, config);
    }

    public static Probability createDefaultModel(Model dataModel, Config config) {
        Model indexModel = ProbabilityFactory.createIndex(dataModel);
        ProbabilityDefaultModel probability = new ProbabilityDefaultModel(dataModel, indexModel, config);
        return probability;
    }

    public static Probability createDefaultModel(Graph dataGraph, Config config) {
        return ProbabilityFactory.createDefaultModel(ModelFactory.createModelForGraph((Graph)dataGraph), config);
    }

    public static Probability loadIndexModel(Model dataModel, Model indexModel, Config config) {
        ProbabilityIndexModel probability = new ProbabilityIndexModel();
        probability.load(dataModel, indexModel, config);
        return probability;
    }

    public static Probability loadIndexModel(Graph dataGraph, Model indexModel, Config config) {
        return ProbabilityFactory.loadIndexModel(ModelFactory.createModelForGraph((Graph)dataGraph), indexModel, config);
    }

    public static Probability loadDataModel(Model dataModel, Config config) {
        ProbabilityDataModel probability = new ProbabilityDataModel();
        probability.load(dataModel, null, config);
        return probability;
    }

    public static Probability loadDataModel(Graph dataGraph, Config config) {
        return ProbabilityFactory.loadDataModel(ModelFactory.createModelForGraph((Graph)dataGraph), config);
    }
}

