/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Probability;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityDataModel;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;

public class ProbabilityDefaultModel
implements Probability {
    private ProbabilityDataModel probabilityDataModel = new ProbabilityDataModel();
    private ProbabilityIndexModel probabilityIndexModel = new ProbabilityIndexModel();

    public ProbabilityDefaultModel(Model dataModel, Model indexModel, Config config) {
        this.load(dataModel, indexModel, config);
    }

    public void create(Model dataModel, Config config) {
        this.probabilityDataModel.create(dataModel, config);
        this.probabilityIndexModel.create(dataModel, config);
    }

    public void load(Model dataModel, Model indexModel, Config config) {
        this.probabilityDataModel.load(dataModel, indexModel, config);
        this.probabilityIndexModel.load(dataModel, indexModel, config);
    }

    public Model index(Model dataModel, Config config) {
        return this.probabilityIndexModel.index(dataModel, config);
    }

    public Model index(Model dataModel) {
        return this.index(dataModel, new Config());
    }

    public double getProbability(Resource resource) {
        double p = -1.0;
        if (this.probabilityDataModel.isLoaded()) {
            p = this.probabilityDataModel.getProbability(resource);
        }
        if (p < 0.0) {
            p = this.probabilityIndexModel.getProbability(resource);
        }
        return p;
    }

    public double getSelectivity(Resource resource) {
        return this.probabilityIndexModel.getSelectivity(resource);
    }

    public double getProbability(Property property) {
        double p = -1.0;
        if (this.probabilityDataModel.isLoaded()) {
            p = this.probabilityDataModel.getProbability(property);
        }
        if (p < 0.0) {
            p = this.probabilityIndexModel.getProbability(property);
        }
        return p;
    }

    public double getSelectivity(Property property) {
        return this.probabilityIndexModel.getSelectivity(property);
    }

    public double getProbability(Triple triple) {
        double p = -1.0;
        if (this.probabilityDataModel.isLoaded()) {
            p = this.probabilityDataModel.getProbability(triple);
        }
        if (p < 0.0) {
            p = this.probabilityIndexModel.getProbability(triple);
        }
        return p;
    }

    public double getSelectivity(Triple triple) {
        return this.probabilityIndexModel.getSelectivity(triple);
    }

    public double getProbability(Triple triple1, Triple triple2) {
        if (triple2 == null) {
            return this.getProbability(triple1);
        }
        return this.probabilityIndexModel.getProbability(triple1, triple2);
    }

    public double getSelectivity(Triple triple1, Triple triple2) {
        if (triple2 == null) {
            return this.getSelectivity(triple1);
        }
        return this.probabilityIndexModel.getSelectivity(triple1, triple2);
    }
}

