/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterTracked;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public abstract class QueryIter
extends QueryIteratorBase {
    static volatile int iteratorCounter = 0;
    private int iteratorNumber = iteratorCounter++;
    private ExecutionContext tracker;

    public QueryIter(ExecutionContext qCxt) {
        this.tracker = qCxt;
        this.register();
    }

    public static QueryIter makeTracked(QueryIterator qIter, ExecutionContext qCxt) {
        if (qIter instanceof QueryIter) {
            return (QueryIter)qIter;
        }
        return new QueryIterTracked(qIter, qCxt);
    }

    public final void close() {
        super.close();
        this.deregister();
    }

    public ExecutionContext getExecContext() {
        return this.tracker;
    }

    public int getIteratorNumber() {
        return this.iteratorNumber;
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(this.getIteratorNumber() + "/" + this.debug());
    }

    private void register() {
        if (this.tracker != null) {
            this.tracker.openIterator(this);
        }
    }

    private void deregister() {
        if (this.tracker != null) {
            this.tracker.closedIterator(this);
        }
    }
}

