/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpStage;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterFilterExpr;
import com.hp.hpl.jena.sparql.engine.main.OpCompiler;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class FilterPlacement {
    private OpCompiler compiler;
    private ExecutionContext execCxt;
    boolean doFilterPlacement = false;

    public FilterPlacement(OpCompiler compiler, ExecutionContext execCxt) {
        this.compiler = compiler;
        this.execCxt = execCxt;
        this.doFilterPlacement = execCxt.getContext().isTrueOrUndef(ARQ.filterPlacement);
    }

    public QueryIterator placeFiltersBGP(ExprList exprs, BasicPattern pattern, QueryIterator input) {
        if (!this.doFilterPlacement) {
            QueryIterator qIter = StageBuilder.compile(pattern, input, this.execCxt);
            return this.buildFilter(exprs, qIter);
        }
        HashSet patternVarsScope = new HashSet();
        BasicPattern accPattern = new BasicPattern();
        QueryIterator qIter = this.insertAnyFilter(exprs = new ExprList(exprs), patternVarsScope, accPattern, input);
        if (qIter == null) {
            qIter = input;
        }
        qIter = this.placeFilters(exprs, pattern, patternVarsScope, qIter);
        qIter = this.buildFilter(exprs, qIter);
        return qIter;
    }

    private QueryIterator placeFilters(ExprList exprs, BasicPattern pattern, Set varScope, QueryIterator input) {
        BasicPattern accPattern = new BasicPattern();
        QueryIterator qIter = input;
        if ((qIter = this.insertAnyFilter(exprs, varScope, accPattern, qIter)) == null) {
            qIter = input;
        }
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            accPattern.add(triple);
            VarUtils.addVarsFromTriple(varScope, triple);
            QueryIterator qIter2 = this.insertAnyFilter(exprs, varScope, accPattern, qIter);
            if (qIter2 == null) continue;
            accPattern = new BasicPattern();
            qIter = qIter2;
        }
        qIter = StageBuilder.compile(accPattern, qIter, this.execCxt);
        return qIter;
    }

    private QueryIterator insertAnyFilter(ExprList exprs, Set patternVarsScope, BasicPattern accPattern, QueryIterator qIter) {
        boolean doneSomething = false;
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            Set exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            QueryIterator qIter2 = this.buildPatternFilter(expr, accPattern, qIter);
            iter.remove();
            qIter = qIter2;
            doneSomething = true;
        }
        return doneSomething ? qIter : null;
    }

    public QueryIterator placeFiltersStage(ExprList exprs, OpStage opStage, QueryIterator input) {
        if (!this.doFilterPlacement) {
            return this.buildOpFilter(exprs, (Op)opStage, input);
        }
        HashSet varScope = new HashSet();
        QueryIterator qIter = this.placeFilters(exprs, opStage, varScope, input);
        qIter = this.buildFilter(exprs, qIter);
        return qIter;
    }

    private QueryIterator placeFilters(ExprList exprs, OpStage opStage, Set varScope, QueryIterator input) {
        List ops = FilterPlacement.stages(opStage);
        return this.placeFilters(exprs, ops, varScope, input);
    }

    public QueryIterator placeFiltersJoin(ExprList exprs, OpJoin opJoin, QueryIterator input) {
        if (!this.doFilterPlacement) {
            return this.buildOpFilter(exprs, (Op)opJoin, input);
        }
        HashSet varScope = new HashSet();
        QueryIterator qIter = this.placeFilters(exprs, opJoin, varScope, input);
        qIter = this.buildFilter(exprs, qIter);
        return qIter;
    }

    private QueryIterator placeFilters(ExprList exprs, OpJoin opJoin, Set varScope, QueryIterator input) {
        List ops = FilterPlacement.joins(opJoin);
        return this.placeFilters(exprs, ops, varScope, input);
    }

    public QueryIterator placeFiltersProcedure(ExprList exprs, OpProcedure opProc, QueryIterator input) {
        if (!this.doFilterPlacement) {
            return this.buildOpFilter(exprs, (Op)opProc, input);
        }
        HashSet varScope = new HashSet();
        QueryIterator qIter = this.placeFilters(exprs, opProc, varScope, input);
        qIter = this.buildFilter(exprs, qIter);
        return qIter;
    }

    private QueryIterator placeFilters(ExprList exprs, OpProcedure opProc, Set varScope, QueryIterator input) {
        return this.compiler.compileOp(opProc, input);
    }

    private QueryIterator placeFilters(ExprList exprs, List ops, Set varScope, QueryIterator input) {
        QueryIterator qIter = input;
        if ((qIter = this.insertAnyFilter(exprs, varScope, qIter)) == null) {
            qIter = input;
        }
        Iterator iter = ops.iterator();
        while (iter.hasNext()) {
            Op op = (Op)iter.next();
            if (op instanceof OpBGP) {
                OpBGP bgp = (OpBGP)op;
                BasicPattern pattern = bgp.getPattern();
                qIter = this.placeFilters(exprs, pattern, varScope, qIter);
            } else {
                qIter = op instanceof OpStage ? this.placeFilters(exprs, (OpStage)op, varScope, qIter) : (op instanceof OpJoin ? this.placeFilters(exprs, (OpJoin)op, varScope, qIter) : (op instanceof OpProcedure ? this.placeFilters(exprs, (OpProcedure)op, varScope, qIter) : this.compiler.compileOp(op, qIter)));
            }
            OpVars.patternVars(op, varScope);
            qIter = this.insertAnyFilter(exprs, varScope, qIter);
        }
        return qIter;
    }

    private static List stages(OpStage base) {
        ArrayList stages = new ArrayList();
        FilterPlacement.stages(base, stages);
        return stages;
    }

    private static void stages(Op base, List stages) {
        while (base instanceof OpStage) {
            OpStage join = (OpStage)base;
            Op left = join.getLeft();
            FilterPlacement.stages(left, stages);
            base = join.getRight();
        }
        stages.add(base);
    }

    private static List joins(OpJoin base) {
        ArrayList joinElts = new ArrayList();
        FilterPlacement.joins(base, joinElts);
        return joinElts;
    }

    private static void joins(Op base, List joinElts) {
        while (base instanceof OpJoin) {
            OpJoin join = (OpJoin)base;
            Op left = join.getLeft();
            FilterPlacement.joins(left, joinElts);
            base = join.getRight();
        }
        joinElts.add(base);
    }

    private QueryIterator insertAnyFilter(ExprList exprs, Set varScope, QueryIterator qIter) {
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            Set exprVars = expr.getVarsMentioned();
            if (!varScope.containsAll(exprVars)) continue;
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
            iter.remove();
        }
        return qIter;
    }

    public QueryIterator buildOpFilter(ExprList exprs, Op sub, QueryIterator input) {
        QueryIterator qIter = this.compiler.compileOp(sub, input);
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        }
        return qIter;
    }

    private QueryIterator buildOpFilter(Expr expr, Op op, QueryIterator input) {
        QueryIterator qIter = this.compiler.compileOp(op, input);
        qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        return qIter;
    }

    private QueryIterator buildPatternFilter(Expr expr, BasicPattern pattern, QueryIterator input) {
        QueryIterator qIter = StageBuilder.compile(pattern, input, this.execCxt);
        qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        return qIter;
    }

    private QueryIterator buildFilter(ExprList exprs, QueryIterator qIter) {
        if (exprs.isEmpty()) {
            return qIter;
        }
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
            iter.remove();
        }
        return qIter;
    }
}

