/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.query.ARQ;
import java.lang.reflect.Field;

public class ModVersion
implements ArgModuleGeneral {
    protected final ArgDecl versionDecl = new ArgDecl(false, "version");
    protected boolean version = false;
    protected boolean printAndExit = false;
    private static String[] fields = new String[]{"NAME", "VERSION", "BUILD_DATE"};

    public ModVersion(boolean printAndExit) {
        this.printAndExit = printAndExit;
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.versionDecl, "version", "Version information");
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.versionDecl)) {
            this.version = true;
        }
        if (this.version && this.printAndExit) {
            ModVersion.printVersionAndExit();
        }
    }

    public boolean getVersionFlag() {
        return this.version;
    }

    public static void printVersion() {
        ModVersion.fields("Jena", Jena.class);
        ModVersion.fields("ARQ ", ARQ.class);
    }

    public static void printVersionAndExit() {
        ModVersion.printVersion();
        System.exit(0);
    }

    private static void fields(String prefix, Class cls) {
        for (int i = 0; i < fields.length; ++i) {
            ModVersion.printField(prefix, fields[i], cls);
        }
    }

    private static void printField(String prefix, String fieldName, Class cls) {
        try {
            Field f = cls.getDeclaredField(fieldName);
            System.out.println(prefix + ": " + f.getName() + ": " + f.get(null));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }
}

