/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModAlgebra;
import arq.cmdline.ModDataset;
import arq.cmdline.ModDatasetAssembler;
import arq.cmdline.ModEngine;
import arq.cmdline.ModResultsOut;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.PlanOp;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.OutputStream;
import java.util.Iterator;

public class sse_query
extends CmdARQ {
    protected final ArgDecl printDecl = new ArgDecl(true, "print");
    ModAlgebra modAlgebra = new ModAlgebra();
    ModDataset modDataset = new ModDatasetAssembler();
    ModResultsOut modResults = new ModResultsOut();
    ModTime modTime = new ModTime();
    ModEngine modEngine = new ModEngine();
    boolean printOp = false;
    boolean printPlan = false;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String[] argv) {
        new sse_query(argv).main();
    }

    public sse_query(String[] argv) {
        super(argv);
        super.add(this.printDecl, "--print=op/plan", "Print details");
        super.addModule(this.modAlgebra);
        super.addModule(this.modResults);
        super.addModule(this.modDataset);
        super.addModule(this.modTime);
        super.addModule(this.modEngine);
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        Iterator iter = this.getValues(this.printDecl).iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (arg.equalsIgnoreCase("op") || arg.equalsIgnoreCase("alg") || arg.equalsIgnoreCase("algebra")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad");
        }
    }

    protected String getCommandName() {
        return Utils.className((Object)this);
    }

    protected String getSummary() {
        return this.getCommandName() + " --data=<file> --query=<query>";
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec() {
        Op op = this.modAlgebra.getOp();
        if (op == null) {
            System.err.println("No query expression to execute");
            throw new TerminationException(9);
        }
        Dataset dataset = this.modDataset.getDataset();
        if (dataset == null) {
            dataset = new DataSourceImpl();
        }
        this.modTime.startTimer();
        DataSourceGraphImpl dsg = new DataSourceGraphImpl(dataset);
        if (this.printOp || this.printPlan) {
            if (this.printOp) {
                this.divider();
                IndentedWriter out = new IndentedWriter((OutputStream)System.out, true);
                op.output(out);
                out.flush();
            }
            if (this.printPlan) {
                QueryIterator qIter = Algebra.exec((Op)op, (DatasetGraph)dsg);
                PlanOp plan = new PlanOp(op, qIter);
                this.divider();
                IndentedWriter out = new IndentedWriter((OutputStream)System.out, false);
                plan.output(out);
                out.flush();
            }
            return;
        }
        QueryExecUtils.executeAlgebra((Op)op, (DatasetGraph)dsg, (ResultsFormat)this.modResults.getResultsFormat());
        long time = this.modTime.endTimer();
        if (this.modTime.timingEnabled()) {
            System.out.println("Time: " + this.modTime.timeStr(time));
        }
    }
}

