/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Lock {
    static final int RELEASE_NOT_OWNER = 0;
    static final int RELEASE_NOTIFY = 1;
    static final int RELEASE_NO_NOTIFY = 2;
    private LockInfo firstOwner;
    private Set ownerSet;
    private LockInfo firstWaiter;
    private List waiterList;
    private long nodeId;
    static final /* synthetic */ boolean $assertionsDisabled;

    Lock(long nodeId) {
        this.nodeId = nodeId;
    }

    long getNodeId() {
        return this.nodeId;
    }

    private void addWaiterToEndOfList(LockInfo waiter) {
        if (this.waiterList == null) {
            if (this.firstWaiter == null) {
                this.firstWaiter = waiter;
            } else {
                this.waiterList = new ArrayList();
                this.waiterList.add(waiter);
            }
        } else {
            this.waiterList.add(waiter);
        }
    }

    private void addWaiterToHeadOfList(LockInfo waiter) {
        if (this.firstWaiter != null) {
            if (this.waiterList == null) {
                this.waiterList = new ArrayList();
            }
            this.waiterList.add(0, this.firstWaiter);
        }
        this.firstWaiter = waiter;
    }

    List getWaitersListClone() {
        ArrayList<LockInfo> dumpWaiters = new ArrayList<LockInfo>();
        if (this.firstWaiter != null) {
            dumpWaiters.add(this.firstWaiter);
        }
        if (this.waiterList != null) {
            dumpWaiters.addAll(this.waiterList);
        }
        return dumpWaiters;
    }

    void flushWaiter(Locker locker) {
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == locker) {
            this.firstWaiter = null;
        } else if (this.waiterList != null) {
            Iterator iter = this.waiterList.iterator();
            while (iter.hasNext()) {
                LockInfo info = (LockInfo)iter.next();
                if (info.getLocker() != locker) continue;
                iter.remove();
                return;
            }
        }
    }

    private void addOwner(LockInfo newLock) {
        if (this.firstOwner == null) {
            this.firstOwner = newLock;
        } else {
            if (this.ownerSet == null) {
                this.ownerSet = new HashSet();
            }
            this.ownerSet.add(newLock);
        }
    }

    Set getOwnersClone() {
        HashSet<LockInfo> owners = this.ownerSet != null ? new HashSet(this.ownerSet) : new HashSet<LockInfo>();
        if (this.firstOwner != null) {
            owners.add(this.firstOwner);
        }
        return owners;
    }

    private boolean flushOwner(LockInfo oldOwner) {
        boolean removed = false;
        if (oldOwner != null) {
            if (this.firstOwner == oldOwner) {
                this.firstOwner = null;
                return true;
            }
            if (this.ownerSet != null) {
                removed = this.ownerSet.remove(oldOwner);
            }
        }
        return removed;
    }

    private LockInfo flushOwner(Locker locker) {
        if (this.firstOwner != null && this.firstOwner.getLocker() == locker) {
            LockInfo flushed = this.firstOwner;
            this.firstOwner = null;
            return flushed;
        }
        if (this.ownerSet != null) {
            Iterator iter = this.ownerSet.iterator();
            while (iter.hasNext()) {
                LockInfo o = (LockInfo)iter.next();
                if (o.getLocker() != locker) continue;
                iter.remove();
                return o;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LockGrantType lock(LockType requestType, Locker locker, boolean nonBlockingRequest) throws DatabaseException {
        if (!$assertionsDisabled && !this.validateRequest(locker)) {
            throw new AssertionError();
        }
        LockInfo newLock = new LockInfo(locker, requestType);
        int numOwners = this.nOwners();
        if (numOwners == 0) {
            this.addOwner(newLock);
            return LockGrantType.NEW;
        }
        boolean allOwnersAreReaders = true;
        boolean allOwnersShareLocks = true;
        LockInfo lockToPromote = null;
        LockInfo owner = null;
        Iterator iter = null;
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
        }
        if (this.firstOwner != null) {
            owner = this.firstOwner;
        } else if (iter != null && iter.hasNext()) {
            owner = (LockInfo)iter.next();
        }
        while (owner != null) {
            if (owner.getLocker() == locker) {
                if (!owner.isReadLock()) return LockGrantType.EXISTING;
                if (requestType != LockType.WRITE) return LockGrantType.EXISTING;
                if (!$assertionsDisabled && lockToPromote != null) {
                    throw new AssertionError();
                }
                lockToPromote = owner;
            }
            if (allOwnersAreReaders && !owner.isReadLock()) {
                allOwnersAreReaders = false;
            }
            if (allOwnersShareLocks && !locker.sharesLocksWith(owner.getLocker())) {
                allOwnersShareLocks = false;
            }
            if (iter != null && iter.hasNext()) {
                owner = (LockInfo)iter.next();
                continue;
            }
            owner = null;
        }
        if (lockToPromote != null) {
            if (numOwners == 1 || allOwnersShareLocks) {
                lockToPromote.setLockType(requestType);
                return LockGrantType.PROMOTION;
            }
            if (nonBlockingRequest) return LockGrantType.DENIED;
            this.addWaiterToHeadOfList(newLock);
            return LockGrantType.WAIT_PROMOTION;
        }
        if (allOwnersShareLocks || requestType == LockType.READ && allOwnersAreReaders && this.nWaiters() == 0) {
            this.addOwner(newLock);
            return LockGrantType.NEW;
        }
        if (nonBlockingRequest) return LockGrantType.DENIED;
        this.addWaiterToEndOfList(newLock);
        return LockGrantType.WAIT_NEW;
    }

    private LockInfo getOwnerLockInfo(Locker locker) {
        if (this.firstOwner != null && this.firstOwner.getLocker() == locker) {
            return this.firstOwner;
        }
        if (this.ownerSet != null) {
            Iterator iter = this.ownerSet.iterator();
            while (iter.hasNext()) {
                LockInfo o = (LockInfo)iter.next();
                if (o.getLocker() != locker) continue;
                return o;
            }
        }
        return null;
    }

    boolean isOwner(Locker locker, LockType lockType) {
        LockInfo o = this.getOwnerLockInfo(locker);
        if (o != null) {
            LockType ownedLockType = o.getLockType();
            if (lockType == null || ownedLockType == lockType || ownedLockType == LockType.WRITE && lockType == LockType.READ) {
                return true;
            }
        }
        return false;
    }

    boolean isOwnedWriteLock(Locker locker) {
        LockInfo o = this.getOwnerLockInfo(locker);
        return o != null && o.isWriteLock();
    }

    boolean isWaiter(Locker locker) {
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == locker) {
            return true;
        }
        if (this.waiterList != null) {
            Iterator iter = this.waiterList.iterator();
            while (iter.hasNext()) {
                LockInfo info = (LockInfo)iter.next();
                if (info.getLocker() != locker) continue;
                return true;
            }
        }
        return false;
    }

    int nWaiters() {
        int count = 0;
        if (this.firstWaiter != null) {
            ++count;
        }
        if (this.waiterList != null) {
            count += this.waiterList.size();
        }
        return count;
    }

    int nOwners() {
        int count = 0;
        if (this.firstOwner != null) {
            ++count;
        }
        if (this.ownerSet != null) {
            count += this.ownerSet.size();
        }
        return count;
    }

    int release(Locker locker) {
        LockInfo removedLock = this.flushOwner(locker);
        if (removedLock == null) {
            return 0;
        }
        if (this.nWaiters() == 0) {
            return 2;
        }
        boolean allOwnersShareLocks = true;
        boolean allOwnersAreReaders = true;
        Locker anyOwnerLocker = null;
        LockInfo owner = null;
        Iterator iter = null;
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
        }
        if (this.firstOwner != null) {
            owner = this.firstOwner;
        } else if (iter != null && iter.hasNext()) {
            owner = (LockInfo)iter.next();
        }
        while (owner != null) {
            if (allOwnersAreReaders && !owner.isReadLock()) {
                allOwnersAreReaders = false;
            }
            if (allOwnersShareLocks && anyOwnerLocker != null && !anyOwnerLocker.sharesLocksWith(owner.getLocker())) {
                allOwnersShareLocks = false;
            }
            anyOwnerLocker = owner.getLocker();
            if (iter != null && iter.hasNext()) {
                owner = (LockInfo)iter.next();
                continue;
            }
            owner = null;
        }
        boolean notifyOwners = false;
        LockInfo waiter = null;
        iter = null;
        boolean isFirstWaiter = false;
        if (this.waiterList != null) {
            iter = this.waiterList.iterator();
        }
        if (this.firstWaiter != null) {
            waiter = this.firstWaiter;
            isFirstWaiter = true;
        } else if (iter != null && iter.hasNext()) {
            waiter = (LockInfo)iter.next();
        }
        while (waiter != null) {
            if (allOwnersAreReaders && !waiter.isReadLock()) {
                allOwnersAreReaders = false;
            }
            if (allOwnersShareLocks && anyOwnerLocker != null && !anyOwnerLocker.sharesLocksWith(waiter.getLocker())) {
                allOwnersShareLocks = false;
            }
            Locker waiterLocker = waiter.getLocker();
            if (anyOwnerLocker != null && !allOwnersShareLocks && !allOwnersAreReaders && (this.nOwners() != 1 || anyOwnerLocker != waiterLocker)) break;
            owner = this.getOwnerLockInfo(waiterLocker);
            if (owner == null) {
                this.addOwner(waiter);
            } else {
                LockType waiterType = waiter.getLockType();
                if (waiterType == LockType.WRITE) {
                    owner.setLockType(waiterType);
                }
            }
            if (isFirstWaiter) {
                this.firstWaiter = null;
            } else {
                iter.remove();
            }
            anyOwnerLocker = waiter.getLocker();
            notifyOwners = true;
            if (iter != null && iter.hasNext()) {
                waiter = (LockInfo)iter.next();
                isFirstWaiter = false;
                continue;
            }
            waiter = null;
        }
        return notifyOwners ? 1 : 2;
    }

    void demote(Locker locker) {
        LockInfo owner = this.getOwnerLockInfo(locker);
        if (owner != null && owner.isWriteLock()) {
            owner.setLockType(LockType.READ);
            return;
        }
    }

    LockType transfer(Locker currentLocker, Locker destLocker) throws DatabaseException {
        Iterator iter;
        LockType lockType = null;
        if (this.firstOwner != null) {
            if (this.firstOwner.getLocker() == destLocker) {
                this.firstOwner = null;
            } else if (this.firstOwner.getLocker() == currentLocker) {
                lockType = this.setNewLocker(this.firstOwner, destLocker);
            }
        }
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
            while (iter.hasNext()) {
                LockInfo owner = (LockInfo)iter.next();
                if (owner.getLocker() == destLocker) {
                    iter.remove();
                    continue;
                }
                if (owner.getLocker() != currentLocker) continue;
                lockType = this.setNewLocker(owner, destLocker);
            }
        }
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == destLocker) {
            this.firstWaiter = null;
        }
        if (this.waiterList != null) {
            iter = this.waiterList.iterator();
            while (iter.hasNext()) {
                LockInfo info = (LockInfo)iter.next();
                if (info.getLocker() != destLocker) continue;
                iter.remove();
            }
        }
        return lockType;
    }

    private LockType setNewLocker(LockInfo owner, Locker destLocker) throws DatabaseException {
        owner.setLocker(destLocker);
        destLocker.addLock(this.nodeId, this, owner.getLockType(), LockGrantType.NEW);
        return owner.getLockType();
    }

    LockType transferMultiple(Locker currentLocker, Locker[] destLockers) throws DatabaseException {
        int i;
        LockInfo o;
        int i2;
        LockType lockType = null;
        LockInfo oldOwner = null;
        if (destLockers.length == 1) {
            return this.transfer(currentLocker, destLockers[0]);
        }
        if (this.firstOwner != null) {
            for (i2 = 0; i2 < destLockers.length; ++i2) {
                if (this.firstOwner.getLocker() != destLockers[i2]) continue;
                this.firstOwner = null;
                break;
            }
        }
        if (this.ownerSet != null) {
            Iterator ownersIter = this.ownerSet.iterator();
            block1: while (ownersIter.hasNext()) {
                o = (LockInfo)ownersIter.next();
                for (i = 0; i < destLockers.length; ++i) {
                    if (o.getLocker() != destLockers[i]) continue;
                    ownersIter.remove();
                    continue block1;
                }
            }
        }
        if (this.firstOwner != null) {
            oldOwner = this.cloneLockInfo(this.firstOwner, currentLocker, destLockers);
        }
        if (this.ownerSet != null && oldOwner == null) {
            Iterator ownersIter = this.ownerSet.iterator();
            while (ownersIter.hasNext() && (oldOwner = this.cloneLockInfo(o = (LockInfo)ownersIter.next(), currentLocker, destLockers)) == null) {
            }
        }
        if (this.firstWaiter != null) {
            for (i2 = 0; i2 < destLockers.length; ++i2) {
                if (this.firstWaiter.getLocker() != destLockers[i2]) continue;
                this.firstWaiter = null;
                break;
            }
        }
        if (this.waiterList != null) {
            Iterator iter = this.waiterList.iterator();
            block5: while (iter.hasNext()) {
                o = (LockInfo)iter.next();
                for (i = 0; i < destLockers.length; ++i) {
                    if (o.getLocker() != destLockers[i]) continue;
                    iter.remove();
                    continue block5;
                }
            }
        }
        boolean removed = this.flushOwner(oldOwner);
        if (!$assertionsDisabled && !removed) {
            throw new AssertionError();
        }
        return lockType;
    }

    private LockInfo cloneLockInfo(LockInfo oldOwner, Locker currentLocker, Locker[] destLockers) throws DatabaseException {
        if (oldOwner.getLocker() == currentLocker) {
            try {
                LockType lockType = oldOwner.getLockType();
                for (int i = 0; i < destLockers.length; ++i) {
                    LockInfo clonedLockInfo = (LockInfo)oldOwner.clone();
                    clonedLockInfo.setLocker(destLockers[i]);
                    destLockers[i].addLock(this.nodeId, this, lockType, LockGrantType.NEW);
                    this.addOwner(clonedLockInfo);
                }
                return oldOwner;
            }
            catch (CloneNotSupportedException e) {
                throw new DatabaseException(e);
            }
        }
        return null;
    }

    Locker getWriteOwnerLocker() {
        Iterator iter;
        LockInfo foundOwner = null;
        if (this.firstOwner != null) {
            if (this.ownerSet == null || this.ownerSet.size() == 0) {
                foundOwner = this.firstOwner;
            }
        } else if (this.ownerSet != null && this.ownerSet.size() == 1 && (iter = this.ownerSet.iterator()).hasNext()) {
            foundOwner = (LockInfo)iter.next();
        }
        if (foundOwner != null && foundOwner.getLockType() == LockType.WRITE) {
            return foundOwner.getLocker();
        }
        return null;
    }

    private boolean validateRequest(Locker locker) {
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == locker && !$assertionsDisabled) {
            throw new AssertionError((Object)("locker " + locker + " is already on waiters list."));
        }
        if (this.waiterList != null) {
            Iterator iter = this.waiterList.iterator();
            while (iter.hasNext()) {
                LockInfo o = (LockInfo)iter.next();
                if (o.getLocker() == locker && !$assertionsDisabled) {
                    throw new AssertionError((Object)("locker " + locker + " is already on waiters list."));
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" NodeId:").append(this.nodeId);
        sb.append(" Owners:");
        if (this.nOwners() == 0) {
            sb.append(" (none)");
        } else {
            if (this.firstOwner != null) {
                sb.append(this.firstOwner);
            }
            if (this.ownerSet != null) {
                Iterator iter = this.ownerSet.iterator();
                while (iter.hasNext()) {
                    LockInfo info = (LockInfo)iter.next();
                    sb.append(info);
                }
            }
        }
        sb.append(" Waiters:");
        if (this.nWaiters() == 0) {
            sb.append(" (none)");
        } else {
            sb.append(this.getWaitersListClone());
        }
        return sb.toString();
    }

    static {
        $assertionsDisabled = !Lock.class.desiredAssertionStatus();
    }
}

