/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseEntry;

public class RecordNumberBinding
implements EntryBinding {
    public Object entryToObject(DatabaseEntry entry) {
        return new Long(RecordNumberBinding.entryToRecordNumber(entry));
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        RecordNumberBinding.recordNumberToEntry(((Number)object).longValue(), entry);
    }

    public static long entryToRecordNumber(DatabaseEntry entry) {
        return (long)DbCompat.getRecordNumber(entry) & 0xFFFFFFFFL;
    }

    public static void recordNumberToEntry(long recordNumber, DatabaseEntry entry) {
        entry.setData(new byte[4], 0, 4);
        DbCompat.setRecordNumber(entry, (int)recordNumber);
    }
}

