/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGIdentifier;
import com.hp.hpl.jena.reasoner.dig.DIGProfile;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAllConceptsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAncestorsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryClassHierarchyTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryDifferentFromTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryDisjointTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryEquivalentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryInstanceTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryInstancesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsConceptTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsEquivalentTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsIndividualTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsRoleTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryParentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRelatedIndividualsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleAncestorsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleFillerTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleFillersTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleHierarchyTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleParentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQuerySubsumesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTypesTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DIGAdapter {
    public static final DIGProfile RACER_17_PROFILE = new DIGProfile(){

        public String getDIGNamespace() {
            return "http://dl.kr.org/dig/lang";
        }

        public String getSchemaLocation() {
            return "http://potato.cs.man.ac.uk/dig/level0/dig.xsd";
        }

        public String getContentType() {
            return "application/x-www-form-urlencoded";
        }

        public String getInconsistentKBMessage() {
            return null;
        }
    };
    public static final DIGProfile PELLET_PROFILE = new DIGProfile(){

        public String getDIGNamespace() {
            return "http://dl.kr.org/dig/lang";
        }

        public String getSchemaLocation() {
            return "http://potato.cs.man.ac.uk/dig/level0/dig.xsd";
        }

        public String getContentType() {
            return "application/x-www-form-urlencoded";
        }

        public String getInconsistentKBMessage() {
            return "Inconsistent KB";
        }
    };
    private static final int UNION = 1;
    private static final int INTERSECTION = 2;
    private static final int COMPLEMENT = 3;
    private static final int ENUMERATED = 4;
    private static final int RESTRICTION = 5;
    public static final String ANON_MARKER = "anon:";
    public static final List KNOWN_CONCEPTS = Arrays.asList(OWL.Thing.getURI(), OWL.Nothing.getURI(), DAML_OIL.Thing.getURI(), DAML_OIL.Thing.getURI());
    public static final List XSD_INT_TYPES = Arrays.asList(XSDDatatype.XSDint.getURI(), XSDDatatype.XSDinteger.getURI(), XSDDatatype.XSDnonNegativeInteger.getURI(), XSDDatatype.XSDbyte.getURI(), XSDDatatype.XSDshort.getURI(), XSDDatatype.XSDlong.getURI(), XSDDatatype.XSDunsignedByte.getURI(), XSDDatatype.XSDunsignedLong.getURI(), XSDDatatype.XSDunsignedInt.getURI(), XSDDatatype.XSDunsignedShort.getURI());
    private static int s_queryID = 0;
    protected static DIGQueryTranslator[] s_queryTable = new DIGQueryTranslator[]{new DIGQuerySubsumesTranslator(RDFS.subClassOf.getURI()), new DIGQuerySubsumesTranslator(DAML_OIL.subClassOf.getURI()), new DIGQueryDisjointTranslator(OWL.disjointWith.getURI()), new DIGQueryDisjointTranslator(DAML_OIL.disjointWith.getURI()), new DIGQueryAncestorsTranslator(RDFS.subClassOf.getURI(), true), new DIGQueryAncestorsTranslator(RDFS.subClassOf.getURI(), false), new DIGQueryAncestorsTranslator(DAML_OIL.subClassOf.getURI(), true), new DIGQueryAncestorsTranslator(DAML_OIL.subClassOf.getURI(), false), new DIGQueryParentsTranslator(ReasonerVocabulary.directSubClassOf.getURI(), true), new DIGQueryParentsTranslator(ReasonerVocabulary.directSubClassOf.getURI(), false), new DIGQueryParentsTranslator(null, ReasonerVocabulary.directSubClassOf.getURI(), null, true), new DIGQueryParentsTranslator(null, ReasonerVocabulary.directSubClassOf.getURI(), null, false), new DIGQueryClassHierarchyTranslator(RDFS.subClassOf.getURI()), new DIGQueryClassHierarchyTranslator(DAML_OIL.subClassOf.getURI()), new DIGQueryEquivalentsTranslator(OWL.equivalentClass.getURI(), true), new DIGQueryEquivalentsTranslator(OWL.equivalentClass.getURI(), false), new DIGQueryEquivalentsTranslator(DAML_OIL.sameClassAs.getURI(), true), new DIGQueryEquivalentsTranslator(DAML_OIL.sameClassAs.getURI(), false), new DIGQueryIsEquivalentTranslator(OWL.equivalentClass.getURI()), new DIGQueryIsEquivalentTranslator(DAML_OIL.sameClassAs.getURI()), new DIGQueryRoleAncestorsTranslator(RDFS.subPropertyOf.getURI(), true), new DIGQueryRoleAncestorsTranslator(RDFS.subPropertyOf.getURI(), false), new DIGQueryRoleAncestorsTranslator(DAML_OIL.subPropertyOf.getURI(), true), new DIGQueryRoleAncestorsTranslator(DAML_OIL.subPropertyOf.getURI(), false), new DIGQueryRoleParentsTranslator(ReasonerVocabulary.directSubPropertyOf.getURI(), true), new DIGQueryRoleParentsTranslator(ReasonerVocabulary.directSubPropertyOf.getURI(), false), new DIGQueryRoleHierarchyTranslator(RDFS.subPropertyOf.getURI()), new DIGQueryRoleHierarchyTranslator(DAML_OIL.subPropertyOf.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), RDFS.Class.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), OWL.Class.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), DAML_OIL.Class.getURI()), new DIGQueryInstancesTranslator(RDF.type.getURI()), new DIGQueryInstancesTranslator(DAML_OIL.type.getURI()), new DIGQueryTypesTranslator(RDF.type.getURI()), new DIGQueryTypesTranslator(DAML_OIL.type.getURI()), new DIGQueryInstanceTranslator(RDF.type.getURI()), new DIGQueryInstanceTranslator(DAML_OIL.type.getURI()), new DIGQueryDifferentFromTranslator(OWL.differentFrom.getURI()), new DIGQueryDifferentFromTranslator(DAML_OIL.differentIndividualFrom.getURI()), new DIGQueryRoleFillersTranslator(), new DIGQueryRoleFillerTranslator(), new DIGQueryRelatedIndividualsTranslator(), new DIGQueryIsConceptTranslator(), new DIGQueryIsRoleTranslator(), new DIGQueryIsIndividualTranslator()};
    protected DIGProfile m_profile = PELLET_PROFILE;
    protected OntModel m_sourceData;
    private int m_skolemCounter = 0;
    private DIGConnection m_connection;
    protected Set m_indNames = new HashSet();
    protected boolean m_indNamesAsked = false;
    protected Set m_conceptNames = new HashSet();
    protected boolean m_conceptNamesAsked = false;
    protected Set m_roleNames = new HashSet();
    protected boolean m_roleNamesAsked = false;
    protected Model m_axioms = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllDifferent;

    public DIGAdapter(OntModelSpec spec, Graph source) {
        this(spec, source, DIGConnectionPool.getInstance().allocate(), null);
    }

    public DIGAdapter(OntModelSpec spec, Graph source, DIGConnection connection, Model axioms) {
        this.m_connection = connection;
        this.m_axioms = axioms;
        this.m_sourceData = ModelFactory.createOntologyModel(spec, ModelFactory.createModelForGraph(source));
        this.m_sourceData.setStrictMode(false);
    }

    public DIGProfile getProfile() {
        return this.m_profile;
    }

    public void setProfile(DIGProfile profile) {
        this.m_profile = profile;
    }

    public Profile getOntLanguage() {
        return this.m_sourceData.getProfile();
    }

    public DIGIdentifier getDigIdentifier() {
        Document getIDVerb = this.getConnection().createDigVerb("getIdentifier", this.getProfile());
        return new DigIdentifierImpl(this.getConnection().sendDigVerb(getIDVerb, this.getProfile()));
    }

    public boolean uploadKB() {
        this.getConnection().bindKB(false, this.getProfile());
        Document kbDIG = this.translateKbToDig();
        Document response = this.getConnection().sendDigVerb(kbDIG, this.getProfile());
        return !this.getConnection().warningCheck(response);
    }

    public Iterator getRecentWarnings() {
        return this.getConnection().getWarnings();
    }

    public Document translateKbToDig() {
        Document tell = this.getConnection().createDigVerb("tells", this.getProfile());
        Element root = tell.getDocumentElement();
        this.addNamedEntities(root);
        this.translateClasses(root);
        this.translateRoles(root);
        this.translateAttributes(root);
        this.translateIndividuals(root);
        this.translateAllDifferentAxioms(root);
        return tell;
    }

    public void resetKB() {
        this.getConnection().bindKB(true, this.getProfile());
        this.m_indNames.clear();
        this.m_indNamesAsked = false;
        this.m_conceptNames.clear();
        this.m_conceptNamesAsked = false;
        this.m_roleNames.clear();
        this.m_roleNamesAsked = false;
    }

    public DIGConnection getConnection() {
        return this.m_connection;
    }

    public void close() {
        this.getConnection().release();
        this.m_connection = null;
    }

    public ExtendedIterator find(TriplePattern pattern) {
        DIGQueryTranslator tr = this.getQueryTranslator(pattern, null);
        ExtendedIterator remote = tr == null ? null : tr.find(pattern, this);
        Node pSubj = this.normaliseNode(pattern.getSubject());
        Node pPred = this.normaliseNode(pattern.getPredicate());
        Node pObj = this.normaliseNode(pattern.getObject());
        ExtendedIterator local = this.m_sourceData.getGraph().find(pSubj, pPred, pObj);
        ExtendedIterator i = remote == null ? local : remote.andThen(local);
        i = this.m_axioms == null ? i : i.andThen(this.m_axioms.getGraph().find(pSubj, pPred, pObj));
        return UniqueExtendedIterator.create(i);
    }

    public ExtendedIterator find(TriplePattern pattern, Model premises) {
        DIGQueryTranslator tr = this.getQueryTranslator(pattern, premises);
        if (tr == null) {
            LogFactory.getLog(this.getClass()).debug((Object)("Could not find DIG query translator for " + pattern));
        }
        ExtendedIterator remote = tr == null ? null : tr.find(pattern, this, premises);
        Node pSubj = this.normaliseNode(pattern.getSubject());
        Node pPred = this.normaliseNode(pattern.getPredicate());
        Node pObj = this.normaliseNode(pattern.getObject());
        ExtendedIterator local = this.m_sourceData.getGraph().find(pSubj, pPred, pObj);
        ExtendedIterator i = remote == null ? local : remote.andThen(local);
        i = this.m_axioms == null ? i : i.andThen(this.m_axioms.getGraph().find(pSubj, pPred, pObj));
        return UniqueExtendedIterator.create(i);
    }

    public DIGQueryTranslator getQueryTranslator(TriplePattern pattern, Model premises) {
        for (int i = 0; i < s_queryTable.length; ++i) {
            DIGQueryTranslator dqt = s_queryTable[i];
            if (!dqt.trigger(pattern, this, premises)) continue;
            return dqt;
        }
        return null;
    }

    public Graph getGraph() {
        return this.m_sourceData.getGraph();
    }

    public String getResourceID(Resource r) {
        return this.getNodeID(r.asNode());
    }

    public String getNodeID(Node n) {
        if (n.isBlank()) {
            return ANON_MARKER + n.getBlankNodeId().toString();
        }
        return n.getURI();
    }

    public void addClassDescription(Element elem, Node node) {
        this.addClassDescription(elem, node, (Model)this.m_sourceData);
    }

    public void addClassDescription(Element elem, Node node, Model sourceData) {
        Model m = sourceData == null ? this.m_sourceData : sourceData;
        this.addClassDescription(elem, (Resource)m.getRDFNode(node), m);
    }

    public void addClassDescription(Element elem, Resource res, Model sourceData) {
        Resource cls;
        Resource resource = cls = res.getModel() != sourceData ? sourceData.getResource(res.getURI()) : res;
        if (!cls.isAnon() || this.m_conceptNames.contains(this.getNodeID(cls.asNode()))) {
            this.translateClassIdentifier(elem, cls);
        } else {
            this.translateClassDescription(elem, (OntClass)cls.as(OntClass.class), sourceData);
        }
    }

    public boolean isIndividual(Node node) {
        return node.isConcrete() && !node.isLiteral() && this.getKnownIndividuals().contains(this.getNodeID(node));
    }

    public boolean isRole(Node node, Model premises) {
        return node.isConcrete() && (this.getKnownRoles().contains(this.getNodeID(node)) || premises != null && this.isPremisesRole(node, premises));
    }

    public boolean isConcept(Node node, Model premises) {
        return node.isConcrete() && !node.isLiteral() && (this.getKnownConcepts().contains(this.getNodeID(node)) || premises != null && this.isPremisesClass(node, premises) || KNOWN_CONCEPTS.contains(this.getNodeID(node)));
    }

    public OntModelSpec getSourceSpecification() {
        return this.m_sourceData.getSpecification();
    }

    public Element createQueryElement(Document query2, String elemName) {
        Element qElem = this.addElement(query2.getDocumentElement(), elemName);
        qElem.setAttribute("id", "q" + s_queryID++);
        return qElem;
    }

    protected void addNamedEntities(Element tell) {
        HashSet roles = new HashSet();
        HashSet attributes = new HashSet();
        HashSet concepts = new HashSet();
        HashSet individuals = new HashSet();
        this.addAll(this.m_sourceData.listClasses(), concepts);
        this.addAll(this.m_sourceData.listDatatypeProperties(), attributes);
        this.addAll(this.m_sourceData.listIndividuals(), individuals);
        this.collectRoleProperties(roles);
        this.addNamedDefs(tell, concepts.iterator(), "defconcept", this.m_conceptNames);
        this.addNamedDefs(tell, roles.iterator(), "defrole", this.m_roleNames);
        this.addNamedDefs(tell, attributes.iterator(), "defattribute", null);
        this.addNamedDefs(tell, individuals.iterator(), "defindividual", this.m_indNames);
    }

    protected void collectRoleProperties(Collection roles) {
        this.addAll(this.m_sourceData.listObjectProperties(), roles);
        this.addAll(this.m_sourceData.listInverseFunctionalProperties(), roles);
        this.addAll(this.m_sourceData.listTransitiveProperties(), roles);
        if (this.m_sourceData.getProfile().SYMMETRIC_PROPERTY() != null) {
            this.addAll(this.m_sourceData.listSymmetricProperties(), roles);
        }
    }

    protected void addNamedDefs(Element tell, Iterator i, String defType, Set nameCollection) {
        while (i.hasNext()) {
            Resource n = (Resource)i.next();
            if (!(n instanceof Resource)) continue;
            String id = this.getNodeID(n.asNode());
            this.addNamedElement(tell, defType, this.getNodeID(n.asNode()));
            if (nameCollection == null) continue;
            nameCollection.add(id);
        }
    }

    protected Element addNamedElement(Element parent, String elemName, String uri) {
        Element elem = this.addElement(parent, elemName);
        elem.setAttribute("name", uri);
        return elem;
    }

    protected Element addElement(Element parent, String childName) {
        Element child = parent.getOwnerDocument().createElement(childName);
        return (Element)parent.appendChild(child);
    }

    private void addAll(Iterator i, Collection c) {
        while (i.hasNext()) {
            c.add(i.next());
        }
    }

    protected void translateClasses(Element tell) {
        this.translateSubClassAxioms(tell);
        this.translateClassEquivalences(tell);
        this.translateClassDisjointAxioms(tell);
        this.translateRestrictions(tell);
        this.translateClassExpressions(tell, this.getOntLanguage().INTERSECTION_OF(), 2);
        this.translateClassExpressions(tell, this.getOntLanguage().UNION_OF(), 1);
        this.translateClassExpressions(tell, this.getOntLanguage().COMPLEMENT_OF(), 3);
        this.translateClassExpressions(tell, this.getOntLanguage().ONE_OF(), 4);
    }

    protected void translateSubClassAxioms(Element tell) {
        StmtIterator i = this.m_sourceData.listStatements(null, this.getOntLanguage().SUB_CLASS_OF(), (RDFNode)null);
        while (i.hasNext()) {
            Statement sc = i.nextStatement();
            Element impliesc = this.addElement(tell, "impliesc");
            this.addClassDescription(impliesc, sc.getSubject(), (Model)this.m_sourceData);
            this.addClassDescription(impliesc, sc.getResource(), (Model)this.m_sourceData);
        }
    }

    protected void translateClassEquivalences(Element tell) {
        StmtIterator i = this.m_sourceData.listStatements(null, this.getOntLanguage().EQUIVALENT_CLASS(), (RDFNode)null);
        while (i.hasNext()) {
            Statement sc = i.nextStatement();
            Element equalc = this.addElement(tell, "equalc");
            this.addClassDescription(equalc, sc.getSubject(), (Model)this.m_sourceData);
            this.addClassDescription(equalc, sc.getResource(), (Model)this.m_sourceData);
        }
    }

    protected void translateClassExpressions(Element tell, Property p, int classExprType) {
        this.translateClassExpressions(tell, this.m_sourceData.listStatements(null, p, (RDFNode)null), classExprType, this.m_sourceData);
    }

    protected void translateRestrictions(Element tell) {
        this.translateClassExpressions(tell, this.m_sourceData.listStatements(null, RDF.type, this.getOntLanguage().RESTRICTION()), 5, this.m_sourceData);
    }

    protected void translateClassExpressions(Element tell, StmtIterator i, int classExprType, Model source) {
        while (i.hasNext()) {
            OntClass cls = (OntClass)i.nextStatement().getSubject().as(class$com$hp$hpl$jena$ontology$OntClass == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass);
            Element equalc = this.addElement(tell, "equalc");
            this.addClassDescription(equalc, cls, source);
            switch (classExprType) {
                case 1: {
                    this.translateUnionClass(equalc, cls, source);
                    break;
                }
                case 2: {
                    this.translateIntersectionClass(equalc, cls, source);
                    break;
                }
                case 3: {
                    this.translateComplementClass(equalc, cls, source);
                    break;
                }
                case 4: {
                    this.translateEnumeratedClass(equalc, cls, source);
                    break;
                }
                case 5: {
                    this.translateRestrictionClass(equalc, cls, source);
                }
            }
        }
    }

    protected void translateClassDescription(Element parent, OntClass classDescr, Model source) {
        if (classDescr.isUnionClass()) {
            this.translateUnionClass(parent, classDescr, source);
        } else if (classDescr.isIntersectionClass()) {
            this.translateIntersectionClass(parent, classDescr, source);
        } else if (classDescr.isComplementClass()) {
            this.translateComplementClass(parent, classDescr, source);
        } else if (classDescr.isEnumeratedClass()) {
            this.translateEnumeratedClass(parent, classDescr, source);
        } else if (classDescr.isRestriction()) {
            this.translateRestrictionClass(parent, classDescr, source);
        }
    }

    protected void translateClassDisjointAxioms(Element tell) {
        StmtIterator i = this.m_sourceData.listStatements(null, this.getOntLanguage().DISJOINT_WITH(), (RDFNode)null);
        while (i.hasNext()) {
            Statement sc = i.nextStatement();
            Element impliesc = this.addElement(tell, "disjoint");
            this.addClassDescription(impliesc, sc.getSubject(), (Model)this.m_sourceData);
            this.addClassDescription(impliesc, sc.getResource(), (Model)this.m_sourceData);
        }
    }

    protected void translateClassIdentifier(Element expr, Resource c) {
        if (((Object)c).equals(this.getOntLanguage().THING())) {
            this.addElement(expr, "top");
            return;
        }
        if (((Object)c).equals(this.getOntLanguage().NOTHING())) {
            this.addElement(expr, "bottom");
            return;
        }
        Element catom = this.addElement(expr, "catom");
        String digConceptName = this.getNodeID(c.asNode());
        catom.setAttribute("name", digConceptName);
    }

    protected void translateRestrictionClass(Element expr, Resource c, Model source) {
        Restriction r = (Restriction)c.as(Restriction.class);
        if (r.isAllValuesFromRestriction()) {
            Element all = this.addElement(expr, "all");
            this.addNamedElement(all, "ratom", r.getOnProperty().getURI());
            this.addClassDescription(all, r.asAllValuesFromRestriction().getAllValuesFrom(), source);
        } else if (r.isSomeValuesFromRestriction()) {
            Element some = this.addElement(expr, "some");
            this.addNamedElement(some, "ratom", r.getOnProperty().getURI());
            this.addClassDescription(some, r.asSomeValuesFromRestriction().getSomeValuesFrom(), source);
        } else if (r.isHasValueRestriction()) {
            this.translateHasValueRestriction(expr, r.asHasValueRestriction());
        } else if (r.isMinCardinalityRestriction()) {
            this.translateCardinalityRestriction(expr, r.asMinCardinalityRestriction().getMinCardinality(), r, "atleast", this.getOntLanguage().THING(), source);
        } else if (r.isMaxCardinalityRestriction()) {
            this.translateCardinalityRestriction(expr, r.asMaxCardinalityRestriction().getMaxCardinality(), r, "atmost", this.getOntLanguage().THING(), source);
        } else if (r.isCardinalityRestriction()) {
            Element and = this.addElement(expr, "and");
            this.translateCardinalityRestriction(and, r.asCardinalityRestriction().getCardinality(), r, "atmost", this.getOntLanguage().THING(), source);
            this.translateCardinalityRestriction(and, r.asCardinalityRestriction().getCardinality(), r, "atleast", this.getOntLanguage().THING(), source);
        }
    }

    protected void translateEnumeratedClass(Element expr, OntClass cls, Model source) {
        Element iset = this.addElement(expr, "iset");
        ExtendedIterator i = cls.asEnumeratedClass().listOneOf();
        while (i.hasNext()) {
            RDFNode n = (RDFNode)i.next();
            if (n instanceof Resource) {
                this.addNamedElement(iset, "individual", ((Resource)n).getURI());
                continue;
            }
            LogFactory.getLog(this.getClass()).warn((Object)("DIG language cannot yet represent enumerations of concrete literals: " + ((Literal)n).getLexicalForm()));
        }
    }

    protected void translateComplementClass(Element expr, OntClass cls, Model source) {
        Element not = this.addElement(expr, "not");
        this.addClassDescription(not, cls.asComplementClass().getOperand(), source);
    }

    protected void translateIntersectionClass(Element expr, OntClass cls, Model source) {
        Element or = this.addElement(expr, "and");
        this.translateClassList(or, cls.asIntersectionClass().getOperands(), source);
    }

    protected void translateUnionClass(Element expr, OntClass cls, Model source) {
        Element or = this.addElement(expr, "or");
        this.translateClassList(or, cls.asUnionClass().getOperands(), source);
    }

    private void translateCardinalityRestriction(Element parent, int card, Restriction r, String exprName, Resource qualType, Model source) {
        Element restrict = this.addElement(parent, exprName);
        restrict.setAttribute("num", Integer.toString(card));
        this.addNamedElement(restrict, "ratom", r.getOnProperty().getURI());
        this.addClassDescription(restrict, qualType, source);
    }

    protected void translateHasValueRestriction(Element expr, HasValueRestriction r) {
        RDFNode value = r.getHasValue();
        OntProperty p = r.getOnProperty();
        if (value instanceof Literal) {
            Literal lit = (Literal)value;
            boolean intDomain = this.isIntegerType(lit.getDatatype());
            Element eq = this.addElement(expr, intDomain ? "intequals" : "stringequals");
            eq.setAttribute("val", lit.getLexicalForm());
            this.addNamedElement(eq, "attribute", p.getURI());
        } else {
            Element some = this.addElement(expr, "some");
            this.addNamedElement(some, "ratom", p.getURI());
            Element iset = this.addElement(some, "iset");
            this.addNamedElement(iset, "individual", ((Resource)value).getURI());
        }
    }

    protected void translateClassList(Element expr, RDFList operands, Model source) {
        ExtendedIterator i = operands.iterator();
        while (i.hasNext()) {
            this.addClassDescription(expr, (Resource)i.next(), source);
        }
    }

    protected void translateIndividuals(Element expr) {
        ExtendedIterator i = this.m_sourceData.listIndividuals();
        while (i.hasNext()) {
            this.translateIndividual(expr, (Resource)i.next());
        }
    }

    protected void translateIndividual(Element expr, Resource r) {
        Individual ind = (Individual)r.as(Individual.class);
        this.translateInstanceTypes(expr, ind);
        StmtIterator i = ind.listProperties();
        while (i.hasNext()) {
            Statement s = i.nextStatement();
            OntProperty p = (OntProperty)s.getPredicate().as(class$com$hp$hpl$jena$ontology$OntProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntProperty") : class$com$hp$hpl$jena$ontology$OntProperty);
            if (p.equals(this.getOntLanguage().DIFFERENT_FROM())) {
                this.translateDifferentIndividuals(expr, ind, (Individual)s.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (p.equals(this.getOntLanguage().SAME_AS())) {
                this.translateSameIndividuals(expr, ind, (Individual)s.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (p.isObjectProperty() || p.isTransitiveProperty() || p.isSymmetricProperty() || p.isInverseFunctionalProperty()) {
                this.translateInstanceRole(expr, ind, p, (Individual)s.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (!p.isDatatypeProperty()) continue;
            this.translateInstanceAttrib(expr, ind, p, s.getLiteral());
        }
    }

    protected void translateInstanceTypes(Element expr, Individual ind) {
        ExtendedIterator i = ind.listRDFTypes(true);
        while (i.hasNext()) {
            Resource type = (Resource)i.next();
            Element inst = this.addElement(expr, "instanceof");
            this.addNamedElement(inst, "individual", this.getResourceID(ind));
            this.addClassDescription(inst, (OntClass)type.as(class$com$hp$hpl$jena$ontology$OntClass == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass), (Model)this.m_sourceData);
        }
    }

    protected void translateInstanceRole(Element expr, Individual ind, OntProperty p, Individual obj) {
        Element related = this.addElement(expr, "related");
        this.addNamedElement(related, "individual", this.getResourceID(ind));
        this.addNamedElement(related, "ratom", p.getURI());
        this.addNamedElement(related, "individual", this.getResourceID(obj));
    }

    protected void translateInstanceAttrib(Element expr, Individual ind, OntProperty p, Literal obj) {
        Element related = this.addElement(expr, "value");
        this.addNamedElement(related, "individual", this.getResourceID(ind));
        this.addNamedElement(related, "attribute", p.getURI());
        this.translateLiteral(obj, related);
    }

    protected void translateLiteral(Literal lit, Element parent) {
        if (this.isIntegerType(lit.getDatatype())) {
            Element ival = this.addElement(parent, "ival");
            ival.appendChild(parent.getOwnerDocument().createTextNode(lit.getLexicalForm()));
        } else {
            Element sval = this.addElement(parent, "sval");
            sval.appendChild(parent.getOwnerDocument().createTextNode(lit.getLexicalForm()));
        }
    }

    protected void translateDifferentIndividuals(Element expr, Individual ind, Individual other) {
        Element disjoint = this.addElement(expr, "disjoint");
        Element iset0 = this.addElement(disjoint, "iset");
        this.addNamedElement(iset0, "individual", this.getResourceID(ind));
        Element iset1 = this.addElement(disjoint, "iset");
        this.addNamedElement(iset1, "individual", this.getResourceID(other));
    }

    protected void translateSameIndividuals(Element expr, Individual ind, Individual other) {
        Element disjoint = this.addElement(expr, "equalc");
        Element iset0 = this.addElement(disjoint, "iset");
        this.addNamedElement(iset0, "individual", this.getResourceID(ind));
        Element iset1 = this.addElement(disjoint, "iset");
        this.addNamedElement(iset1, "individual", this.getResourceID(other));
    }

    protected void translateRoles(Element expr) {
        HashSet roles = new HashSet();
        this.collectRoleProperties(roles);
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            this.translateRole(expr, (ObjectProperty)((Property)i.next()).as(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.ObjectProperty") : class$com$hp$hpl$jena$ontology$ObjectProperty), this.m_sourceData);
        }
    }

    protected void translateRole(Element expr, ObjectProperty role, Model source) {
        this.translateBinaryPropertyAxioms(expr, role.getURI(), "impliesr", role.listSuperProperties(), "ratom");
        this.translateBinaryPropertyAxioms(expr, role.getURI(), "equalr", role.listEquivalentProperties(), "ratom");
        this.translateDomainRangeAxioms(expr, role.getURI(), "domain", role.listDomain(), "ratom", source);
        this.translateDomainRangeAxioms(expr, role.getURI(), "range", role.listRange(), "ratom", source);
        this.translateInverseAxioms(expr, role, "ratom");
        if (role.isTransitiveProperty()) {
            this.translateUnaryPropertyAxiom(expr, role.getURI(), "transitive", "ratom");
        }
        if (role.isFunctionalProperty()) {
            this.translateUnaryPropertyAxiom(expr, role.getURI(), "functional", "ratom");
        }
        if (role.isInverseFunctionalProperty()) {
            this.translateInverseFunctionalAxiom(expr, role, "ratom");
        }
        if (role.isSymmetricProperty()) {
            this.translateInverseAxiom(expr, role, "ratom", role);
        }
    }

    protected void translateAttributes(Element expr) {
        ExtendedIterator i = this.m_sourceData.listDatatypeProperties();
        while (i.hasNext()) {
            this.translateAttribute(expr, (DatatypeProperty)((Property)i.next()).as(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.DatatypeProperty") : class$com$hp$hpl$jena$ontology$DatatypeProperty), this.m_sourceData);
        }
    }

    protected void translateAttribute(Element expr, DatatypeProperty attrib, Model source) {
        this.translateBinaryPropertyAxioms(expr, attrib.getURI(), "impliesr", attrib.listSuperProperties(), "attribute");
        this.translateBinaryPropertyAxioms(expr, attrib.getURI(), "equalr", attrib.listEquivalentProperties(), "attribute");
        this.translateDomainRangeAxioms(expr, attrib.getURI(), "domain", attrib.listDomain(), "attribute", source);
        this.translateAttribRangeAxioms(expr, attrib.getURI(), attrib.listRange(), "attribute");
        if (attrib.isFunctionalProperty()) {
            this.translateUnaryPropertyAxiom(expr, attrib.getURI(), "functional", "attribute");
        }
    }

    protected void translateBinaryPropertyAxioms(Element expr, String propURI, String axiomType, Iterator i, String propType) {
        while (i.hasNext()) {
            Property prop = (Property)i.next();
            Element binaryAxiom = this.addElement(expr, axiomType);
            this.addNamedElement(binaryAxiom, propType, propURI);
            this.addNamedElement(binaryAxiom, propType, prop.getURI());
        }
    }

    protected void translateUnaryPropertyAxiom(Element expr, String propURI, String axiomType, String propType) {
        Element unaryAxiom = this.addElement(expr, axiomType);
        this.addNamedElement(unaryAxiom, propType, propURI);
    }

    protected void translateDomainRangeAxioms(Element expr, String propURI, String axiomType, Iterator i, String propType, Model source) {
        while (i.hasNext()) {
            Element drAxiom = this.addElement(expr, axiomType);
            this.addNamedElement(drAxiom, propType, propURI);
            this.addClassDescription(drAxiom, (Resource)i.next(), source);
        }
    }

    protected void translateAttribRangeAxioms(Element expr, String propURI, Iterator i, String propType) {
        while (i.hasNext()) {
            Resource type = (Resource)i.next();
            RDFDatatype dt = TypeMapper.getInstance().getTypeByName(type.getURI());
            Element drAxiom = this.addElement(expr, this.isIntegerType(dt) ? "rangeint" : "rangestring");
            this.addNamedElement(drAxiom, propType, propURI);
        }
    }

    protected void translateInverseAxioms(Element expr, ObjectProperty p, String propType) {
        ExtendedIterator i = p.listInverse();
        while (i.hasNext()) {
            this.translateInverseAxiom(expr, p, propType, (Property)i.next());
        }
    }

    protected void translateInverseAxiom(Element expr, Property p, String propType, Property inv) {
        Element equalr = this.addElement(expr, "equalr");
        this.addNamedElement(equalr, propType, p.getURI());
        Element inverse = this.addElement(equalr, "inverse");
        this.addNamedElement(inverse, propType, inv.getURI());
    }

    protected void translateInverseFunctionalAxiom(Element expr, ObjectProperty role, String propType) {
        String skolemName = this.getSkolemName(role.getLocalName());
        this.addNamedElement(expr, "defrole", skolemName);
        Element functional = this.addElement(expr, "functional");
        this.addNamedElement(functional, propType, skolemName);
        Element equalr = this.addElement(expr, "equalr");
        this.addNamedElement(equalr, propType, role.getURI());
        Element inverse = this.addElement(equalr, "inverse");
        this.addNamedElement(inverse, propType, skolemName);
    }

    protected void translateAllDifferentAxioms(Element expr) {
        if (this.m_sourceData.getProfile().ALL_DIFFERENT() != null) {
            ExtendedIterator i = this.m_sourceData.listAllDifferent();
            while (i.hasNext()) {
                AllDifferent ad = (AllDifferent)((Resource)i.next()).as(class$com$hp$hpl$jena$ontology$AllDifferent == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.AllDifferent") : class$com$hp$hpl$jena$ontology$AllDifferent);
                this.translateAllDifferent(expr, ad.getDistinctMembers());
            }
        }
    }

    protected void translateAllDifferent(Element expr, RDFList diffMembers) {
        List dm = diffMembers.asJavaList();
        for (int i = 0; i < dm.size(); ++i) {
            Individual ind0 = (Individual)((Resource)dm.get(i)).as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            for (int j = i + 1; j < dm.size(); ++j) {
                Individual ind1 = (Individual)((Resource)dm.get(j)).as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                this.translateDifferentIndividuals(expr, ind0, ind1);
            }
        }
    }

    private boolean isIntegerType(RDFDatatype type) {
        String typeURI = type != null ? type.getURI() : null;
        return typeURI != null && XSD_INT_TYPES.contains(typeURI);
    }

    private String getSkolemName(String root) {
        return "skolem(" + root + "," + this.m_skolemCounter++ + ")";
    }

    protected Set getKnownIndividuals() {
        if (!this.m_indNamesAsked) {
            this.m_indNames.addAll(this.collectNamedTerms("allIndividuals", new String[]{"individualSet", "individual"}));
            this.m_indNamesAsked = true;
        }
        return this.m_indNames;
    }

    protected Set getKnownConcepts() {
        if (!this.m_conceptNamesAsked) {
            this.m_conceptNames.addAll(this.collectNamedTerms("allConceptNames", new String[]{"conceptSet", "synonyms", "catom"}));
            this.m_conceptNamesAsked = true;
        }
        return this.m_conceptNames;
    }

    protected Set getKnownRoles() {
        if (!this.m_roleNamesAsked) {
            this.m_roleNames.addAll(this.collectNamedTerms("allRoleNames", new String[]{"roleSet", "synonyms", "ratom"}));
            this.m_roleNamesAsked = true;
        }
        return this.m_roleNames;
    }

    protected Set collectNamedTerms(String queryType, String[] path) {
        HashSet names = new HashSet();
        Document query2 = this.getConnection().createDigVerb("asks", this.getProfile());
        this.createQueryElement(query2, queryType);
        Document response = this.getConnection().sendDigVerb(query2, this.getProfile());
        SimpleXMLPath p = new SimpleXMLPath(true);
        for (int j = 0; j < path.length; ++j) {
            p.appendElementPath(path[j]);
        }
        p.appendAttrPath("name");
        this.addAll(p.getAll(response), names);
        return names;
    }

    private boolean isPremisesClass(Node node, Model premises) {
        RDFNode rdfNode = premises.getRDFNode(node);
        Profile oProf = this.getOntLanguage();
        if (rdfNode instanceof Resource) {
            Resource r = (Resource)rdfNode;
            Resource any = null;
            return oProf.CLASS() != null && premises.contains(r, RDF.type, oProf.CLASS()) || oProf.RESTRICTION() != null && premises.contains(r, RDF.type, oProf.RESTRICTION()) || oProf.SUB_CLASS_OF() != null && premises.contains(r, oProf.SUB_CLASS_OF(), any) || oProf.SUB_CLASS_OF() != null && premises.contains(any, oProf.SUB_CLASS_OF(), r) || oProf.UNION_OF() != null && premises.contains(r, oProf.SUB_CLASS_OF(), any) || oProf.INTERSECTION_OF() != null && premises.contains(r, oProf.SUB_CLASS_OF(), any) || oProf.COMPLEMENT_OF() != null && premises.contains(r, oProf.SUB_CLASS_OF(), any) || oProf.DISJOINT_WITH() != null && premises.contains(r, oProf.DISJOINT_WITH(), any) || oProf.EQUIVALENT_CLASS() != null && premises.contains(r, oProf.EQUIVALENT_CLASS(), any);
        }
        return false;
    }

    private boolean isPremisesRole(Node node, Model premises) {
        RDFNode rdfNode = premises.getRDFNode(node);
        Profile oProf = this.getOntLanguage();
        if (rdfNode instanceof Resource) {
            Resource r = (Resource)rdfNode;
            Resource any = null;
            return oProf.PROPERTY() != null && premises.contains(r, RDF.type, oProf.PROPERTY()) || oProf.OBJECT_PROPERTY() != null && premises.contains(r, RDF.type, oProf.OBJECT_PROPERTY()) || oProf.DATATYPE_PROPERTY() != null && premises.contains(r, RDF.type, oProf.DATATYPE_PROPERTY()) || oProf.TRANSITIVE_PROPERTY() != null && premises.contains(r, RDF.type, oProf.TRANSITIVE_PROPERTY()) || oProf.FUNCTIONAL_PROPERTY() != null && premises.contains(r, RDF.type, oProf.FUNCTIONAL_PROPERTY()) || oProf.INVERSE_FUNCTIONAL_PROPERTY() != null && premises.contains(r, RDF.type, oProf.INVERSE_FUNCTIONAL_PROPERTY()) || oProf.SYMMETRIC_PROPERTY() != null && premises.contains(r, RDF.type, oProf.SYMMETRIC_PROPERTY()) || oProf.SUB_PROPERTY_OF() != null && premises.contains(r, oProf.SUB_PROPERTY_OF(), any) || oProf.SUB_PROPERTY_OF() != null && premises.contains(any, oProf.SUB_PROPERTY_OF(), r) || oProf.INVERSE_OF() != null && premises.contains(r, oProf.INVERSE_OF(), any) || oProf.INVERSE_OF() != null && premises.contains(any, oProf.INVERSE_OF(), r);
        }
        return false;
    }

    private Node normaliseNode(Node n) {
        return n.isConcrete() ? n : Node.ANY;
    }

    private class DigIdentifierImpl
    implements DIGIdentifier {
        private Document m_id;

        private DigIdentifierImpl(Document id) {
            this.m_id = id;
        }

        public String getName() {
            return this.m_id.getDocumentElement().getAttribute("name");
        }

        public String getVersion() {
            return this.m_id.getDocumentElement().getAttribute("version");
        }

        public String getMessage() {
            return this.m_id.getDocumentElement().getAttribute("message");
        }

        public Iterator supportsLanguage() {
            return this.supports("language");
        }

        public Iterator supportsTell() {
            return this.supports("tell");
        }

        public Iterator supportsAsk() {
            return this.supports("ask");
        }

        private Iterator supports(String support) {
            Element supports = this.getChild(this.m_id.getDocumentElement(), "supports");
            return this.childElementNames(this.getChild(supports, support));
        }

        private Iterator childElementNames(Element node) {
            ArrayList<String> l = new ArrayList<String>();
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                org.w3c.dom.Node n = nl.item(i);
                if (!(n instanceof Element)) continue;
                l.add(n.getNodeName());
            }
            return l.iterator();
        }

        private Element getChild(Element node, String name) {
            return (Element)node.getElementsByTagName(name).item(0);
        }
    }
}

