/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.MixedGraphMem;
import com.hp.hpl.jena.mem.MixedGraphMemStore;
import com.hp.hpl.jena.mem.test.TestGraphMem;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestMixedGraphMem
extends TestGraphMem {
    public TestMixedGraphMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestMixedGraphMem.class);
    }

    public Graph getGraph() {
        return new MixedGraphMem();
    }

    public void testRepeatedAddSuppressesPredicateAndObject() {
        final ArrayList history = new ArrayList();
        MixedGraphMemStore t = new MixedGraphMemStore(this.getGraph()){

            protected boolean add(Node key, Triple t) {
                history.add(key);
                return super.add(key, t);
            }
        };
        t.add(TestMixedGraphMem.triple("s P o"));
        TestMixedGraphMem.assertEquals((Object)TestMixedGraphMem.nodeList("s P o"), history);
        t.add(TestMixedGraphMem.triple("s P o"));
        TestMixedGraphMem.assertEquals((Object)TestMixedGraphMem.nodeList("s P o s"), history);
    }

    public void testUnnecessaryMatches() {
    }

    public void testRemoveAbsentSuppressesPredicateAndObject() {
        final ArrayList history = new ArrayList();
        MixedGraphMemStore t = new MixedGraphMemStore(this.getGraph()){

            protected boolean remove(Node key, Triple t) {
                history.add(key);
                return super.remove(key, t);
            }
        };
        t.remove(TestMixedGraphMem.triple("s P o"));
        TestMixedGraphMem.assertEquals((Object)TestMixedGraphMem.nodeList("s"), history);
    }
}

