/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.NTriple;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class Performance {
    static String[][] allFiles = new String[][]{{"testing/arp/onts/ont1", "http://cicho0.tripod.com/cs_Courses_ont"}, {"testing/arp/onts/ont2", "http://cicho0.tripod.com/cs_LecturingStaff_ont"}, {"testing/arp/onts/ont3", "http://cicho0.tripod.com/cs_Staff_ont"}, {"testing/arp/onts/ont4", "http://cicho0.tripod.com/Dep_of_Computer_Science"}, {"testing/arp/onts/ont10", "http://daml.umbc.edu/ontologies/calendar-ont.daml"}, {"testing/arp/onts/ont11", "http://daml.umbc.edu/ontologies/classification.daml"}, {"testing/arp/onts/ont12", "http://daml.umbc.edu/ontologies/dreggie-ont.daml"}, {"testing/arp/onts/ont13", "http://daml.umbc.edu/ontologies/profile-ont.daml"}, {"testing/arp/onts/ont14", "http://daml.umbc.edu/ontologies/talk-ont.daml"}, {"testing/arp/onts/ont15", "http://daml.umbc.edu/ontologies/topic-ont.daml"}, {"testing/arp/onts/ont16", "http://daml.umbc.edu/ontologies/trust-ont.daml"}, {"testing/arp/onts/ont17", "http://derpi.tuwien.ac.at/~andrei/cerif-rdf-dc-mn.daml"}, {"testing/arp/onts/ont18", "http://edge.mcs.drexel.edu/MUG/2001/05/16/sbf.daml"}, {"testing/arp/onts/ont19", "http://grcinet.grci.com/maria/www/codipsite/Onto/DublinCore/DublinCore_V27Aug2001.daml"}, {"testing/arp/onts/ont20", "http://grcinet.grci.com/maria/www/codipsite/Onto/Project/ProjectOntology_V26Jul2001.daml"}, {"testing/arp/onts/ont21", "http://grcinet.grci.com/maria/www/codipsite/Onto/TMD/TMDOntology_V27Aug2001.daml"}, {"testing/arp/onts/ont22", "http://grcinet.grci.com/maria/www/codipsite/Onto/WebDirectory/WebDirectory_V27Aug2001.daml"}, {"testing/arp/onts/ont23", "http://grcinet.grci.com/maria/www/CodipSite/Onto/WebSite/WebSiteOntology_V27Aug2001.daml"}, {"testing/arp/onts/ont26", "http://isx.com/~phaglic/horus/daml/onts/englishpubont.daml"}, {"testing/arp/onts/ont27", "http://ksl.stanford.edu/projects/DAML/chimaera-jtp-cardinality-test1.daml"}, {"testing/arp/onts/ont28", "http://mnemosyne.umd.edu/~aelkiss/daml/serial1.2.daml"}, {"testing/arp/onts/ont29", "http://mnemosyne.umd.edu/~aelkiss/weather-ont.daml"}, {"testing/arp/onts/ont30", "http://mr.teknowledge.com/DAML/ArtOntology.daml"}, {"testing/arp/onts/ont31", "http://mr.teknowledge.com/daml/Homeworks/HomeWork1/ResearchProjectOntology.daml"}, {"testing/arp/onts/ont32", "http://mr.teknowledge.com/daml/homeworks/HomeWork3/BriefingOntology.daml"}, {"testing/arp/onts/ont34", "http://mr.teknowledge.com/DAML/Imaging.daml"}, {"testing/arp/onts/ont35", "http://mr.teknowledge.com/daml/ontologies/ImageFingerprinting/2001/04/BriefingsOntology.daml"}, {"testing/arp/onts/ont36", "http://mr.teknowledge.com/daml/ontologies/ImageFingerprinting/2001/04/ImageFingerprintingOntology-web.daml"}, {"testing/arp/onts/ont37", "http://mr.teknowledge.com/daml/ontologies/ImageFingerprinting/2001/04/ImageFingerprintsOntology-briefings.daml"}, {"testing/arp/onts/ont38", "http://mr.teknowledge.com/DAML/pptOntology.daml"}, {"testing/arp/onts/ont39", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_I1.daml"}, {"testing/arp/onts/ont40", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_I2.daml"}, {"testing/arp/onts/ont41", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_I3.daml"}, {"testing/arp/onts/ont42", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_I4.daml"}, {"testing/arp/onts/ont43", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_II1.daml"}, {"testing/arp/onts/ont44", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_II2.daml"}, {"testing/arp/onts/ont45", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_II3.daml"}, {"testing/arp/onts/ont46", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_II4.daml"}, {"testing/arp/onts/ont47", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_III1.daml"}, {"testing/arp/onts/ont48", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_III2.daml"}, {"testing/arp/onts/ont49", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_III3.daml"}, {"testing/arp/onts/ont50", "http://ontobroker.semanticweb.org/ontos/compontos/tourism_III4.daml"}, {"testing/arp/onts/ont53", "http://opencyc.sourceforge.net/daml/cyc-transportation.daml"}, {"testing/arp/onts/ont54", "http://opencyc.sourceforge.net/daml/cyc.daml"}, {"testing/arp/onts/ont55", "http://opencyc.sourceforge.net/daml/naics"}, {"testing/arp/onts/ont56", "http://orlando.drc.com/daml/ontology/Bibliographic/current/"}, {"testing/arp/onts/ont57", "http://orlando.drc.com/daml/Ontology/Commercial/Shipping/current/"}, {"testing/arp/onts/ont58", "http://orlando.drc.com/daml/Ontology/Condition/UJTL/v4.0/current/"}, {"testing/arp/onts/ont59", "http://orlando.drc.com/daml/Ontology/DAML-extension/current/"}, {"testing/arp/onts/ont60", "http://orlando.drc.com/daml/ontology/DC/current/"}, {"testing/arp/onts/ont61", "http://orlando.drc.com/daml/ontology/Fugitive/current/"}, {"testing/arp/onts/ont62", "http://orlando.drc.com/daml/Ontology/Genealogy/current/"}, {"testing/arp/onts/ont63", "http://orlando.drc.com/daml/ontology/Glossary/current/"}, {"testing/arp/onts/ont64", "http://orlando.drc.com/daml/Ontology/GPS/Coordinates/current/"}, {"testing/arp/onts/ont65", "http://orlando.drc.com/daml/Ontology/Intelligence/Report/current/"}, {"testing/arp/onts/ont66", "http://orlando.drc.com/daml/ontology/Locator/current/"}, {"testing/arp/onts/ont67", "http://orlando.drc.com/daml/ontology/Organization/current/"}, {"testing/arp/onts/ont68", "http://orlando.drc.com/daml/ontology/Person/current/"}, {"testing/arp/onts/ont69", "http://orlando.drc.com/daml/Ontology/POC/current/"}, {"testing/arp/onts/ont70", "http://orlando.drc.com/daml/ontology/TaskList/current/"}};
    static String[][] files;
    static int totalLength;
    static int totalTime;

    Performance() {
    }

    public static void main(String[] args) {
        files = new String[20][];
        int ii = 0;
        while (ii + files.length <= allFiles.length) {
            for (int k = 0; k < files.length; ++k) {
                Performance.files[k] = allFiles[ii + k];
            }
            totalLength = 0;
            double s1 = Performance.speed();
            double s2 = Performance.speed();
            System.err.println(files[0][0] + "\t" + totalLength + "\t" + s1 + "\t" + s2 + "\t" + files[0][1]);
            ii += files.length;
        }
        System.err.println("Total time: " + totalTime + " ms");
    }

    static byte[][] load() {
        byte[][] rslt = new byte[files.length][];
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i][0]);
            totalLength += (int)f.length();
            if (f.length() == 0L) continue;
            rslt[i] = new byte[(int)f.length()];
            try {
                FileInputStream in = new FileInputStream(f);
                ((InputStream)in).read(rslt[i]);
                ((InputStream)in).close();
                continue;
            }
            catch (IOException e) {
                System.err.println(files[i][1] + " " + e.getMessage());
            }
        }
        return rslt;
    }

    static int sum(byte[] array) {
        int r = 0;
        if (array == null) {
            return 0;
        }
        for (int i = 0; i < array.length; ++i) {
            r += array[i];
        }
        return r;
    }

    static double speed() {
        boolean realData = false;
        byte[][] data = Performance.load();
        int s = 0;
        long startRead = System.currentTimeMillis();
        for (int i = 0; i < files.length; ++i) {
            for (int k = 0; k < 50; ++k) {
                s += Performance.sum(data[i]);
            }
        }
        long startTest = System.currentTimeMillis();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (data[i] == null) continue;
                realData = true;
                Performance.parseRDF(new ByteArrayInputStream(data[i]), files[i][1]);
                continue;
            }
            catch (IOException e) {
                System.err.println("byteArray " + e.getMessage());
            }
        }
        long endTime = System.currentTimeMillis();
        totalTime += (int)(endTime - startTest);
        if (!realData) {
            return Double.NaN;
        }
        return (double)(endTime - startTest) / (double)(startTest - startRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parseRDF(InputStream in, String base) throws IOException {
        ErrorHandler eh = new ErrorHandler(){

            public void warning(SAXParseException e) {
            }

            public void error(SAXParseException e) {
            }

            public void fatalError(SAXParseException e) {
            }
        };
        InputStream oldIn = System.in;
        InputStream ntIn = null;
        try {
            System.setIn(in);
            NTriple.mainEh((String[])new String[]{"-b", base, "-t"}, (ErrorHandler)eh, null);
        }
        catch (Exception e) {
            System.err.println(base + " " + e.toString());
        }
        finally {
            System.setIn(oldIn);
            if (ntIn != null) {
                ntIn.close();
            }
        }
    }
}

