/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class CompressedInputStream
extends InputStream {
    private Inflater inflater;
    private InputStream in;
    private byte[] uncompressedPacket;
    private int pos = 0;

    public CompressedInputStream(InputStream streamFromServer) {
        this.in = streamFromServer;
        this.inflater = new Inflater();
    }

    public int available() throws IOException {
        if (this.uncompressedPacket == null) {
            return this.in.available();
        }
        return this.uncompressedPacket.length - this.pos + this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.uncompressedPacket = null;
        this.inflater = null;
    }

    public int read() throws IOException {
        try {
            this.getNextPacketIfRequired(1);
        }
        catch (IOException ioEx) {
            return -1;
        }
        return this.uncompressedPacket[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        try {
            this.getNextPacketIfRequired(len);
        }
        catch (IOException ioEx) {
            return -1;
        }
        System.arraycopy(this.uncompressedPacket, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long count = 0L;
        long i = 0L;
        while (i < n) {
            int bytesRead = this.read();
            if (bytesRead == -1) break;
            ++count;
            ++i;
        }
        return count;
    }

    private void getNextPacketFromServer() throws IOException {
        byte[] uncompressedBuffer = null;
        int packetLength = this.in.read() + (this.in.read() << 8) + (this.in.read() << 16);
        if (packetLength == -65793) {
            throw new IOException("Unexpected end of input stream");
        }
        this.in.read();
        int compressedLength = this.in.read() + (this.in.read() << 8) + (this.in.read() << 16);
        if (compressedLength > 0) {
            uncompressedBuffer = new byte[compressedLength];
            byte[] compressedBuffer = new byte[packetLength];
            this.readFully(compressedBuffer, 0, packetLength);
            try {
                this.inflater.reset();
            }
            catch (NullPointerException npe) {
                this.inflater = new Inflater();
            }
            this.inflater.setInput(compressedBuffer);
            try {
                this.inflater.inflate(uncompressedBuffer);
            }
            catch (DataFormatException dfe) {
                throw new IOException("Error while uncompressing packet from server.");
            }
            this.inflater.end();
        } else {
            uncompressedBuffer = new byte[packetLength + 1];
            this.readFully(uncompressedBuffer, 0, packetLength);
        }
        if (this.uncompressedPacket != null && this.pos < this.uncompressedPacket.length) {
            int remainingLength = this.uncompressedPacket.length - this.pos;
            byte[] combinedBuffer = new byte[remainingLength + uncompressedBuffer.length];
            System.arraycopy(this.uncompressedPacket, this.pos, combinedBuffer, 0, remainingLength);
            System.arraycopy(uncompressedBuffer, 0, combinedBuffer, remainingLength, uncompressedBuffer.length);
            uncompressedBuffer = combinedBuffer;
        }
        this.uncompressedPacket = uncompressedBuffer;
        this.pos = 0;
    }

    private void getNextPacketIfRequired(int numBytes) throws IOException {
        if (this.uncompressedPacket == null || this.pos + numBytes > this.uncompressedPacket.length) {
            this.getNextPacketFromServer();
        }
    }

    private final int readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        return n;
    }
}

