/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class FileUtil {
    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        lookupPath = lookupPath.substring(0, index);
        while (path.startsWith("../")) {
            if (lookupPath.length() <= 0) {
                return null;
            }
            index = lookupPath.lastIndexOf("/");
            lookupPath = lookupPath.substring(0, index);
            index = path.indexOf("../") + 3;
            path = path.substring(index);
        }
        return String.valueOf(lookupPath) + "/" + path;
    }

    private static TestedFile checkFile(String base, String info) {
        return new TestedFile(base, info);
    }

    static String concatPath(String s1, String s2) {
        if (s1.endsWith(File.separator)) {
            if (s2.startsWith(File.separator)) {
                return String.valueOf(s1) + s2.substring(1);
            }
            return String.valueOf(s1) + s2;
        }
        if (s2.startsWith(File.separator)) {
            return String.valueOf(s1) + s2;
        }
        return String.valueOf(s1) + File.separatorChar + s2;
    }

    public static String getCanonicalPath(String name) {
        if (name == null) {
            return null;
        }
        File f = new File(name);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return name;
        }
    }

    public static String getDocBaseLocalizedFile(String base, String path, Locale loc, Locale fbloc) {
        return FileUtil.getDocBaseLocalizedResource(base, path, loc, fbloc);
    }

    private static String getDocBaseLocalizedPath(String dBase, String path, Locale loc) {
        String rLang = loc.getLanguage();
        String rCoun = loc.getCountry();
        String rVar = loc.getVariant();
        String ldBase = dBase.endsWith(File.separator) ? dBase : String.valueOf(dBase) + File.separatorChar;
        TestedFile tf = null;
        String base = null;
        if (rVar != null && !"".equals(rVar) && (tf = FileUtil.checkFile(base = String.valueOf(ldBase) + rLang + '_' + rCoun + '_' + rVar, path)).getFile().exists()) {
            return tf.getPath();
        }
        if (rCoun != null && !"".equals(rCoun) && (tf = FileUtil.checkFile(base = String.valueOf(ldBase) + rLang + '_' + rCoun, path)).getFile().exists()) {
            return tf.getPath();
        }
        base = String.valueOf(ldBase) + rLang;
        tf = FileUtil.checkFile(base, path);
        if (tf.getFile().exists()) {
            return tf.getPath();
        }
        return FileUtil.checkFile(dBase, path).getPath();
    }

    public static String getDocBaseLocalizedResource(String base, String path, Locale loc, Locale fbloc) {
        String locRes = null;
        locRes = FileUtil.safePath(base, path);
        if (locRes == null) {
            return null;
        }
        if (loc != null) {
            locRes = FileUtil.getDocBaseLocalizedPath(base, path, loc);
        }
        if (locRes != null) {
            return locRes;
        }
        if (fbloc != null) {
            locRes = FileUtil.getDocBaseLocalizedPath(base, path, fbloc);
        }
        return locRes;
    }

    public static String getLocalizedFile(String base, String path, Locale loc) {
        return FileUtil.getLocalizedResource(base, path, loc, true);
    }

    public static String getLocalizedFile(String base, String path, Locale loc, Locale fbloc) {
        String locRes = null;
        if (loc != null) {
            locRes = FileUtil.getLocalizedFile(base, path, loc);
        }
        if (locRes != null) {
            return locRes;
        }
        if (fbloc != null) {
            locRes = FileUtil.getLocalizedFile(base, path, fbloc);
        }
        if (locRes != null) {
            return locRes;
        }
        return FileUtil.safePath(base, path);
    }

    public static String getLocalizedResource(String base, String rPath, Locale loc, boolean safechek) {
        if (rPath == null) {
            return null;
        }
        String path = safechek ? FileUtil.safePath(base, rPath) : rPath;
        return FileUtil.getLocalizedResource(path, loc);
    }

    public static String getLocalizedResource(String path, Locale loc) {
        if (path == null) {
            return null;
        }
        String wPath = null;
        String pPath = null;
        String gpPath = null;
        String rLang = loc.getLanguage();
        String rCoun = loc.getCountry();
        String rVar = loc.getVariant();
        int pathLen = path.length();
        int lastParen = path.lastIndexOf(File.separator);
        int lastDot = path.lastIndexOf(46);
        String pathBase = null;
        String dotTail = null;
        if (lastParen < lastDot && lastDot > 0) {
            pathBase = path.substring(0, lastDot);
            dotTail = path.substring(lastDot);
        } else {
            pathBase = path;
        }
        Object file = null;
        gpPath = String.valueOf(pathBase) + '_' + rLang;
        if (rCoun != null && !"".equals(rCoun)) {
            pPath = String.valueOf(gpPath) + '_' + rCoun;
            if (rVar != null && !"".equals(rVar)) {
                wPath = String.valueOf(pPath) + '_' + rVar;
                if (dotTail != null) {
                    wPath = String.valueOf(wPath) + dotTail;
                }
                if (new File(wPath).exists()) {
                    return wPath;
                }
            }
            if (dotTail != null) {
                pPath = String.valueOf(pPath) + dotTail;
            }
            if (new File(pPath).exists()) {
                return pPath;
            }
        }
        if (dotTail != null) {
            gpPath = String.valueOf(gpPath) + dotTail;
        }
        if (new File(gpPath).exists()) {
            return gpPath;
        }
        return null;
    }

    public static String getLocalizedResource(String path, Locale loc, Locale fbLoc) {
        String locRes = null;
        if (loc != null) {
            locRes = FileUtil.getLocalizedResource(path, loc);
        }
        if (locRes != null) {
            return locRes;
        }
        if (fbLoc != null) {
            locRes = FileUtil.getLocalizedResource(path, fbLoc);
        }
        if (locRes != null) {
            return locRes;
        }
        return path;
    }

    public static boolean isAbsolute(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        if (path.startsWith(File.separator)) {
            return true;
        }
        if (path.length() >= 3 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            return true;
        }
        return System.getProperty("os.name").startsWith("NetWare") && path.length() >= 3 && path.indexOf(58) > 0;
    }

    public static File[] listFiles(File dir) {
        String[] ss = dir.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        File[] fs = new File[n];
        int i = 0;
        while (i < n) {
            fs[i] = new File(dir.getPath(), ss[i]);
            ++i;
        }
        return fs;
    }

    public static String patch(String path) {
        char[] ca;
        String patchPath = path;
        if (patchPath.length() >= 3 && patchPath.charAt(0) == '/' && Character.isLetter(patchPath.charAt(1)) && patchPath.charAt(2) == ':') {
            patchPath = String.valueOf(patchPath.substring(1, 3)) + "/" + patchPath.substring(3);
        }
        if (patchPath.length() >= 2 && Character.isLetter(patchPath.charAt(0)) && patchPath.charAt(1) == ':') {
            ca = patchPath.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    char c = i == 0 && Character.isLetter(ca[i]) && i < ca.length - 1 && ca[i + 1] == ':' ? Character.toUpperCase(ca[i]) : ca[i];
                    sb.append(c);
                }
                ++i;
            }
            patchPath = sb.toString();
        }
        if (System.getProperty("os.name").startsWith("NetWare") && path.length() >= 3 && path.indexOf(58) > 0) {
            ca = patchPath.replace('/', '\\').toCharArray();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && i > 0 && ca[i - 1] != '\\') {
                    sb.append(ca[i]);
                }
                ++i;
            }
            patchPath = sb.toString();
        }
        return patchPath;
    }

    public static String safePath(String base, String path) {
        int ls;
        int index;
        String normP = path;
        if (path.indexOf(92) >= 0) {
            normP = path.replace('\\', '/');
        }
        if (!normP.startsWith("/")) {
            normP = "/" + normP;
        }
        if ((index = normP.indexOf("/../")) >= 0) {
            int index2 = 0;
            while ((index2 = normP.indexOf("//", index2)) >= 0) {
                normP = String.valueOf(normP.substring(0, index2)) + normP.substring(index2 + 1);
                if (index2 >= index) continue;
                --index;
            }
            index2 = 0;
            while ((index2 = normP.indexOf("/./", index2)) >= 0) {
                normP = String.valueOf(normP.substring(0, index2)) + normP.substring(index2 + 2);
                if (index2 >= index) continue;
                index -= 2;
            }
            while (index >= 0) {
                if (index == 0) {
                    return null;
                }
                index2 = normP.lastIndexOf(47, index - 1);
                normP = String.valueOf(normP.substring(0, index2)) + normP.substring(index + 3);
                index = normP.indexOf("/../", index2);
            }
        }
        String realPath = String.valueOf(base) + normP;
        realPath = FileUtil.patch(realPath);
        String canPath = null;
        try {
            canPath = new File(realPath).getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        if (File.separatorChar == '\\' && !realPath.equals(canPath) && (ls = realPath.lastIndexOf(92)) > 0 && !realPath.substring(0, ls).equals(canPath)) {
            return null;
        }
        if (realPath.indexOf("..") != -1) {
            return null;
        }
        return realPath;
    }

    public static class TestedFile {
        File file = null;
        String path = null;

        public TestedFile(String base, String path) {
            this.path = path == null || path.length() < 1 ? base : FileUtil.concatPath(base, path);
            this.file = new File(this.path);
        }

        public File getFile() {
            return this.file;
        }

        public String getPath() {
            return this.path;
        }
    }
}

