/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ExpressibleComparator;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class UniqueStream
extends TupleStream
implements ExpressibleStream {
    private static final long serialVersionUID = 1L;
    private TupleStream tupleStream;
    private Comparator<Tuple> comp;
    private transient Tuple currentTuple;

    public UniqueStream(TupleStream tupleStream, Comparator<Tuple> comp) {
        this.tupleStream = tupleStream;
        this.comp = comp;
    }

    public UniqueStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, ExpressibleStream.class, TupleStream.class);
        StreamExpressionNamedParameter overExpression = factory.getNamedOperand(expression, "over");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        this.tupleStream = factory.constructStream(streamExpressions.get(0));
        if (null == overExpression || !(overExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'over' parameter listing fields to unique over but didn't find one", expression));
        }
        this.comp = factory.constructComparator(((StreamExpressionValue)overExpression.getParameter()).getValue(), FieldComparator.class);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (!(this.tupleStream instanceof ExpressibleStream)) {
            throw new IOException("This UniqueStream contains a non-expressible TupleStream - it cannot be converted to an expression");
        }
        expression.addParameter(((ExpressibleStream)((Object)this.tupleStream)).toExpression(factory));
        if (!(this.comp instanceof ExpressibleComparator)) {
            throw new IOException("This UniqueStream contains a non-expressible comparator - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("over", ((ExpressibleComparator)((Object)this.comp)).toExpression(factory)));
        return expression;
    }

    public void setComp(Comparator<Tuple> comp) {
        this.comp = comp;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.tupleStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        int i;
        Tuple tuple = this.tupleStream.read();
        if (tuple.EOF) {
            return tuple;
        }
        if (this.currentTuple == null) {
            this.currentTuple = tuple;
            return tuple;
        }
        while ((i = this.comp.compare(this.currentTuple, tuple)) == 0) {
            tuple = this.tupleStream.read();
            if (!tuple.EOF) continue;
            return tuple;
        }
        this.currentTuple = tuple;
        return tuple;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

