/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.auth;

import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;

public class ClientIdentityManager {
    protected static Log log = LogFactory.getLog(ClientIdentityManager.class);

    public static Subject getCurrentIdentity() {
        CertificateManager cm = CertificateManager.getInstance();
        X509Certificate x509cert = cm.loadCertificate();
        String subjectDN = cm.getSubjectDN(x509cert);
        Subject subject = new Subject();
        if (subjectDN != null) {
            subject.setValue(subjectDN);
        } else {
            subject.setValue("public");
        }
        return subject;
    }

    public static Session getCurrentSession() throws IOException, InstantiationException, IllegalAccessException, MarshallingException {
        CertificateManager cm = CertificateManager.getInstance();
        X509Certificate x509cert = cm.loadCertificate();
        String subjectDN = cm.getSubjectDN(x509cert);
        Session session = new Session();
        Subject subject = new Subject();
        if (subjectDN != null) {
            subject.setValue(subjectDN);
            session.setSubject(subject);
            session.setSubjectInfo(cm.getSubjectInfo(x509cert));
        } else {
            subject.setValue("public");
            session.setSubject(subject);
        }
        return session;
    }

    public static Subject setCurrentIdentity(String certificatePath) {
        URL url = ClientIdentityManager.class.getClassLoader().getResource(certificatePath);
        CertificateManager.getInstance().setCertificateLocation(url.getPath());
        Subject subject = ClientIdentityManager.getCurrentIdentity();
        log.info((Object)("client setup as Subject: " + subject.getValue()));
        return subject;
    }

    public static Date getCertificateExpiration() {
        X509Certificate x509cert = CertificateManager.getInstance().loadCertificate();
        Date expires = null;
        if (x509cert != null) {
            expires = x509cert.getNotAfter();
        }
        return expires;
    }
}

