/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.UnregisteredObjectException;
import java.util.HashMap;

public class MemoryStore<V extends Identifiable>
extends HashMap<Identifier, V>
implements Store<V> {
    Initializable initializable;
    protected IdentifiableProvider<V> identifiableProvider;

    public MemoryStore(IdentifiableProvider<V> identifiableProvider) {
        this.identifiableProvider = identifiableProvider;
        this.initializable = new MSInitializer(this);
    }

    public Initializable getInitializer() {
        return this.initializable;
    }

    public V create() {
        return (V)((Identifiable)this.identifiableProvider.get());
    }

    public void update(V value) {
        if (!this.containsKey(value.getIdentifier())) {
            throw new UnregisteredObjectException("Error: the given item has not been added to the store yet:" + value);
        }
        this.realSave(value);
    }

    protected void realSave(V value) {
        if (value.getIdentifier() == null) {
            throw new UnsupportedOperationException("Error: null identifiers are not allowed");
        }
        this.put(value.getIdentifier(), value);
    }

    public void register(V value) {
        this.realSave(value);
    }

    public void save(V value) {
        this.realSave(value);
    }

    public static class MSInitializer
    implements Initializable {
        MemoryStore memoryStore;

        public MSInitializer(MemoryStore memoryStore) {
            this.memoryStore = memoryStore;
        }

        public boolean createNew() {
            return this.destroy();
        }

        public boolean destroy() {
            this.memoryStore.clear();
            return true;
        }

        public boolean init() {
            return this.destroy();
        }

        public boolean isCreated() {
            return true;
        }

        public boolean isInitialized() {
            return true;
        }

        public boolean isDestroyed() {
            return false;
        }
    }
}

