/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction.library;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterExtendByVar;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterYieldN;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.library.ListBase1;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import java.util.List;

public class listMember
extends ListBase1 {
    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (argObject.isList() && argObject.getArgList().size() != 0) {
            throw new QueryBuildException("List arguments (object) to " + predicate.getURI());
        }
    }

    @Override
    protected QueryIterator execOneList(Binding binding, Node listNode, Node predicate, Node member, ExecutionContext execCxt) {
        if (Var.isVar(listNode)) {
            throw new QueryExecException("List : subject not a list or variable bound to a list");
        }
        if (Var.isVar(member)) {
            return this.members(binding, listNode, Var.alloc(member), execCxt);
        }
        return this.verify(binding, listNode, member, execCxt);
    }

    @Override
    protected QueryIterator execObjectBound(Binding binding, Var listVar, Node predicate, Node object, ExecutionContext execCxt) {
        GNode gnode = new GNode(execCxt.getActiveGraph(), object);
        List<Node> lists = GraphList.listFromMember(gnode);
        return new QueryIterExtendByVar(binding, listVar, lists.iterator(), execCxt);
    }

    private QueryIterator members(Binding binding, Node listNode, Var itemVar, ExecutionContext execCxt) {
        List<Node> members = GraphList.members(new GNode(execCxt.getActiveGraph(), listNode));
        return new QueryIterExtendByVar(binding, itemVar, members.iterator(), execCxt);
    }

    private QueryIterator verify(Binding binding, Node listNode, Node member, ExecutionContext execCxt) {
        int count = GraphList.occurs(new GNode(execCxt.getActiveGraph(), listNode), member);
        return new QueryIterYieldN(count, binding);
    }
}

