/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink;

import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class OSTIElinkService {
    public static final String DOI = "doi";
    public static final String SAVED = "Saved";
    public static final String PENDING = "Pending";
    private static final int GET = 1;
    private static final int PUT = 2;
    private static final int POST = 3;
    private static final int DELETE = 4;
    private static final int CONNECTIONS_PER_ROUTE = 8;
    private static final String minimalMetadataFile = "minimal-osti.xml";
    private static final String STATUS = "status";
    private static final String SUCCESS = "SUCCESS";
    private String username = null;
    private String password = null;
    private String baseURL = "https://www.osti.gov/elink/2416api";
    private CloseableHttpClient httpClient = null;
    private byte[] encodedAuthStr = null;
    private Document minimalMetadataDoc = null;
    private String originalDefaultSiteCode = null;
    private String currentDefaultSiteCode = "test";
    protected static Log log = LogFactory.getLog(OSTIElinkService.class);

    public OSTIElinkService(String username, String password, String baseURL) {
        this.username = username;
        this.password = password;
        if (baseURL != null && !baseURL.trim().equals("")) {
            this.baseURL = baseURL;
        }
        this.httpClient = OSTIElinkService.createThreadSafeClient();
        String authentication = username + ":" + password;
        this.encodedAuthStr = Base64.encodeBase64((byte[])authentication.getBytes(Charset.forName("ISO-8859-1")));
    }

    public String mintIdentifier(String siteCode) throws OSTIElinkException {
        String identifier = null;
        String minimalMetadata = this.buildMinimalMetadata(siteCode);
        byte[] reponse = this.sendRequest(3, this.baseURL, minimalMetadata);
        log.debug((Object)("OSTIElinkService.mintIdentifier - the response from the OSTI service is:\n " + new String(reponse)));
        Document doc = OSTIElinkService.generateDOM(reponse);
        String status = this.getElementValue(doc, STATUS);
        String id = this.getElementValue(doc, DOI);
        if (status == null || !status.equalsIgnoreCase(SUCCESS) || id == null || id.trim().equals("")) {
            throw new OSTIElinkException("OSTIElinkService.mintIdentifier - Error:  " + new String(reponse));
        }
        identifier = "doi:" + id;
        log.debug((Object)("OSTIElinkService.mintIdentifier - the generated identifier is " + identifier));
        return identifier;
    }

    public String getMetadata(String doi) throws OSTIElinkException {
        return this.getMetadata(doi, DOI);
    }

    protected String getMetadataFromOstiId(String ostiId) throws OSTIElinkException {
        return this.getMetadata(ostiId, "osti_id");
    }

    private String getMetadata(String identifier, String type) throws OSTIElinkException {
        String metadata = null;
        if (identifier != null && !identifier.trim().equals("")) {
            identifier = OSTIElinkService.removeDOI(identifier);
            String url = null;
            try {
                url = this.baseURL + "?" + type + "=" + URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new OSTIElinkException("OSTIElinkService.getMetadata - couldn't encode the query url: " + e.getMessage());
            }
            log.debug((Object)("OSTIElinkService.getMetadata - the url sending the service is " + url));
            byte[] response = this.sendRequest(1, url);
            metadata = new String(response);
            log.debug((Object)("OSTIElinkService.getMetadata - the reponse is " + metadata));
            if (metadata == null || metadata.trim().equals("")) {
                throw new OSTIElinkNotFoundException("OSTIElinkService.getMetadata - the reponse is blank. So we can't find the identifier " + identifier + ", which type is " + type);
            }
            if (!metadata.contains(identifier)) {
                Document doc = OSTIElinkService.generateDOM(response);
                String numFound = this.getAttributeValue(doc, "records", "numfound");
                if (numFound.equals("0")) {
                    throw new OSTIElinkNotFoundException("OSTIElinkService.getMetadata - OSTI can't find the identifier " + identifier + ", which type is " + type + " since " + metadata);
                }
                throw new OSTIElinkException(metadata);
            }
        }
        return metadata;
    }

    public void setMetadata(String doi, String doiPrefix, String metadataXML) throws OSTIElinkException {
        String ostiId = this.getOstiId(doi, doiPrefix);
        String newMetadataXML = this.addOrReplaceOstiIdToXMLMetadata(ostiId, metadataXML);
        log.debug((Object)("OSTIElinkService.setMetadata - the new xml metadata with the osti id " + ostiId + " for the doi identifier " + doi + " is:\n" + newMetadataXML));
        byte[] reponse = this.sendRequest(3, this.baseURL, newMetadataXML);
        log.debug((Object)("OSTIElinkService.setMetadata - the response from the OSTI service is:\n " + new String(reponse)));
        Document doc = OSTIElinkService.generateDOM(reponse);
        String status = this.getElementValue(doc, STATUS);
        if (status == null || !status.equalsIgnoreCase(SUCCESS)) {
            throw new OSTIElinkException("OSTIElinkService.setMetadata - Error:  " + new String(reponse));
        }
    }

    public String getStatus(String doi) throws OSTIElinkException {
        String status = null;
        String metadata = this.getMetadata(doi);
        if (metadata == null) {
            throw new OSTIElinkException("OSTIElinkService.getStatus - the metadata of the DOI " + doi + " can't be found.");
        }
        Document doc = OSTIElinkService.generateDOM(metadata.getBytes());
        status = this.getAttributeValue(doc, "record", STATUS);
        log.debug((Object)("OSTIElinkService.getStatus - the status of " + doi + " is " + status));
        return status;
    }

    private String addOrReplaceOstiIdToXMLMetadata(String ostiId, String metadataXML) throws OSTIElinkException {
        if (metadataXML == null || metadataXML.trim().equals("")) {
            throw new OSTIElinkException("OSTIElinkService.setMetadata - the metadata part mustn't be null or blank.");
        }
        Document doc = OSTIElinkService.generateDOM(metadataXML.getBytes());
        NodeList osti_id_nodes = doc.getElementsByTagName("osti_id");
        if (osti_id_nodes.getLength() == 0) {
            NodeList records = doc.getElementsByTagName("record");
            if (records.getLength() != 1) {
                throw new OSTIElinkException("DOIService.addOrReplaceOstiIdToXMLMetadata - the metadata must only one record.");
            }
            Node record = records.item(0);
            Element ostiNode = doc.createElement("osti_id");
            Text newText = doc.createTextNode(ostiId);
            ostiNode.appendChild(newText);
            record.insertBefore(ostiNode, record.getFirstChild());
        } else if (osti_id_nodes.getLength() == 1) {
            Node osti_id_node = osti_id_nodes.item(0);
            NodeList children = osti_id_node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                Text newText = doc.createTextNode(ostiId);
                child.getParentNode().replaceChild(newText, child);
                break;
            }
        } else {
            throw new OSTIElinkException("DOIService.addOrReplaceOstiIdToXMLMetadata - the metadata shouldn't have more than one osti id.");
        }
        return OSTIElinkService.serialize(doc);
    }

    private static CloseableHttpClient createThreadSafeClient() {
        PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager();
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingConnManager).build();
        poolingConnManager.setMaxTotal(5);
        poolingConnManager.setDefaultMaxPerRoute(8);
        return client;
    }

    private byte[] sendRequest(int requestType, String uri) throws OSTIElinkException {
        return this.sendRequest(requestType, uri, null);
    }

    private byte[] sendRequest(int requestType, String uri, String requestBody) throws OSTIElinkException {
        HttpGet request = null;
        log.debug((Object)("OSTIElinkService.sendRequest - Trying uri: " + uri));
        switch (requestType) {
            case 1: {
                request = new HttpGet(uri);
                break;
            }
            case 2: {
                request = new HttpPut(uri);
                if (requestBody == null || requestBody.length() <= 0) break;
                StringEntity myEntity = new StringEntity(requestBody, "UTF-8");
                ((HttpPut)request).setEntity((HttpEntity)myEntity);
                break;
            }
            case 3: {
                request = new HttpPost(uri);
                if (requestBody == null || requestBody.length() <= 0) break;
                StringEntity myEntity = new StringEntity(requestBody, "UTF-8");
                ((HttpPost)request).setEntity((HttpEntity)myEntity);
                break;
            }
            case 4: {
                request = new HttpDelete(uri);
                break;
            }
            default: {
                throw new OSTIElinkException("Unrecognized HTTP method requested.");
            }
        }
        request.addHeader("Accept", "application/xml");
        request.addHeader("Authorization", "Basic " + new String(this.encodedAuthStr));
        byte[] body = null;
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toByteArray((HttpEntity)entity);
            }
        }
        catch (ClientProtocolException e) {
            throw new OSTIElinkException(e.getMessage());
        }
        catch (IOException e) {
            throw new OSTIElinkException(e.getMessage());
        }
        return body;
    }

    protected String buildMinimalMetadata(String siteCode) throws OSTIElinkException {
        String metadataStr = null;
        if (this.minimalMetadataDoc == null) {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(minimalMetadataFile);){
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    this.minimalMetadataDoc = dBuilder.parse(is);
                    this.originalDefaultSiteCode = this.getElementValue(this.minimalMetadataDoc, "site_input_code");
                    log.debug((Object)("DOIService.buildMinimalMetadata - the original site code in the minimal metadata is " + this.originalDefaultSiteCode));
                }
                catch (ParserConfigurationException e) {
                    throw new OSTIElinkException("OSTIElink.buildMinimalMetadata - Error: " + e.getMessage());
                }
                catch (SAXException e) {
                    throw new OSTIElinkException("OSTIElink.buildMinimalMetadata - Error: " + e.getMessage());
                }
                catch (IOException e) {
                    throw new OSTIElinkException("OSTIElink.buildMinimalMetadata - Error: " + e.getMessage());
                }
            }
            catch (IOException ee) {
                throw new OSTIElinkException("OSTIElink.buildMinimalMetadata - Error to read the file: " + ee.getMessage());
            }
        }
        if (siteCode != null && !siteCode.trim().equals("")) {
            this.modifySiteCode(siteCode);
        } else if (!this.originalDefaultSiteCode.equals(this.currentDefaultSiteCode)) {
            this.modifySiteCode(this.originalDefaultSiteCode);
        }
        metadataStr = OSTIElinkService.serialize(this.minimalMetadataDoc);
        return metadataStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifySiteCode(String siteCode) throws OSTIElinkException {
        Document document = this.minimalMetadataDoc;
        synchronized (document) {
            NodeList nodes = this.minimalMetadataDoc.getElementsByTagName("site_input_code");
            if (nodes.getLength() > 0) {
                Node node = nodes.item(0);
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 3) continue;
                    Text newText = this.minimalMetadataDoc.createTextNode(siteCode);
                    child.getParentNode().replaceChild(newText, child);
                    this.currentDefaultSiteCode = siteCode;
                    break;
                }
            } else {
                throw new OSTIElinkException("DOIService.buildMinimalMetadata - the minimal metadata should have the site_input_code element.");
            }
        }
    }

    protected static String removeDOI(String identifier) {
        log.debug((Object)("OSTIElinkService.removeDOI - the origial identifier is " + identifier));
        String doiPrefix = "doi:";
        if (identifier != null && identifier.startsWith(doiPrefix)) {
            identifier = identifier.substring(identifier.indexOf(doiPrefix) + doiPrefix.length());
        }
        log.debug((Object)("OSTIElinkService.removeDOI - the identifier after removing doi is " + identifier));
        return identifier;
    }

    protected String getOstiId(String doi, String prefix) throws OSTIElinkException {
        String ostiId = null;
        if (doi == null || doi.trim().equals("")) {
            throw new OSTIElinkException("DOIService.getOstiId - the given doi shouldn't be null or blank when it figures out the OSTI id for a DOI.");
        }
        if (prefix != null && !prefix.trim().equals("")) {
            prefix = OSTIElinkService.removeDOI(prefix);
            if ((doi = OSTIElinkService.removeDOI(doi)).contains(prefix)) {
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                ostiId = doi.substring(doi.indexOf(prefix) + prefix.length());
                log.debug((Object)("OSTIElinkService.getOstiId - tried to use prefix " + prefix + " to get the osti id " + ostiId + " from the doi identifier " + doi + " without querying the services"));
            }
        }
        if (ostiId == null || ostiId.trim().equals("")) {
            String metadata = this.getMetadata(doi);
            Document doc = OSTIElinkService.generateDOM(metadata.getBytes());
            ostiId = this.getElementValue(doc, "osti_id");
            log.debug((Object)("OSTIElinkService.getOstiId - tried to query the service to get the osti id " + ostiId + " from the doi idetnifier " + doi));
        }
        log.debug((Object)("OSTIElinkService.getOstiId - the osti id of the doi identifier " + doi + " is " + ostiId));
        return ostiId;
    }

    private static Document generateDOM(byte[] bytes) throws OSTIElinkException {
        Document doc = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new OSTIElinkException("OSTIElink.generateDOM - Error: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new OSTIElinkException("OSTIElink.generateDOM - Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new OSTIElinkException("OSTIElink.generateDOM - Error: " + e.getMessage());
        }
        return doc;
    }

    private String getElementValue(Document doc, String elementName) {
        NodeList nodes;
        String value = null;
        if (doc != null && elementName != null && !elementName.trim().equals("") && (nodes = doc.getElementsByTagName(elementName)).getLength() > 0) {
            Node node = nodes.item(0);
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                value = child.getNodeValue().trim();
                log.debug((Object)("OSTIElinkService.getElementValue - the value of the element " + elementName + " is " + value));
                break;
            }
        }
        return value;
    }

    private String getAttributeValue(Document doc, String elementName, String attributeName) {
        NodeList nodes;
        String value = null;
        if (doc != null && elementName != null && !elementName.trim().equals("") && attributeName != null && !attributeName.trim().equals("") && (nodes = doc.getElementsByTagName(elementName)).getLength() > 0) {
            Node node = nodes.item(0);
            Element e = (Element)node;
            value = e.getAttribute(attributeName).trim();
        }
        log.debug((Object)("OSTIElinkService.getAttributeValue - the value of the attribute " + attributeName + " on the element " + elementName + " is " + value));
        return value;
    }

    protected static String serialize(Document doc) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(doc);
    }
}

