/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.matcher.bioportal;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.dataone.annotator.matcher.ConceptItem;
import org.dataone.annotator.matcher.ConceptMatcher;
import org.dataone.annotator.ontology.MeasurementTypeGenerator;
import org.dataone.configuration.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BioPortalService
implements ConceptMatcher {
    private static Log log = LogFactory.getLog(BioPortalService.class);
    private String restUrl = Settings.getConfiguration().getString("annotator.matcher.bioportal.restUrl", "http://data.bioontology.org");
    private String apiKey = Settings.getConfiguration().getString("annotator.matcher.bioportal.apiKey", "24e4775e-54e0-11e0-9d7b-005056aa3316");
    private String ontologies = Settings.getConfiguration().getString("annotator.matcher.bioportal.ontologies", "ECSO,PROV-ONE,DATA-CITE,DC-TERMS,OWL-TIME");
    private MeasurementTypeGenerator mtg = new MeasurementTypeGenerator();

    @Override
    public List<ConceptItem> getConcepts(String text, String unit, String context) throws Exception {
        List<ConceptItem> concepts = this.lookupAnnotationClasses(text, this.ontologies);
        return concepts;
    }

    @Override
    public List<ConceptItem> getConcepts(Map<String, String> queryItems) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String value : queryItems.values()) {
            sb.append(value);
            sb.append(" ");
        }
        return this.getConcepts(sb.toString(), null, null);
    }

    private List<ConceptItem> lookupAnnotationClasses(String text, String ontologies) {
        if (text == null || text.length() == 0) {
            return null;
        }
        ArrayList<ConceptItem> results = new ArrayList<ConceptItem>();
        try {
            String urlParameters = "apikey=" + this.apiKey;
            urlParameters = urlParameters + "&format=xml&include=prefLabel,definition";
            if (ontologies != null) {
                urlParameters = urlParameters + "&ontologies=" + ontologies;
            }
            urlParameters = urlParameters + "&text=" + URLEncoder.encode(text, "UTF-8");
            String url = this.restUrl + "/annotator?" + urlParameters;
            URL restURL = new URL(url);
            InputStream is = restURL.openStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            NodeList classNodeList = XPathAPI.selectNodeList((Node)doc, (String)"//annotation/annotatedClass");
            if (classNodeList != null && classNodeList.getLength() > 0) {
                log.info((Object)("annotator suggested concept count: " + classNodeList.getLength()));
                for (int i = 0; i < classNodeList.getLength(); ++i) {
                    boolean isSubclass;
                    Node defNode;
                    Node annotatedClassNode = classNodeList.item(i);
                    String classURI = XPathAPI.selectSingleNode((Node)annotatedClassNode, (String)"id").getFirstChild().getNodeValue();
                    log.info((Object)("annotator suggested: " + classURI));
                    ConceptItem concept = new ConceptItem();
                    concept.setUri(new URI(classURI));
                    Node labelNode = XPathAPI.selectSingleNode((Node)annotatedClassNode, (String)"prefLabel");
                    if (labelNode != null) {
                        concept.setLabel(labelNode.getFirstChild().getNodeValue());
                    }
                    if ((defNode = XPathAPI.selectSingleNode((Node)annotatedClassNode, (String)"definitionCollection/definition")) != null) {
                        concept.setDefinition(defNode.getFirstChild().getNodeValue());
                    }
                    if (!(isSubclass = this.mtg.isMeasurementTypeSubclass(classURI))) continue;
                    results.add(concept);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not lookup BioPortal annotation for text=" + text), (Throwable)e);
        }
        return results;
    }
}

