/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.matcher.esor;

import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dataone.annotator.matcher.ConceptItem;
import org.dataone.annotator.matcher.ConceptMatcher;
import org.dataone.annotator.ontology.MeasurementTypeGenerator;
import org.json.JSONArray;
import org.json.JSONObject;

public class EsorService
implements ConceptMatcher {
    private static Log log = LogFactory.getLog(EsorService.class);
    private static final String REST_URL = "https://esor.tw.rpi.edu/annotate/annotate";
    private MeasurementTypeGenerator mtg = new MeasurementTypeGenerator();

    @Override
    public List<ConceptItem> getConcepts(String fullText, String unit, String context) throws Exception {
        String query = this.parseTerm(fullText);
        String escapedSpaceQuery = this.escapeToSpace(query);
        String escapedCommaQuery = this.escapeToComma(query);
        return this.lookupEsor(escapedSpaceQuery, unit, context);
    }

    @Override
    public List<ConceptItem> getConcepts(Map<String, String> queryItems) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String value : queryItems.values()) {
            sb.append(value);
            sb.append(" ");
        }
        return this.getConcepts(sb.toString(), null, null);
    }

    private List<ConceptItem> lookupEsor(String query, String unit, String context) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        String uriStr = REST_URL;
        log.debug((Object)("uriStr=" + uriStr));
        HttpPost method = new HttpPost(uriStr);
        method.setHeader("Accept", "*/*");
        JSONObject jsonParams = new JSONObject();
        jsonParams.put("query", (Object)query);
        if (context != null) {
            jsonParams.put("context", (Object)context);
        }
        if (unit != null) {
            jsonParams.put("unit", (Object)unit);
        }
        StringEntity entity = new StringEntity(jsonParams.toString(), ContentType.APPLICATION_JSON);
        method.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)method);
        int code = response.getStatusLine().getStatusCode();
        if (2 != code / 100) {
            throw new Exception("response code " + code + " for resource at " + uriStr);
        }
        InputStream body = response.getEntity().getContent();
        String jsonStr = IOUtils.toString((InputStream)body, (String)"UTF-8");
        log.debug((Object)("jsonStr=" + jsonStr));
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("results");
        ArrayList<ConceptItem> concepts = new ArrayList<ConceptItem>();
        for (int i = 0; i < results.length(); ++i) {
            JSONObject r = results.getJSONObject(i);
            JSONArray annotations = r.getJSONArray("annotations");
            for (int j = 0; j < annotations.length(); ++j) {
                boolean isSubclass;
                JSONObject a = annotations.getJSONObject(j);
                String url = a.getString("url");
                String score = a.getString("score");
                System.out.println("url=" + url + ", score=" + score);
                if (url.length() <= 0 || !(isSubclass = this.mtg.isMeasurementTypeSubclass(url))) continue;
                ConceptItem c = new ConceptItem(new URI(url), Double.parseDouble(score));
                concepts.add(c);
            }
        }
        Collections.sort(concepts, new Comparator<ConceptItem>(){

            @Override
            public int compare(ConceptItem o1, ConceptItem o2) {
                return Double.compare(o1.getWeight(), o2.getWeight());
            }
        });
        Collections.reverse(concepts);
        return concepts;
    }

    private String parseTerm(String str) throws Exception {
        if (str.contains("(")) {
            str = str.substring(0, str.indexOf("("));
        }
        str = str.replaceAll("\\s+$", "");
        str = this.replaceFromSlashToSpace(this.replaceFromDotToSpace(this.replaceFromDashToSpace(str)));
        str = str.replace("%", " percent");
        str = this.insertSpaceBeforeCapital(str);
        str = URLEncoder.encode(str, "UTF-8").replaceAll("\\+", "%20");
        return str;
    }

    private String replaceFromDotToSpace(String str) {
        return str.replace(".", " ");
    }

    private String replaceFromSlashToSpace(String str) {
        return str.replace("/", " ");
    }

    private String insertSpaceBeforeCapital(String str) {
        char[] charArr = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < charArr.length; ++i) {
            if (i > 0 && charArr[i] >= 'A' && charArr[i] <= 'Z' && charArr[i - 1] >= 'a' && charArr[i - 1] <= 'z') {
                sb.append(" ");
            }
            sb.append(charArr[i]);
        }
        return sb.toString();
    }

    private String replaceFromDashToSpace(String original) {
        return original.replace("_", " ");
    }

    private String escapeToSpace(String original) {
        return original.replace(" ", "%20");
    }

    private String escapeToComma(String original) {
        return original.replace("%20", ",");
    }

    private List<ConceptItem> mergeRes(List<ConceptItem> res_escapedSpace, List<ConceptItem> res_escapedComma) {
        if (res_escapedSpace.size() == 0) {
            return res_escapedComma;
        }
        if (res_escapedComma.size() == 0) {
            return res_escapedSpace;
        }
        int indexS = 0;
        int indexC = 0;
        while (indexS < res_escapedSpace.size()) {
            if (indexC < res_escapedComma.size() && res_escapedComma.get(indexC).getWeight() >= res_escapedSpace.get(indexS).getWeight()) {
                res_escapedSpace.add(indexS, res_escapedComma.get(indexC));
                ++indexS;
                ++indexC;
                continue;
            }
            ++indexS;
        }
        for (int i = indexC; i < res_escapedComma.size(); ++i) {
            res_escapedSpace.add(res_escapedComma.get(i));
        }
        return res_escapedSpace;
    }
}

