/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprTypeException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.vocabulary.XSD;

public class NodeFunctions {
    private static final NodeValue xsdString = NodeValue.makeNode(XSD.xstring.asNode());

    public static NodeValue sameTerm(NodeValue nv1, NodeValue nv2) {
        return NodeValue.booleanReturn(NodeFunctions.sameTerm(nv1.asNode(), nv2.asNode()));
    }

    public static boolean sameTerm(Node n1, Node n2) {
        if (n1.equals((Object)n2)) {
            return true;
        }
        if (n1.isLiteral() && n2.isLiteral()) {
            boolean b;
            String lang1 = n1.getLiteralLanguage();
            String lang2 = n2.getLiteralLanguage();
            if (!lang1.equals("") && lang1.equalsIgnoreCase(lang2) && (b = n1.getLiteralLexicalForm().equals(n2.getLiteralLexicalForm()))) {
                return true;
            }
        }
        return false;
    }

    public static NodeValue rdfTermEquals(NodeValue nv1, NodeValue nv2) {
        return NodeValue.booleanReturn(NodeFunctions.rdfTermEquals(nv1.asNode(), nv2.asNode()));
    }

    public static boolean rdfTermEquals(Node n1, Node n2) {
        if (n1.equals((Object)n2)) {
            return true;
        }
        if (n1.isLiteral() && n2.isLiteral()) {
            boolean b;
            String lang1 = n1.getLiteralLanguage();
            String lang2 = n2.getLiteralLanguage();
            if (!lang1.equals("") && lang1.equalsIgnoreCase(lang2) && (b = n1.getLiteralLexicalForm().equals(n2.getLiteralLexicalForm()))) {
                return true;
            }
            NodeValue.raise(new ExprEvalException("Mismatch in RDFterm-equals: " + n1 + ", " + n2));
        }
        return false;
    }

    public static NodeValue str(NodeValue nv) {
        return NodeValue.makeString(NodeFunctions.str(nv.asNode()));
    }

    public static String str(Node node) {
        if (node.isLiteral()) {
            return node.getLiteral().getLexicalForm();
        }
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank()) {
            NodeValue.raise(new ExprTypeException("Blank node: " + node));
        }
        NodeValue.raise(new ExprEvalException("Not a string: " + node));
        return "[undef]";
    }

    public static NodeValue datatype(NodeValue nv) {
        return NodeValue.makeNode(NodeFunctions.datatype(nv.asNode()));
    }

    public static Node datatype(Node node) {
        boolean plainLiteral;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("datatype: Not a literal: " + node));
            return null;
        }
        String s = node.getLiteralDatatypeURI();
        boolean bl = plainLiteral = s == null || s.equals("");
        if (plainLiteral) {
            boolean simpleLiteral;
            boolean bl2 = simpleLiteral = node.getLiteralLanguage() == null || node.getLiteralLanguage().equals("");
            if (!simpleLiteral) {
                NodeValue.raise(new ExprTypeException("datatype: Literal has language tag: " + node));
            }
            return XSD.xstring.asNode();
        }
        return Node.createURI((String)s);
    }

    public static NodeValue lang(NodeValue nv) {
        return NodeValue.makeString(NodeFunctions.lang(nv.asNode()));
    }

    public static String lang(Node node) {
        String s;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("lang: Not a literal: " + FmtUtils.stringForNode(node)));
        }
        if ((s = node.getLiteralLanguage()) == null) {
            s = "";
        }
        return s;
    }

    public static NodeValue langMatches(NodeValue nv, NodeValue nvPattern) {
        return NodeFunctions.langMatches(nv, nvPattern.getString());
    }

    public static NodeValue langMatches(NodeValue nv, String langPattern) {
        String range;
        Node node = nv.asNode();
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("langMatches: not a literal: " + node));
            return null;
        }
        String nodeLang = node.getLiteralLexicalForm();
        if (langPattern.equals("*")) {
            if (nodeLang == null || nodeLang.equals("")) {
                return NodeValue.FALSE;
            }
            return NodeValue.TRUE;
        }
        String[] langElts = nodeLang.split("-");
        String[] langRangeElts = langPattern.split("-");
        if (langRangeElts.length > langElts.length) {
            return NodeValue.FALSE;
        }
        for (int i = 0; i < langRangeElts.length && (range = langRangeElts[i]) != null && i < langElts.length; ++i) {
            String lang = langElts[i];
            if (range.equals("*") || range.equalsIgnoreCase(lang)) continue;
            return NodeValue.FALSE;
        }
        return NodeValue.TRUE;
    }

    public static NodeValue isIRI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isIRI(Node node) {
        return node.isURI();
    }

    public static NodeValue isURI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isURI(Node node) {
        return NodeFunctions.isIRI(node);
    }

    public static NodeValue isBlank(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isBlank(nv.asNode()));
    }

    public static boolean isBlank(Node node) {
        return node.isBlank();
    }

    public static NodeValue isLiteral(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isLiteral(nv.asNode()));
    }

    public static boolean isLiteral(Node node) {
        return node.isLiteral();
    }
}

