/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.Arg;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgProc;
import arq.cmdline.CommandLineBase;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CmdLineArgs
extends CommandLineBase {
    private boolean processedArgs = false;
    protected Map argMap = new HashMap();
    protected Map args = new HashMap();
    protected List positionals = new ArrayList();
    static final String DefaultIndirectMarker = "@";

    public CmdLineArgs(String[] args) {
        super(args);
    }

    public void process() throws IllegalArgumentException {
        this.processedArgs = true;
        this.apply(new ArgProcessor());
    }

    public CmdLineArgs add(String argName, boolean hasValue) {
        return this.add(new ArgDecl(hasValue, argName));
    }

    public CmdLineArgs add(boolean hasValue, String argName) {
        return this.add(new ArgDecl(hasValue, argName));
    }

    public CmdLineArgs add(ArgDecl arg) {
        Iterator iter = arg.names();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.argMap.containsKey(name)) {
                ALog.warn((Object)this, (String)("Argument '" + name + "' already added"));
            }
            this.argMap.put(name, arg);
        }
        return this;
    }

    public CmdLineArgs addPositional(String value) {
        this.positionals.add(value);
        return this;
    }

    public CmdLineArgs addArg(String name) {
        return this.addArg(name, null);
    }

    public CmdLineArgs addArg(String name, String value) {
        if (!this.args.containsKey(name)) {
            this.args.put(name, new Arg(name));
        }
        Arg arg = (Arg)this.args.get(name);
        return this.addArgWorker(arg, value);
    }

    private CmdLineArgs addArgWorker(Arg arg, String value) {
        ArgDecl argDecl = (ArgDecl)this.argMap.get(arg.name);
        if (!argDecl.takesValue() && value != null) {
            throw new IllegalArgumentException("No value for argument: " + arg.getName());
        }
        if (argDecl.takesValue()) {
            if (value == null) {
                throw new IllegalArgumentException("No value for argument: " + arg.getName());
            }
            arg.setValue(value);
            arg.addValue(value);
        }
        return this;
    }

    public boolean matchesIndirect(String s) {
        return this.matchesIndirect(s, DefaultIndirectMarker);
    }

    public boolean matchesIndirect(String s, String marker) {
        return s.startsWith(marker);
    }

    public String indirect(String s) {
        return this.indirect(s, DefaultIndirectMarker);
    }

    public String indirect(String s, String marker) {
        if (!this.matchesIndirect(s, marker)) {
            return s;
        }
        s = s.substring(marker.length());
        s = FileManager.get().readWholeFileAsUTF8(s);
        return s;
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String s) {
        return this.getArg(s) != null;
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public boolean hasArg(String argName) {
        return this.getArg(argName) != null;
    }

    public boolean hasArg(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        Iterator iter = this.args.values().iterator();
        while (iter.hasNext()) {
            Arg a = (Arg)iter.next();
            if (!argDecl.matches(a)) continue;
            arg = a;
        }
        return arg;
    }

    public Arg getArg(String s) {
        s = ArgDecl.canonicalForm(s);
        return (Arg)this.args.get(s);
    }

    public String getValue(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public String getValue(String argName) {
        Arg arg = this.getArg(argName);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    public List getValues(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return new ArrayList();
        }
        return arg.getValues();
    }

    public List getValues(String argName) {
        Arg arg = this.getArg(argName);
        if (arg == null) {
            return new ArrayList();
        }
        return arg.getValues();
    }

    public String getPositionalArg(int i) {
        return (String)this.positionals.get(i);
    }

    public int getNumPositional() {
        return this.positionals.size();
    }

    public boolean hasPositional() {
        return this.positionals.size() > 0;
    }

    public List getPositional() {
        return this.positionals;
    }

    protected void handleUnrecognizedArg(String argStr) {
        throw new CmdException("Unknown argument: " + argStr);
    }

    private ArgDecl find(String a) {
        a = ArgDecl.canonicalForm(a);
        return (ArgDecl)this.argMap.get(a);
    }

    public String toString() {
        if (!this.processedArgs) {
            return super.toString();
        }
        String str = "";
        String sep = "";
        Iterator<Object> iter = this.args.keySet().iterator();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            Arg a = (Arg)this.args.get(k);
            str = str + sep + a;
            sep = " ";
        }
        sep = " -- ";
        iter = this.positionals.iterator();
        while (iter.hasNext()) {
            String v = (String)iter.next();
            str = str + sep + v;
            sep = " ";
        }
        return str;
    }

    class ArgProcessor
    implements ArgProc {
        boolean nextArgProcessed = false;
        boolean positionalArgsStarted = false;

        ArgProcessor() {
        }

        public void startArgs() {
            this.nextArgProcessed = false;
            this.positionalArgsStarted = false;
        }

        public void finishArgs() {
        }

        public void arg(String argStr, int i) {
            if (this.nextArgProcessed) {
                this.nextArgProcessed = false;
                return;
            }
            if (this.positionalArgsStarted) {
                CmdLineArgs.this.addPositional(argStr);
                return;
            }
            if (argStr.equals("-") || argStr.equals("--")) {
                this.positionalArgsStarted = true;
                return;
            }
            if (!argStr.startsWith("-")) {
                this.positionalArgsStarted = true;
                CmdLineArgs.this.addPositional(argStr);
                return;
            }
            if (!CmdLineArgs.this.argMap.containsKey(argStr = ArgDecl.canonicalForm(argStr))) {
                CmdLineArgs.this.handleUnrecognizedArg(argStr);
                return;
            }
            ArgDecl argDecl = (ArgDecl)CmdLineArgs.this.argMap.get(argStr);
            if (argDecl.takesValue()) {
                String val = CmdLineArgs.this.getArg(i + 1);
                CmdLineArgs.this.addArg(argStr, val);
                this.nextArgProcessed = true;
            } else {
                CmdLineArgs.this.addArg(argStr);
            }
        }
    }
}

