/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Txn
extends Locker
implements LogWritable,
LogReadable {
    private static final String DEBUG_NAME;
    private byte txnState;
    private Set cursors;
    private static final byte USABLE = 0;
    private static final byte CLOSED = 1;
    private Latch lockLatch;
    private Set readLocks;
    private Map writeInfo;
    private Set deletedDatabases;
    private boolean onceOwnedDbHandleWriteLock;
    private Map undoDatabases;
    private DbLsn lastLoggedLsn = null;
    private DbLsn firstLoggedLsn = null;
    private boolean defaultSync;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Txn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        super(envImpl, config.getDirtyRead(), config.getNoWait());
        this.defaultSync = config.getSync() || !config.getNoSync();
        this.cursors = new HashSet();
        this.lockLatch = new Latch(envImpl);
        this.readLocks = new HashSet();
        this.writeInfo = new HashMap();
        this.undoDatabases = new HashMap();
        this.lastLoggedLsn = DbLsn.NULL_LSN;
        this.firstLoggedLsn = null;
        this.txnState = 0;
        this.envImpl.getTxnManager().registerTxn(this);
        this.onceOwnedDbHandleWriteLock = false;
    }

    public Txn() {
        this.lastLoggedLsn = new DbLsn();
    }

    protected long generateId(TxnManager txnManager) {
        return txnManager.incTxnId();
    }

    DbLsn getLastLsn() {
        return this.lastLoggedLsn;
    }

    public LockResult writeLock(LN ln, DatabaseImpl database) throws DatabaseException {
        this.checkState(true);
        LockGrantType grant = this.lockManager.lock(ln.getNodeId(), this, LockType.WRITE, this.lockTimeOutMillis, this.defaultNoWait);
        this.lockLatch.acquire();
        WriteLockInfo info = (WriteLockInfo)this.writeInfo.get(new Long(ln.getNodeId()));
        this.undoDatabases.put(database.getId(), database);
        this.lockLatch.release();
        return new LockResult(grant, info);
    }

    public DbLsn commit() throws DatabaseException {
        return this.commit(this.defaultSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLsn commit(boolean doSync) throws DatabaseException {
        this.checkState(true);
        Txn txn = this;
        synchronized (txn) {
            try {
                Iterator<Object> iter;
                if (this.checkCursorsForClose()) {
                    throw new DatabaseException("Transaction " + this.id + " commit failed because there were open cursors");
                }
                if (this.handleLockToHandleMap != null) {
                    Iterator handleLockIter = this.handleLockToHandleMap.entrySet().iterator();
                    while (handleLockIter.hasNext()) {
                        Map.Entry entry = handleLockIter.next();
                        this.transferHandleLockToHandleSet((Long)entry.getKey(), (Set)entry.getValue());
                    }
                }
                LogManager logManager = this.envImpl.getLogManager();
                int numWriteLocks = this.writeInfo.size();
                int numReadLocks = this.readLocks.size();
                this.lockLatch.acquire();
                DbLsn commitLsn = null;
                try {
                    if (numReadLocks > 0) {
                        Iterator iter2 = this.readLocks.iterator();
                        while (iter2.hasNext()) {
                            Lock rLock = (Lock)iter2.next();
                            this.lockManager.release(rLock, (Locker)this);
                        }
                        this.readLocks.clear();
                    }
                    if (numWriteLocks > 0 || this.onceOwnedDbHandleWriteLock) {
                        TxnCommit commitRecord = new TxnCommit(this.id, this.lastLoggedLsn);
                        commitLsn = doSync ? logManager.logForceFlush(commitRecord) : logManager.log(commitRecord);
                        iter = this.writeInfo.values().iterator();
                        while (iter.hasNext()) {
                            WriteLockInfo info = (WriteLockInfo)iter.next();
                            this.lockManager.release(info.lock, (Locker)this);
                        }
                        this.writeInfo.clear();
                    }
                }
                finally {
                    this.lockLatch.release();
                }
                if (numWriteLocks > 0) {
                    Txn txn2 = this;
                    synchronized (txn2) {
                        if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                            this.envImpl.addToCompressorQueue(this.deleteInfo);
                            this.deleteInfo.clear();
                        }
                        if (this.deletedDatabases != null) {
                            iter = this.deletedDatabases.iterator();
                            while (iter.hasNext()) {
                                DatabaseImpl db = (DatabaseImpl)iter.next();
                                db.deleteAndReleaseINs();
                            }
                            this.deletedDatabases.clear();
                        }
                    }
                }
                this.traceCommit(numWriteLocks, numReadLocks);
                this.close(true);
                return commitLsn;
            }
            catch (RunRecoveryException e) {
                throw e;
            }
            catch (Throwable t) {
                try {
                    if (this.lockLatch.isOwner()) {
                        this.lockLatch.release();
                    }
                    this.abort();
                    Tracer.trace(this.envImpl, "Txn", "commit", "Commit of transaction " + this.id + " failed", t);
                }
                catch (Throwable abortT2) {
                    throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ". The attempt to abort and clean up also failed. " + "The original exception seen from commit = " + t.getMessage() + " The exception from the cleanup = " + abortT2.getMessage(), t);
                }
                throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ", aborted instead. Original exception = " + t.getMessage(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLsn abort() throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            DbLsn dbLsn;
            try {
                Object info;
                this.checkState(false);
                this.lockLatch.acquire();
                int numWriteLocks = this.writeInfo.size();
                int numReadLocks = this.readLocks.size();
                TxnAbort abortRecord = new TxnAbort(this.id, this.lastLoggedLsn);
                DbLsn abortLsn = null;
                if (numWriteLocks > 0) {
                    abortLsn = this.envImpl.getLogManager().log(abortRecord);
                }
                this.undo();
                Iterator<Object> iter = this.readLocks.iterator();
                while (iter.hasNext()) {
                    Lock rLock = (Lock)iter.next();
                    this.lockManager.release(rLock, (Locker)this);
                }
                this.readLocks.clear();
                iter = this.writeInfo.values().iterator();
                while (iter.hasNext()) {
                    info = (WriteLockInfo)iter.next();
                    this.lockManager.release(((WriteLockInfo)info).lock, (Locker)this);
                }
                this.writeInfo.clear();
                this.lockLatch.release();
                info = this;
                synchronized (info) {
                    this.deleteInfo = null;
                    this.deletedDatabases = null;
                }
                boolean openCursors = this.checkCursorsForClose();
                Tracer.trace(Level.FINE, this.envImpl, "Abort:id = " + this.id + " numWriteLocks= " + numWriteLocks + " numReadLocks= " + numReadLocks + " openCursors= " + openCursors);
                if (openCursors) {
                    throw new DatabaseException("Transaction " + this.id + " detected open cursors while aborting");
                }
                if (this.handleToHandleLockMap != null) {
                    Iterator handleIter = this.handleToHandleLockMap.keySet().iterator();
                    while (handleIter.hasNext()) {
                        Database handle = (Database)handleIter.next();
                        DbInternal.dbInvalidate(handle);
                    }
                }
                dbLsn = abortLsn;
            }
            catch (Throwable throwable) {
                this.close(false);
                throw throwable;
            }
            this.close(false);
            return dbLsn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undo() throws DatabaseException {
        Long nodeId = null;
        DbLsn undoLsn = this.lastLoggedLsn;
        LogManager logManager = this.envImpl.getLogManager();
        try {
            HashSet<Long> alreadyUndone = new HashSet<Long>();
            TreeLocation location = new TreeLocation();
            while (!undoLsn.equals(DbLsn.NULL_LSN)) {
                LNLogEntry undoEntry = (LNLogEntry)logManager.getLogEntry(undoLsn);
                LN undoLN = undoEntry.getLN();
                nodeId = new Long(undoLN.getNodeId());
                if (!alreadyUndone.contains(nodeId)) {
                    boolean abortKnownDeleted;
                    DbLsn abortLsn;
                    block10: {
                        Object var14_17;
                        alreadyUndone.add(nodeId);
                        DatabaseId dbId = undoEntry.getDbId();
                        DatabaseImpl db = (DatabaseImpl)this.undoDatabases.get(dbId);
                        undoLN.postFetchInit(db);
                        abortLsn = undoEntry.getAbortLsn();
                        abortKnownDeleted = undoEntry.getAbortKnownDeleted();
                        try {
                            boolean insertedOrReplaced = RecoveryManager.undo(Level.FINER, db, location, undoLN, undoEntry.getKey(), undoEntry.getDupKey(), undoLsn, abortLsn, abortKnownDeleted, null, false);
                            var14_17 = null;
                            if (location.bin == null) break block10;
                        }
                        catch (Throwable throwable) {
                            var14_17 = null;
                            if (location.bin == null) throw throwable;
                            location.bin.releaseLatch();
                            throw throwable;
                        }
                        location.bin.releaseLatch();
                    }
                    DbLsn obsoleteLsn = null;
                    DbLsn nonObsoleteLsn = null;
                    if (!undoLN.isDeleted()) {
                        obsoleteLsn = undoLsn;
                    }
                    if (abortLsn != null && !abortKnownDeleted) {
                        nonObsoleteLsn = abortLsn;
                    }
                    if (obsoleteLsn != null || nonObsoleteLsn != null) {
                        logManager.countObsoleteLNs(obsoleteLsn, true, nonObsoleteLsn, false);
                    }
                }
                undoLsn = undoEntry.getUserTxn().getLastLsn();
            }
            return;
        }
        catch (DatabaseException e) {
            Tracer.trace(this.envImpl, "Txn", "undo", "for node=" + nodeId + " lsn=" + undoLsn.getNoFormatString(), e);
            throw e;
        }
    }

    public void addLogInfo(long nodeId, DbLsn lastLsn) throws DatabaseException {
        this.lastLoggedLsn = lastLsn;
        this.lockLatch.acquire();
        WriteLockInfo info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
        if (!$assertionsDisabled && info == null) {
            throw new AssertionError();
        }
        if (this.firstLoggedLsn == null) {
            this.firstLoggedLsn = lastLsn;
        }
        this.lockLatch.release();
    }

    DbLsn getFirstActiveLsn() throws DatabaseException {
        DbLsn first = null;
        this.lockLatch.acquire();
        first = this.firstLoggedLsn;
        this.lockLatch.release();
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsDeletedAtCommit(DatabaseImpl db) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            if (this.deletedDatabases == null) {
                this.deletedDatabases = new HashSet();
            }
            this.deletedDatabases.add(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLock(long nodeId, Lock lock, LockType type, LockGrantType grantStatus) throws DatabaseException {
        try {
            this.lockLatch.acquire();
            if (type == LockType.WRITE) {
                this.writeInfo.put(new Long(nodeId), new WriteLockInfo(lock));
                if (grantStatus == LockGrantType.PROMOTION || grantStatus == LockGrantType.WAIT_PROMOTION) {
                    this.readLocks.remove(lock);
                }
            } else {
                this.readLocks.add(lock);
            }
        }
        finally {
            if (this.lockLatch.isOwner()) {
                this.lockLatch.release();
            }
        }
    }

    void removeLock(long nodeId, Lock lock) throws DatabaseException {
        this.lockLatch.acquire();
        if (!this.readLocks.remove(lock) && this.writeInfo.remove(new Long(nodeId)) == null) {
            throw new DatabaseException("Couldn't find lock for Node " + nodeId + " in writeInfo Map.");
        }
        this.lockLatch.release();
    }

    void moveWriteToReadLock(long nodeId, Lock lock) throws DatabaseException {
        this.lockLatch.acquire();
        if (this.writeInfo.remove(new Long(nodeId)) == null) {
            this.lockLatch.release();
            throw new DatabaseException("Couldn't find lock for Node " + nodeId + " in writeInfo Map.");
        }
        this.readLocks.add(lock);
        this.lockLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createdNode(long nodeId) throws DatabaseException {
        boolean created = false;
        this.lockLatch.acquire();
        try {
            WriteLockInfo info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
            if (info != null) {
                created = info.createdThisTxn;
            }
        }
        finally {
            this.lockLatch.release();
        }
        return created;
    }

    public void setUndoDatabase(DatabaseId dbId, DatabaseImpl db) {
        this.undoDatabases.put(dbId, db);
    }

    public DbLsn getAbortLsn(long nodeId) throws DatabaseException {
        this.lockLatch.acquire();
        WriteLockInfo info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
        this.lockLatch.release();
        if (info == null) {
            return null;
        }
        return info.abortLsn;
    }

    public boolean getAbortKnownDeleted(long nodeId) throws DatabaseException {
        this.lockLatch.acquire();
        WriteLockInfo info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
        this.lockLatch.release();
        if (info == null) {
            return true;
        }
        return info.abortKnownDeleted;
    }

    public boolean isTransactional() {
        return true;
    }

    public Locker newInstance() throws DatabaseException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Only ThreadLocker should be cloned");
        }
        return null;
    }

    public boolean sharesLocksWith(Locker txn) {
        return false;
    }

    public void operationEnd() throws DatabaseException {
    }

    public void operationEnd(boolean operationOK) throws DatabaseException {
    }

    public void setHandleLockOwner(boolean operationOK, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (dbIsClosing) {
            Long handleLockId = (Long)this.handleToHandleLockMap.get(dbHandle);
            if (handleLockId != null) {
                Set dbHandleSet = (Set)this.handleLockToHandleMap.get(handleLockId);
                boolean removed = dbHandleSet.remove(dbHandle);
                if (!$assertionsDisabled && !removed) {
                    throw new AssertionError((Object)("Can't find " + dbHandle + " from dbHandleSet"));
                }
                if (dbHandleSet.size() == 0) {
                    Object foo = this.handleLockToHandleMap.remove(handleLockId);
                    if (!$assertionsDisabled && foo == null) {
                        throw new AssertionError((Object)("Can't find " + handleLockId + " from handleLockIdtoHandleMap."));
                    }
                }
            }
            this.unregisterHandle(dbHandle);
        } else if (dbHandle != null) {
            DbInternal.dbSetHandleLocker(dbHandle, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            this.cursors.add(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            this.cursors.remove(cursor);
        }
    }

    public boolean isHandleLockTransferrable() {
        return false;
    }

    private boolean checkCursorsForClose() throws DatabaseException {
        Iterator iter = this.cursors.iterator();
        while (iter.hasNext()) {
            CursorImpl c = (CursorImpl)iter.next();
            if (c.isClosed()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockStats collectStats(LockStats stats) throws DatabaseException {
        this.lockLatch.acquire();
        try {
            stats.setNReadLocks(stats.getNReadLocks() + this.readLocks.size());
            stats.setNWriteLocks(stats.getNWriteLocks() + this.writeInfo.size());
        }
        finally {
            if (this.lockLatch.isOwner()) {
                this.lockLatch.release();
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(boolean acquireLatch) throws DatabaseException {
        boolean ok = false;
        Txn txn = this;
        synchronized (txn) {
            ok = this.txnState == 0;
        }
        if (!ok) {
            throw new DatabaseException("Transaction " + this.id + " has been closed");
        }
    }

    private void close(boolean isCommit) throws DatabaseException {
        this.txnState = 1;
        this.envImpl.getTxnManager().unRegisterTxn(this, isCommit);
    }

    protected void rememberHandleWriteLock(Long handleLockId) {
        if (this.writeInfo.get(handleLockId) != null) {
            this.onceOwnedDbHandleWriteLock = true;
        }
    }

    public int getLogSize() {
        return 8 + this.lastLoggedLsn.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.id);
        this.lastLoggedLsn.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer logBuffer) {
        this.id = LogUtils.readLong(logBuffer);
        this.lastLoggedLsn.readFromLog(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<txn id=\"");
        sb.append(super.toString());
        sb.append("\">");
        this.lastLoggedLsn.dumpLog(sb, verbose);
        sb.append("</txn>");
    }

    public long getTransactionId() {
        return this.getId();
    }

    public boolean logEntryIsTransactional() {
        return true;
    }

    private void transferHandleLockToHandleSet(Long handleLockId, Set dbHandleSet) throws DatabaseException {
        this.rememberHandleWriteLock(handleLockId);
        int numHandles = dbHandleSet.size();
        Database[] dbHandles = new Database[numHandles];
        dbHandles = dbHandleSet.toArray(dbHandles);
        Locker[] destTxns = new Locker[numHandles];
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i] = new BasicLocker(this.envImpl);
        }
        long nodeId = handleLockId;
        this.lockManager.transferMultiple(nodeId, this, destTxns);
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i].addToHandleMaps(handleLockId, dbHandles[i]);
            DbInternal.dbSetHandleLocker(dbHandles[i], destTxns[i]);
        }
    }

    private void traceCommit(int numWriteLocks, int numReadLocks) {
        Logger logger = this.envImpl.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" Commit:id = ").append(this.id);
            sb.append(" numWriteLocks=").append(numWriteLocks);
            sb.append(" numReadLocks = ").append(numReadLocks);
            Tracer.trace(Level.FINE, this.envImpl, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !Txn.class.desiredAssertionStatus();
        DEBUG_NAME = Txn.class.getName();
    }
}

