/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.QualifiedRestriction;
import com.hp.hpl.jena.ontology.impl.RestrictionImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;

public class QualifiedRestrictionImpl
extends RestrictionImpl
implements QualifiedRestriction {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new QualifiedRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to QualifiedRestriction");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            return QualifiedRestrictionImpl.isValidQualifiedRestriction(node, eg);
        }
    };

    private static boolean isValidQualifiedRestriction(Node node, EnhGraph eg) {
        Profile profile;
        Profile profile2 = profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile != null && profile.isSupported(node, eg, QualifiedRestriction.class);
    }

    public boolean isValid() {
        return QualifiedRestrictionImpl.isValidQualifiedRestriction(this.asNode(), this.getGraph());
    }

    public QualifiedRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public void setHasClassQ(OntClass cls) {
        this.setPropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", cls);
    }

    public OntResource getHasClassQ() {
        this.checkProfile(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q");
        Resource r = this.getProperty(this.getProfile().HAS_CLASS_Q()).getResource();
        if (r.canAs(OntClass.class)) {
            return (OntClass)r.as(OntClass.class);
        }
        if (r.canAs(DataRange.class)) {
            return (DataRange)r.as(DataRange.class);
        }
        return (OntResource)r.as(OntResource.class);
    }

    public boolean hasHasClassQ(OntClass cls) {
        return this.hasPropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", cls);
    }

    public boolean hasHasClassQ(DataRange dr) {
        return this.hasPropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", dr);
    }

    public void removeHasClassQ(OntClass cls) {
        Property has_class_q = this.getProfile().HAS_CLASS_Q();
        this.removePropertyValue(has_class_q, "HAS_CLASS_Q", cls);
    }

    public void removeHasClassQ(DataRange dr) {
        this.removePropertyValue(this.getProfile().HAS_CLASS_Q(), "HAS_CLASS_Q", dr);
    }
}

