/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.exceptions.AmbiguousSpecificTypeException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;

public class TestAssemblerHelp
extends AssemblerTestBase {
    public static boolean impIsLoaded = false;
    public static boolean impIsConstructed = false;
    static Model gremlinModel = TestAssemblerHelp.modelWithStatements("eh:Wossname ja:assembler 'com.hp.hpl.jena.assembler.test.TestAssemblerHelp$Gremlin'");
    static boolean gremlinInvoked = false;

    public TestAssemblerHelp(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        throw new BrokenException("TestAssemblers does not need this method");
    }

    public void testClosureFootprint() {
        Resource root = this.resourceInModel("x ja:reasoner y");
        Statement footprint = root.getModel().createStatement(JA.This, RDF.type, (RDFNode)JA.Expanded);
        TestAssemblerHelp.assertFalse((boolean)root.getModel().contains(footprint));
        Resource expanded = AssemblerHelp.withFullModel((Resource)root);
        TestAssemblerHelp.assertTrue((boolean)expanded.getModel().contains(footprint));
    }

    public void testFootprintPreventsClosure() {
        Resource root = this.resourceInModel("x ja:reasoner y; ja:this rdf:type ja:Expanded");
        Model original = this.model("").add(root.getModel());
        Resource expanded = AssemblerHelp.withFullModel((Resource)root);
        TestAssemblerHelp.assertSame((Object)root, (Object)expanded);
        TestAssemblerHelp.assertIsoModels(original, expanded.getModel());
    }

    public void testSpecificType() {
        this.testSpecificType("ja:Connectable", "x ja:connection _C");
        this.testSpecificType("ja:NamedModel", "x ja:modelName 'name'");
        this.testSpecificType("ja:NamedModel", "x ja:modelName 'name'; x rdf:type irrelevant");
        this.testSpecificType("ja:RDBModel", "x rdf:type ja:RDBModel; x rdf:type ja:Model");
    }

    public void testFindSpecificTypes() {
        this.testFindSpecificTypes("", "x rdf:type A", "Top");
        this.testFindSpecificTypes("", "x rdf:type A; x rdf:type B", "Top");
        this.testFindSpecificTypes("A", "x rdf:type A; A rdfs:subClassOf Top", "Top");
        this.testFindSpecificTypes("A", "x rdf:type A; x rdf:type B; A rdfs:subClassOf Top", "Top");
        this.testFindSpecificTypes("A B", "x rdf:type A; x rdf:type B; A rdfs:subClassOf Top; B rdfs:subClassOf Top", "Top");
        this.testFindSpecificTypes("B", "x rdf:type A; x rdf:type B; A rdfs:subClassOf Top; B rdfs:subClassOf Top; B rdfs:subClassOf A", "Top");
    }

    private void testFindSpecificTypes(String expectedString, String model, String baseString) {
        Resource root = this.resourceInModel(model);
        Resource baseType = TestAssemblerHelp.resource(baseString);
        Set expected = TestAssemblerHelp.resourceSet(expectedString);
        Set answer = AssemblerHelp.findSpecificTypes((Resource)root, (Resource)baseType);
        TestAssemblerHelp.assertEquals((Object)expected, (Object)answer);
    }

    public void testFindRootByExplicitType() {
        Model model = this.model("x rdf:type ja:Object; y rdf:type Irrelevant");
        Set roots = AssemblerHelp.findAssemblerRoots((Model)model);
        TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resourceSet("x"), (Object)roots);
    }

    public void testFindRootByImplicitType() {
        Model model = this.model("x ja:reificationMode ja:Standard");
        Set roots = AssemblerHelp.findAssemblerRoots((Model)model);
        TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resourceSet("x"), (Object)roots);
    }

    public void testFindMultipleRoots() {
        Model model = this.model("x rdf:type ja:Object; y ja:reificationMode ja:Minimal");
        Set roots = AssemblerHelp.findAssemblerRoots((Model)model);
        TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resourceSet("y x"), (Object)roots);
    }

    public void testFindRootsWithSpecifiedType() {
        Model model = this.model("x rdf:type ja:Model; y rdf:type ja:Object");
        Set roots = AssemblerHelp.findAssemblerRoots((Model)model, (Resource)JA.Model);
        TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resourceSet("x"), (Object)roots);
    }

    public void testThrowsIfNoRoots() {
        try {
            AssemblerHelp.singleModelRoot((Model)this.model(""));
            TestAssemblerHelp.fail((String)"should trap if no roots");
        }
        catch (BadDescriptionNoRootException e) {
            TestAssemblerHelp.pass();
        }
    }

    public void testThrowsIfManyRoots() {
        try {
            AssemblerHelp.singleModelRoot((Model)this.model("a rdf:type ja:Model; b rdf:type ja:Model"));
            TestAssemblerHelp.fail((String)"should trap if many roots");
        }
        catch (BadDescriptionMultipleRootsException e) {
            TestAssemblerHelp.pass();
        }
    }

    public void testExtractsSingleRoot() {
        Resource it = AssemblerHelp.singleModelRoot((Model)this.model("a rdf:type ja:Model"));
        TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resource("a"), (Object)it);
    }

    public void testSpecificTypeFails() {
        try {
            this.testSpecificType("xxx", "x rdf:type ja:Model; x rdf:type ja:PrefixMapping");
            TestAssemblerHelp.fail((String)"should trap multiple types");
        }
        catch (AmbiguousSpecificTypeException e) {
            TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resource("x"), (Object)e.getRoot());
            TestAssemblerHelp.assertEquals((Object)this.resources(e.getRoot(), "ja:Model ja:PrefixMapping"), new HashSet(e.getTypes()));
        }
    }

    private Set resources(Resource root, String items) {
        List L = TestAssemblerHelp.listOfStrings(items);
        HashSet<Resource> result = new HashSet<Resource>();
        for (int i = 0; i < L.size(); ++i) {
            result.add(TestAssemblerHelp.resource(root.getModel(), (String)L.get(i)));
        }
        return result;
    }

    private void testSpecificType(String expected, String specification) {
        Resource root = this.resourceInModel(specification);
        Resource rooted = (Resource)root.inModel(AssemblerHelp.fullModel((Model)root.getModel()));
        Resource mst = AssemblerHelp.findSpecificType((Resource)rooted);
        TestAssemblerHelp.assertEquals((Object)TestAssemblerHelp.resource(root.getModel(), expected), (Object)mst);
    }

    public void testClassAssociation() {
        String className = "com.hp.hpl.jena.assembler.test.TestAssemblerHelp$Imp";
        AssemblerGroup group = AssemblerGroup.create();
        Model m = this.model("eh:Wossname ja:assembler '" + className + "'");
        TestAssemblerHelp.assertEquals((boolean)false, (boolean)impIsLoaded);
        AssemblerHelp.loadAssemblerClasses((AssemblerGroup)group, (Model)m);
        TestAssemblerHelp.assertEquals((boolean)true, (boolean)impIsLoaded);
        TestAssemblerHelp.assertEquals((boolean)true, (boolean)impIsConstructed);
        TestAssemblerHelp.assertEquals((String)className, (String)group.assemblerFor(TestAssemblerHelp.resource("eh:Wossname")).getClass().getName());
    }

    public void testClassResourceConstructor() {
        AssemblerGroup group = AssemblerGroup.create();
        Model m = this.model("eh:Wossname ja:assembler 'com.hp.hpl.jena.assembler.test.TestAssemblerHelp$Gremlin'");
        TestAssemblerHelp.assertEquals((boolean)false, (boolean)gremlinInvoked);
        AssemblerHelp.loadAssemblerClasses((AssemblerGroup)group, (Model)m);
        TestAssemblerHelp.assertEquals((boolean)true, (boolean)gremlinInvoked);
    }

    public static class Gremlin
    extends AssemblerBase {
        public Gremlin() {
            Assert.fail((String)"Gremlin no-argument constructor should not be called");
        }

        public Gremlin(Resource root) {
            Assert.assertEquals((Object)ModelTestBase.resource("eh:Wossname"), (Object)root);
            ModelTestBase.assertIsoModels(gremlinModel, root.getModel());
            gremlinInvoked = true;
        }

        public Object open(Assembler a, Resource root, Mode irrelevant) {
            return null;
        }
    }

    public static class Imp
    extends AssemblerBase {
        public Imp() {
            impIsConstructed = true;
        }

        public Object open(Assembler a, Resource root, Mode irrelevant) {
            return null;
        }

        static {
            impIsLoaded = true;
        }
    }
}

