/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser.generic;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.CachedXPathAPI;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.DateTimeDomain;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.EnumeratedDomain;
import org.ecoinformatics.datamanager.parser.NumericDomain;
import org.ecoinformatics.datamanager.parser.Party;
import org.ecoinformatics.datamanager.parser.StorageType;
import org.ecoinformatics.datamanager.parser.TextComplexDataFormat;
import org.ecoinformatics.datamanager.parser.TextDelimitedDataFormat;
import org.ecoinformatics.datamanager.parser.TextDomain;
import org.ecoinformatics.datamanager.parser.TextWidthFixedDataFormat;
import org.ecoinformatics.datamanager.parser.generic.DataPackageParserInterface;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericDataPackageParser
implements DataPackageParserInterface {
    private static boolean isDebugging;
    private static final String ID = "id";
    protected String packageIdPath = null;
    protected String pubDatePath = null;
    protected String tableEntityPath = null;
    protected String spatialRasterEntityPath = null;
    protected String spatialVectorEntityPath = null;
    protected String storedProcedureEntityPath = null;
    protected String viewEntityPath = null;
    protected String otherEntityPath = null;
    protected String accessPath = null;
    protected String datasetTitlePath = null;
    protected String datasetCreatorPath = null;
    protected String datasetAbstractPath = null;
    protected String entityAccessPath = null;
    private int numEntities = 0;
    private Entity entityObject = null;
    private int elementId = 0;
    private int numberOfComplexFormats = 0;
    private Hashtable<String, AttributeList> attributeListIdHash = new Hashtable();
    private DataPackage emlDataPackage = null;
    private final String DEFAULT_RECORD_DELIMITER = "\\r\\n";

    public GenericDataPackageParser() {
        this.initDefaultXPaths();
    }

    public GenericDataPackageParser(String packageIdPath) {
        this.initDefaultXPaths();
        this.packageIdPath = packageIdPath;
    }

    public GenericDataPackageParser(String packageIdPath, String pubDatePath, String tableEntityPath, String spatialRasterEntityPath, String spatialVectorEntityPath, String storedProcedureEntityPath, String viewEntityPath, String otherEntityPath) {
        this.initDefaultXPaths();
        if (packageIdPath != null) {
            this.packageIdPath = packageIdPath;
        }
        if (pubDatePath != null) {
            this.pubDatePath = pubDatePath;
        }
        if (tableEntityPath != null) {
            this.tableEntityPath = tableEntityPath;
        }
        if (spatialRasterEntityPath != null) {
            this.spatialRasterEntityPath = spatialRasterEntityPath;
        }
        if (spatialVectorEntityPath != null) {
            this.spatialVectorEntityPath = spatialVectorEntityPath;
        }
        if (storedProcedureEntityPath != null) {
            this.storedProcedureEntityPath = storedProcedureEntityPath;
        }
        if (viewEntityPath != null) {
            this.viewEntityPath = viewEntityPath;
        }
        if (otherEntityPath != null) {
            this.otherEntityPath = otherEntityPath;
        }
    }

    private void initDefaultXPaths() {
        this.packageIdPath = "//*/@packageId";
        this.pubDatePath = "//dataset/pubDate";
        this.tableEntityPath = "//dataset/dataTable";
        this.spatialRasterEntityPath = "//dataset/spatialRaster";
        this.spatialVectorEntityPath = "//dataset/spatialVector";
        this.storedProcedureEntityPath = "//dataset/storedProcedure";
        this.viewEntityPath = "//dataset/view";
        this.otherEntityPath = "//dataset/otherEntity";
        this.accessPath = "//access";
        this.datasetTitlePath = "//dataset/title";
        this.datasetCreatorPath = "//dataset/creator";
        this.datasetAbstractPath = "//dataset/abstract";
        this.entityAccessPath = "physical/distribution/access";
    }

    @Override
    public void parse(InputSource source) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(source);
        this.parseDocument(doc);
    }

    @Override
    public void parse(InputStream is) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(is);
        this.parseDocument(doc);
    }

    private void parseDocument(Document doc) throws Exception {
        NodeList viewEntities;
        NodeList otherEntities;
        NodeList spatialVectorEntities;
        NodeList spatialRasterEntities;
        NodeList dataTableEntities;
        CachedXPathAPI xpathapi = new CachedXPathAPI();
        String packageId = null;
        try {
            NodeList datasetCreatorNodeList;
            Node datasetTitleNode;
            Node packageIdNode = xpathapi.selectSingleNode((Node)doc, this.packageIdPath);
            if (packageIdNode != null) {
                packageId = packageIdNode.getNodeValue();
            }
            this.emlDataPackage = new DataPackage(packageId);
            String emlNamespace = this.parseEmlNamespace(doc);
            if (this.emlDataPackage != null) {
                this.emlDataPackage.setEmlNamespace(emlNamespace);
            }
            this.emlDataPackage.checkSchemaValid(doc, emlNamespace);
            this.emlDataPackage.checkParserValid(doc);
            this.emlDataPackage.checkSchemaValidDereferenced(doc, emlNamespace);
            String systemValue = this.parseSystemAttribute(doc);
            if (systemValue != null) {
                this.emlDataPackage.setSystem(systemValue);
            }
            int nKeywordElements = this.countElements(xpathapi, doc, "keyword");
            this.emlDataPackage.setNumberOfKeywordElements(nKeywordElements);
            int nMethodsElements = this.countElements(xpathapi, doc, "methods");
            this.emlDataPackage.setNumberOfMethodsElements(nMethodsElements);
            int nCoverageElements = this.countElements(xpathapi, doc, "coverage");
            this.emlDataPackage.setNumberOfCoverageElements(nCoverageElements);
            int nGeographicCoverageElements = this.countElements(xpathapi, doc, "geographicCoverage");
            this.emlDataPackage.setNumberOfGeographicCoverageElements(nGeographicCoverageElements);
            int nTaxonomicCoverageElements = this.countElements(xpathapi, doc, "taxonomicCoverage");
            this.emlDataPackage.setNumberOfTaxonomicCoverageElements(nTaxonomicCoverageElements);
            int nTemporalCoverageElements = this.countElements(xpathapi, doc, "temporalCoverage");
            this.emlDataPackage.setNumberOfTemporalCoverageElements(nTemporalCoverageElements);
            dataTableEntities = xpathapi.selectNodeList((Node)doc, this.tableEntityPath);
            spatialRasterEntities = xpathapi.selectNodeList((Node)doc, this.spatialRasterEntityPath);
            spatialVectorEntities = xpathapi.selectNodeList((Node)doc, this.spatialVectorEntityPath);
            otherEntities = xpathapi.selectNodeList((Node)doc, this.otherEntityPath);
            viewEntities = xpathapi.selectNodeList((Node)doc, this.viewEntityPath);
            Node accessNode = xpathapi.selectSingleNode((Node)doc, this.accessPath);
            if (accessNode != null) {
                String accessXML = this.nodeToXmlString(accessNode);
                this.emlDataPackage.setAccessXML(accessXML);
            }
            if ((datasetTitleNode = xpathapi.selectSingleNode((Node)doc, this.datasetTitlePath)) != null) {
                String titleText = datasetTitleNode.getTextContent();
                this.emlDataPackage.setTitle(titleText);
            }
            if ((datasetCreatorNodeList = xpathapi.selectNodeList((Node)doc, this.datasetCreatorPath)) != null) {
                for (int i = 0; i < datasetCreatorNodeList.getLength(); ++i) {
                    Node orgNode;
                    Node givenNameNode;
                    Node datasetCreatorNode = datasetCreatorNodeList.item(i);
                    String surName = null;
                    ArrayList<String> givenNames = null;
                    String organization = null;
                    Node surNameNode = xpathapi.selectSingleNode(datasetCreatorNode, "individualName/surName");
                    if (surNameNode != null) {
                        surName = surNameNode.getTextContent();
                    }
                    if ((givenNameNode = xpathapi.selectSingleNode(datasetCreatorNode, "individualName/givenName")) != null) {
                        if (givenNames == null) {
                            givenNames = new ArrayList<String>();
                        }
                        givenNames.add(givenNameNode.getTextContent());
                    }
                    if ((orgNode = xpathapi.selectSingleNode(datasetCreatorNode, "organizationName")) != null) {
                        organization = orgNode.getTextContent();
                    }
                    Party party = new Party(surName, givenNames, organization);
                    this.emlDataPackage.getCreators().add(party);
                }
            }
            String pubDate = null;
            Node pubDateNode = xpathapi.selectSingleNode((Node)doc, this.pubDatePath);
            if (pubDateNode != null) {
                pubDate = pubDateNode.getTextContent().trim();
            }
            this.emlDataPackage.setPubDate(pubDate);
            NodeList datasetAbstractNodeList = xpathapi.selectNodeList((Node)doc, this.datasetAbstractPath);
            this.parseDatasetAbstract(datasetAbstractNodeList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error extracting entities from eml2.0.0 package.", e);
        }
        try {
            this.processEntities(xpathapi, dataTableEntities, this.tableEntityPath, packageId);
            this.processEntities(xpathapi, spatialRasterEntities, this.spatialRasterEntityPath, packageId);
            this.processEntities(xpathapi, spatialVectorEntities, this.spatialVectorEntityPath, packageId);
            this.processEntities(xpathapi, otherEntities, this.otherEntityPath, packageId);
            this.processEntities(xpathapi, viewEntities, this.viewEntityPath, packageId);
        }
        catch (Exception e) {
            throw new Exception("Error processing entities: " + e.getMessage(), e);
        }
    }

    @Override
    public DataPackage getDataPackage() {
        return this.emlDataPackage;
    }

    private String parseEmlNamespace(Document doc) {
        NodeList docNodes;
        String namespaceURI = null;
        if (doc != null && (docNodes = doc.getChildNodes()) != null) {
            int len = docNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node docNode = docNodes.item(i);
                String name = docNode.getNodeName();
                if (name == null || !name.equals("eml:eml")) continue;
                NamedNodeMap attributeMap = docNode.getAttributes();
                int mapLength = attributeMap.getLength();
                for (int m = 0; m < mapLength; ++m) {
                    Node attNode = attributeMap.item(m);
                    String attNodeName = attNode.getNodeName();
                    String attNodeValue = attNode.getNodeValue();
                    if (!attNodeName.equals("xmlns:eml")) continue;
                    namespaceURI = attNodeValue;
                }
            }
        }
        return namespaceURI;
    }

    private int countElements(CachedXPathAPI xpathapi, Document doc, String elementName) {
        int nMethodsElements = 0;
        String xPath = "//" + elementName;
        try {
            NodeList methodsList = xpathapi.selectNodeList((Node)doc, xPath);
            nMethodsElements = methodsList.getLength();
        }
        catch (TransformerException e) {
            System.err.println("TransformerException while detecting 'methods' element: " + e.getMessage());
        }
        return nMethodsElements;
    }

    private String parseSystemAttribute(Document doc) {
        NodeList docNodes;
        String systemValue = null;
        if (doc != null && (docNodes = doc.getChildNodes()) != null) {
            int len = docNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node docNode = docNodes.item(i);
                String name = docNode.getNodeName();
                if (name == null || !name.equals("eml:eml")) continue;
                NamedNodeMap attributeMap = docNode.getAttributes();
                int mapLength = attributeMap.getLength();
                for (int m = 0; m < mapLength; ++m) {
                    Node attNode = attributeMap.item(m);
                    String attNodeName = attNode.getNodeName();
                    String attNodeValue = attNode.getNodeValue();
                    if (!attNodeName.equals("system")) continue;
                    systemValue = attNodeValue;
                }
            }
        }
        return systemValue;
    }

    private void processAttributeList(CachedXPathAPI xpathapi, NodeList attributeListNodeList, String xpath, Entity entObj) throws Exception {
        int numberOfAttributes;
        Node idNode;
        AttributeList attributeList = new AttributeList();
        Node attributeListNode = attributeListNodeList.item(0);
        if (attributeListNode == null) {
            if (xpath != null && xpath.equals(this.otherEntityPath)) {
                System.err.println("No attributeList was specified for otherEntity '" + entObj.getName() + "'. This is allowable in EML.");
                return;
            }
            throw new Exception("No attributeList was specified for entity '" + entObj.getName() + "'.");
        }
        NamedNodeMap attributeListNodeAttributes = attributeListNode.getAttributes();
        String idString = null;
        if (attributeListNodeAttributes != null && (idNode = attributeListNodeAttributes.getNamedItem(ID)) != null) {
            idString = idNode.getNodeValue();
            attributeList.setId(idString);
            if (isDebugging) {
                // empty if block
            }
        }
        NodeList attributeNodeList = xpathapi.selectNodeList(attributeListNode, "attribute");
        NodeList referencesNodeList = xpathapi.selectNodeList(attributeListNode, "references");
        if (attributeNodeList != null && attributeNodeList.getLength() > 0) {
            this.processAttributes(xpathapi, attributeNodeList, attributeList);
            if (idString != null) {
                this.attributeListIdHash.put(idString, attributeList);
            }
        } else if (referencesNodeList != null && referencesNodeList.getLength() > 0) {
            Node referencesNode = referencesNodeList.item(0);
            if (isDebugging) {
                // empty if block
            }
            String referencesId = referencesNode.getFirstChild().getNodeValue();
            if (isDebugging) {
                // empty if block
            }
            attributeList = this.attributeListIdHash.get(referencesId);
        } else {
            throw new Exception(" couldn't be a child of attributeList");
        }
        if (!this.entityObject.isSimpleDelimited() && ((numberOfAttributes = attributeList.getAttributes().length) != this.numberOfComplexFormats || numberOfAttributes == this.numberOfComplexFormats && this.numberOfComplexFormats == 0)) {
            throw new Exception("Complex format elements should have same number as attribute number");
        }
        this.entityObject.setAttributeList(attributeList);
    }

    private void processAttributes(CachedXPathAPI xpathapi, NodeList attributesNodeList, AttributeList attributeList) throws Exception {
        int attributesNodeListLength = attributesNodeList.getLength();
        for (int i = 0; i < attributesNodeListLength; ++i) {
            Node idNode;
            Node attributeNode = attributesNodeList.item(i);
            NodeList attributeNodeChildren = attributeNode.getChildNodes();
            String attName = "";
            String attLabel = "";
            String attDefinition = "";
            String attUnit = "";
            String attUnitType = "";
            String attMeasurementScale = "";
            String attPrecision = "";
            Domain domain = null;
            String id = null;
            Vector<String> missingValueCodeVector = new Vector<String>();
            double numberPrecision = 0.0;
            ArrayList<StorageType> storageTypeArray = new ArrayList<StorageType>();
            NamedNodeMap attributeNodeAttributesMap = attributeNode.getAttributes();
            if (attributeNodeAttributesMap != null && (idNode = attributeNodeAttributesMap.getNamedItem(ID)) != null) {
                id = idNode.getNodeValue();
            }
            ++this.elementId;
            for (int j = 0; j < attributeNodeChildren.getLength(); ++j) {
                Node childNode = attributeNodeChildren.item(j);
                String childNodeName = childNode.getNodeName();
                String childNodeValue = childNode.getFirstChild() == null ? null : childNode.getFirstChild().getNodeValue();
                String string = childNodeValue = childNodeValue == null ? childNodeValue : childNodeValue.trim();
                if (childNodeName.equals("attributeName")) {
                    if (childNodeValue == null) continue;
                    attName = childNodeValue.replace('.', '_');
                    continue;
                }
                if (childNodeName.equals("attributeLabel")) {
                    attLabel = childNodeValue;
                    continue;
                }
                if (childNodeName.equals("attributeDefinition")) {
                    attDefinition = childNodeValue;
                    continue;
                }
                if (childNodeName.equals("storageType")) {
                    String storageTypeTextValue = childNodeValue;
                    NamedNodeMap storageTypeAttributesMap = childNode.getAttributes();
                    String typeSystem = "";
                    Node typeSystemNode = null;
                    if (storageTypeAttributesMap != null && (typeSystemNode = storageTypeAttributesMap.getNamedItem(typeSystem)) != null) {
                        typeSystem = typeSystemNode.getNodeValue();
                    }
                    StorageType storageType = !typeSystem.equals("") ? new StorageType(storageTypeTextValue, typeSystem) : new StorageType(storageTypeTextValue);
                    storageTypeArray.add(storageType);
                    continue;
                }
                if (childNodeName.equals("measurementScale")) {
                    NodeList measurementScaleChildNodes = childNode.getChildNodes();
                    for (int k = 0; k < measurementScaleChildNodes.getLength(); ++k) {
                        Node measurementScaleChildNode = measurementScaleChildNodes.item(k);
                        String measurementScaleChildNodeName = measurementScaleChildNode.getNodeName();
                        if (measurementScaleChildNodeName.equals("interval") || measurementScaleChildNodeName.equals("ratio")) {
                            String numberType = null;
                            String min = "";
                            String max = "";
                            Node standardUnitNode = xpathapi.selectSingleNode(measurementScaleChildNode, "unit/standardUnit");
                            Node customUnitNode = xpathapi.selectSingleNode(measurementScaleChildNode, "unit/customUnit");
                            if (standardUnitNode != null) {
                                attUnit = standardUnitNode.getFirstChild().getNodeValue();
                                attUnitType = Attribute.STANDARDUNIT;
                            } else if (customUnitNode != null) {
                                attUnit = customUnitNode.getFirstChild().getNodeValue();
                                attUnitType = Attribute.CUSTOMUNIT;
                            } else {
                                System.err.println("Unable to determine attribute unit.");
                            }
                            Node precisionNode = xpathapi.selectSingleNode(measurementScaleChildNode, "precision");
                            if (precisionNode != null) {
                                attPrecision = precisionNode.getFirstChild().getNodeValue();
                                numberPrecision = new Double(attPrecision);
                            }
                            Node numericDomainNode = xpathapi.selectSingleNode(measurementScaleChildNode, "numericDomain");
                            NodeList numericDomainChildNodes = numericDomainNode.getChildNodes();
                            for (int index = 0; index < numericDomainChildNodes.getLength(); ++index) {
                                String numericDomainChildNodeName = numericDomainChildNodes.item(index).getNodeName();
                                if (numericDomainChildNodeName.equals("numberType")) {
                                    numberType = numericDomainChildNodes.item(index).getFirstChild().getNodeValue();
                                    if (!isDebugging) continue;
                                    continue;
                                }
                                if (!numericDomainChildNodeName.equals("boundsGroup")) continue;
                                NodeList boundsNodeList = xpathapi.selectNodeList(numericDomainNode, "./bounds");
                                for (i = 0; i < boundsNodeList.getLength(); ++i) {
                                    try {
                                        NodeList aNodeList = xpathapi.selectNodeList(boundsNodeList.item(i), "./minimum");
                                        Node boundsNode = aNodeList.item(0);
                                        min = boundsNode.getFirstChild().getNodeValue();
                                        aNodeList = xpathapi.selectNodeList(boundsNodeList.item(0), "./maximum");
                                        boundsNode = aNodeList.item(0);
                                        max = boundsNode.getFirstChild().getNodeValue();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            Double minNum = null;
                            Double maxNum = null;
                            if (!min.trim().equals("")) {
                                minNum = new Double(min);
                            }
                            if (!max.trim().equals("")) {
                                maxNum = new Double(max);
                            }
                            NumericDomain numericDomain = new NumericDomain(numberType, minNum, maxNum);
                            numericDomain.setPrecision(numberPrecision);
                            domain = numericDomain;
                            continue;
                        }
                        if (measurementScaleChildNodeName.equals("nominal") || measurementScaleChildNodeName.equals("ordinal")) {
                            NodeList nonNumericDomainChildNodes = xpathapi.selectSingleNode(measurementScaleChildNode, "nonNumericDomain").getChildNodes();
                            for (int m = 0; m < nonNumericDomainChildNodes.getLength(); ++m) {
                                Node nonNumericDomainChildNode = nonNumericDomainChildNodes.item(m);
                                String nonNumericDomainChildNodeName = nonNumericDomainChildNode.getNodeName();
                                if (nonNumericDomainChildNodeName.equals("textDomain")) {
                                    TextDomain textDomain = new TextDomain();
                                    NodeList definitionNodeList = xpathapi.selectNodeList(nonNumericDomainChildNode, "./definition");
                                    Node defintionNode = definitionNodeList.item(0);
                                    String definition = null;
                                    if (defintionNode != null) {
                                        definition = defintionNode.getFirstChild() == null ? null : defintionNode.getFirstChild().getNodeValue();
                                    }
                                    textDomain.setDefinition(definition);
                                    NodeList patternNodeList = xpathapi.selectNodeList(nonNumericDomainChildNode, "./pattern");
                                    String[] patternList = new String[patternNodeList.getLength()];
                                    for (int l = 0; l < patternNodeList.getLength(); ++l) {
                                        patternList[l] = patternNodeList.item(l).getFirstChild().getNodeValue();
                                    }
                                    if (patternList.length > 0) {
                                        textDomain.setPattern(patternList);
                                    }
                                    domain = textDomain;
                                    continue;
                                }
                                if (!nonNumericDomainChildNodeName.equals("enumeratedDomain")) continue;
                                EnumeratedDomain enumeratedDomain = new EnumeratedDomain();
                                Vector<String> info = new Vector<String>();
                                NodeList codeDefinitionNodeList = xpathapi.selectNodeList(nonNumericDomainChildNode, "./codeDefinition");
                                for (int l = 0; l < codeDefinitionNodeList.getLength(); ++l) {
                                    info.add(codeDefinitionNodeList.item(l).getFirstChild().getNodeValue());
                                }
                                enumeratedDomain.setInfo(info);
                                domain = enumeratedDomain;
                            }
                            continue;
                        }
                        if (!measurementScaleChildNodeName.equalsIgnoreCase("datetime")) continue;
                        DateTimeDomain date = new DateTimeDomain();
                        String formatString = xpathapi.selectSingleNode(measurementScaleChildNode, "./formatString").getFirstChild().getNodeValue();
                        if (isDebugging) {
                            // empty if block
                        }
                        date.setFormatString(formatString);
                        domain = date;
                    }
                    continue;
                }
                if (!childNodeName.equals("missingValueCode")) continue;
                NodeList missingValueCodeChildNodes = childNode.getChildNodes();
                for (int k = 0; k < missingValueCodeChildNodes.getLength(); ++k) {
                    Node missingValueCodeTextNode;
                    Node missingValueCodeChildNode = missingValueCodeChildNodes.item(k);
                    String missingValueCodeChildNodeName = missingValueCodeChildNode.getNodeName();
                    if (!missingValueCodeChildNodeName.equals("code") || (missingValueCodeTextNode = missingValueCodeChildNode.getFirstChild()) == null) continue;
                    String missingValueCode = missingValueCodeTextNode.getNodeValue();
                    if (isDebugging) {
                        // empty if block
                    }
                    missingValueCodeVector.add(missingValueCode);
                }
            }
            Attribute attObj = new Attribute(id, attName, attLabel, attDefinition, attUnit, attUnitType, attMeasurementScale, domain);
            for (StorageType storageType : storageTypeArray) {
                attObj.addStorageType(storageType);
            }
            for (int k = 0; k < missingValueCodeVector.size(); ++k) {
                String missingValueCode = (String)missingValueCodeVector.elementAt(k);
                if (isDebugging) {
                    // empty if block
                }
                attObj.addMissingValueCode(missingValueCode);
            }
            attributeList.add(attObj);
        }
    }

    private void processEntities(CachedXPathAPI xpathapi, NodeList entitiesNodeList, String xpath, String packageId) throws SAXException, TransformerException, Exception {
        if (entitiesNodeList == null) {
            return;
        }
        int entityNodeListLength = entitiesNodeList.getLength();
        this.numEntities += entityNodeListLength;
        for (int i = 0; i < entityNodeListLength; ++i) {
            NodeList encodingMethodNodeList;
            NodeList formatNodeList;
            NodeList urlNodeList;
            Node entityAccessNode;
            Node firstChild;
            Node firstNode;
            NodeList recordDelimiterNodeList;
            NodeList complexNodeList;
            NodeList literalCharacterNodeList;
            NodeList quoteCharacterNodeList;
            String collapseDelimiters;
            Node firstChild2;
            Node firstNode2;
            NodeList collapseDelimitersNodeList;
            Node firstChild3;
            Node fieldDelimiterNode;
            NodeList fieldDelimiterNodeList;
            Node numFooterLinesNode;
            NodeList numFooterLinesNodeList;
            Node numHeaderLinesNode;
            NodeList numHeaderLinesNodeList;
            Node idNode;
            String entityAccessXML = null;
            String entityName = "";
            String entityDescription = "";
            String entityOrientation = "";
            String entityCaseSensitive = "";
            String onlineUrl = "";
            String onlineUrlFunction = null;
            String format = null;
            Integer numHeaderLines = null;
            Integer numFooterLines = null;
            String fieldDelimiter = null;
            String recordDelimiter = "\\r\\n";
            String metadataRecordDelimiter = null;
            String compressionMethod = "";
            String encodingMethod = "";
            String quoteCharacter = null;
            String literalCharacter = null;
            TextComplexDataFormat[] formatArray = null;
            String entityNumberOfRecords = "-1";
            boolean hasDistributionOnline = false;
            boolean hasDistributionOffline = false;
            boolean hasDistributionInline = false;
            boolean isExternallyDefinedFormat = false;
            boolean isOtherEntity = false;
            boolean isImageEntity = false;
            boolean isGZipDataFile = false;
            boolean isZipDataFile = false;
            boolean isTarDataFile = false;
            boolean isSimpleDelimited = true;
            boolean isTextFixed = false;
            boolean isCollapseDelimiters = false;
            if (xpath != null) {
                if (xpath.equals(this.spatialRasterEntityPath) || xpath.equals(this.spatialVectorEntityPath)) {
                    isImageEntity = true;
                } else if (xpath.equals(this.otherEntityPath)) {
                    isOtherEntity = true;
                }
            }
            ++this.elementId;
            Node entityNode = entitiesNodeList.item(i);
            String id = null;
            NamedNodeMap entityNodeAttributes = entityNode.getAttributes();
            if (entityNodeAttributes != null && (idNode = entityNodeAttributes.getNamedItem(ID)) != null) {
                id = idNode.getNodeValue();
            }
            NodeList entityNodeChildren = entityNode.getChildNodes();
            for (int j = 0; j < entityNodeChildren.getLength(); ++j) {
                String childValue;
                Node childNode = entityNodeChildren.item(j);
                String childName = childNode.getNodeName();
                String string = childValue = childNode.getFirstChild() == null ? null : childNode.getFirstChild().getNodeValue();
                if (childName.equals("entityName")) {
                    entityName = childValue;
                    continue;
                }
                if (childName.equals("entityDescription")) {
                    entityDescription = childValue;
                    continue;
                }
                if (childName.equals("caseSensitive")) {
                    entityCaseSensitive = childValue;
                    continue;
                }
                if (!childName.equals("numberOfRecords")) continue;
                entityNumberOfRecords = childValue;
            }
            NodeList attributeOrientationNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/attributeOrientation");
            if (attributeOrientationNodeList != null && attributeOrientationNodeList.getLength() > 0) {
                entityOrientation = attributeOrientationNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((numHeaderLinesNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/numHeaderLines")) != null && numHeaderLinesNodeList.getLength() > 0 && (numHeaderLinesNode = numHeaderLinesNodeList.item(0)) != null) {
                String numHeaderLinesStr = numHeaderLinesNode.getFirstChild().getNodeValue();
                numHeaderLines = new Integer(numHeaderLinesStr.trim());
            }
            if ((numFooterLinesNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/numFooterLines")) != null && numFooterLinesNodeList.getLength() > 0 && (numFooterLinesNode = numFooterLinesNodeList.item(0)) != null) {
                String numFooterLinesStr = numFooterLinesNode.getFirstChild().getNodeValue();
                numFooterLines = new Integer(numFooterLinesStr.trim());
            }
            if ((fieldDelimiterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter")) != null && fieldDelimiterNodeList.getLength() > 0 && (fieldDelimiterNode = fieldDelimiterNodeList.item(0)) != null && (firstChild3 = fieldDelimiterNode.getFirstChild()) != null) {
                fieldDelimiter = firstChild3.getNodeValue();
            }
            if ((collapseDelimitersNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/collapseDelimiters")) != null && collapseDelimitersNodeList.getLength() > 0 && (firstNode2 = collapseDelimitersNodeList.item(0)) != null && (firstChild2 = firstNode2.getFirstChild()) != null && (collapseDelimiters = firstChild2.getNodeValue()) != null && collapseDelimiters.equalsIgnoreCase("yes")) {
                isCollapseDelimiters = true;
            }
            if ((quoteCharacterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/quoteCharacter")) != null && quoteCharacterNodeList.getLength() > 0) {
                quoteCharacter = quoteCharacterNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((literalCharacterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/literalCharacter")) != null && literalCharacterNodeList.getLength() > 0) {
                literalCharacter = literalCharacterNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((complexNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/complex")) != null && complexNodeList.getLength() > 0) {
                isSimpleDelimited = false;
                Node complexNode = complexNodeList.item(0);
                NodeList complexChildNodes = complexNode.getChildNodes();
                int complexChildNodesLength = complexChildNodes.getLength();
                Vector<TextComplexDataFormat> formatVector = new Vector<TextComplexDataFormat>();
                for (int k = 0; k < complexChildNodesLength; ++k) {
                    TextDelimitedDataFormat textDelimitedDataFormat;
                    Node complexChildNode = complexChildNodes.item(k);
                    if (complexChildNode != null && complexChildNode.getNodeName().equals("textFixed")) {
                        TextWidthFixedDataFormat textWidthFixedDataFormat = this.handleTextFixedDataFormatNode(complexChildNode);
                        if (textWidthFixedDataFormat == null) continue;
                        formatVector.add(textWidthFixedDataFormat);
                        isTextFixed = true;
                        continue;
                    }
                    if (complexChildNode == null || !complexChildNode.getNodeName().equals("textDelimited") || (textDelimitedDataFormat = this.handleComplexDelimitedDataFormatNode(complexChildNode)) == null) continue;
                    formatVector.add(textDelimitedDataFormat);
                }
                this.numberOfComplexFormats = formatVector.size();
                formatArray = new TextComplexDataFormat[this.numberOfComplexFormats];
                for (int j = 0; j < this.numberOfComplexFormats; ++j) {
                    formatArray[j] = (TextComplexDataFormat)formatVector.elementAt(j);
                }
            }
            if ((recordDelimiterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/recordDelimiter")) != null && recordDelimiterNodeList.getLength() > 0 && (firstNode = recordDelimiterNodeList.item(0)) != null && (firstChild = firstNode.getFirstChild()) != null) {
                recordDelimiter = metadataRecordDelimiter = firstChild.getNodeValue();
            }
            if ((entityAccessNode = xpathapi.selectSingleNode(entityNode, this.entityAccessPath)) != null) {
                entityAccessXML = this.nodeToXmlString(entityAccessNode);
            }
            NodeList onlineNodeList = xpathapi.selectNodeList(entityNode, "physical/distribution/online");
            NodeList offlineNodeList = xpathapi.selectNodeList(entityNode, "physical/distribution/offline");
            NodeList inlineNodeList = xpathapi.selectNodeList(entityNode, "physical/distribution/inline");
            if (onlineNodeList != null && onlineNodeList.getLength() > 0) {
                hasDistributionOnline = true;
            }
            if (offlineNodeList != null && offlineNodeList.getLength() > 0) {
                hasDistributionOffline = true;
            }
            if (inlineNodeList != null && inlineNodeList.getLength() > 0) {
                hasDistributionInline = true;
            }
            if ((urlNodeList = xpathapi.selectNodeList(entityNode, "physical/distribution/online/url")) != null && urlNodeList.getLength() > 0) {
                int len = urlNodeList.getLength();
                for (int j = 0; j < len; ++j) {
                    Node urlNode = urlNodeList.item(j);
                    String urlText = urlNode.getTextContent();
                    String functionText = null;
                    NamedNodeMap urlAttributes = urlNode.getAttributes();
                    int nAttributes = urlAttributes.getLength();
                    for (int k = 0; k < nAttributes; ++k) {
                        Node attributeNode = urlAttributes.item(k);
                        String nodeName = attributeNode.getNodeName();
                        if (!nodeName.equals("function")) continue;
                        functionText = attributeNode.getNodeValue();
                    }
                    if (functionText != null && functionText.equalsIgnoreCase("information")) continue;
                    onlineUrl = urlText;
                    onlineUrlFunction = functionText;
                    break;
                }
            }
            if ((formatNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/externallyDefinedFormat/formatName")) != null && formatNodeList.getLength() > 0) {
                format = formatNodeList.item(0).getFirstChild().getNodeValue();
                isExternallyDefinedFormat = true;
            } else {
                formatNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/binaryRasterFormat");
                if (formatNodeList != null && formatNodeList.getLength() > 0) {
                    format = "application/octet-stream";
                } else {
                    formatNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat");
                    if (formatNodeList != null && formatNodeList.getLength() > 0) {
                        format = "text/plain";
                    }
                    if (isSimpleDelimited) {
                        format = "text/csv";
                    }
                }
            }
            NodeList compressionMethodNodeList = xpathapi.selectNodeList(entityNode, "physical/compressionMethod");
            if (compressionMethodNodeList != null && compressionMethodNodeList.getLength() > 0) {
                compressionMethod = compressionMethodNodeList.item(0).getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
                if (compressionMethod != null && compressionMethod.equals(Entity.GZIP)) {
                    isGZipDataFile = true;
                } else if (compressionMethod != null && compressionMethod.equals(Entity.ZIP)) {
                    isZipDataFile = true;
                }
            }
            if ((encodingMethodNodeList = xpathapi.selectNodeList(entityNode, "physical/encodingMethod")) != null && encodingMethodNodeList.getLength() > 0) {
                encodingMethod = encodingMethodNodeList.item(0).getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
                if (encodingMethod != null && encodingMethod.equals(Entity.TAR)) {
                    isTarDataFile = true;
                }
            }
            entityOrientation = entityOrientation.trim().equals("column") ? Entity.COLUMNMAJOR : Entity.ROWMAJOR;
            entityCaseSensitive = entityCaseSensitive.equals("yes") ? "true" : "false";
            System.err.println(String.format("Package ID: %s  Entity: %s", packageId, entityName));
            this.entityObject = new Entity(id, entityName == null ? null : entityName.trim(), entityDescription == null ? null : entityDescription.trim(), new Boolean(entityCaseSensitive), entityOrientation, new Integer(entityNumberOfRecords));
            this.entityObject.setExternallyDefinedFormat(isExternallyDefinedFormat);
            this.entityObject.setNumHeaderLines(numHeaderLines);
            this.entityObject.setNumFooterLines(numFooterLines);
            this.entityObject.setSimpleDelimited(isSimpleDelimited);
            this.entityObject.setTextFixed(isTextFixed);
            if (quoteCharacter != null) {
                this.entityObject.setQuoteCharacter(quoteCharacter);
            }
            if (literalCharacter != null) {
                this.entityObject.setLiteralCharacter(literalCharacter);
            }
            this.entityObject.setCollapseDelimiters(isCollapseDelimiters);
            this.entityObject.setRecordDelimiter(recordDelimiter);
            this.entityObject.setURL(onlineUrl);
            this.entityObject.setURLFunction(onlineUrlFunction);
            this.entityObject.setDataFormat(format);
            this.entityObject.setCompressionMethod(compressionMethod);
            this.entityObject.setIsImageEntity(isImageEntity);
            this.entityObject.setIsOtherEntity(isOtherEntity);
            this.entityObject.setHasGZipDataFile(isGZipDataFile);
            this.entityObject.setHasZipDataFile(isZipDataFile);
            this.entityObject.setHasTarDataFile(isTarDataFile);
            this.entityObject.setPackageId(packageId);
            this.entityObject.setHasDistributionOnline(hasDistributionOnline);
            this.entityObject.setHasDistributionOffline(hasDistributionOffline);
            this.entityObject.setHasDistributionInline(hasDistributionInline);
            this.entityObject.setEntityAccessXML(entityAccessXML);
            this.entityObject.setFieldDelimiter(fieldDelimiter);
            this.entityObject.setMetadataRecordDelimiter(metadataRecordDelimiter);
            try {
                NodeList attributeListNodeList = xpathapi.selectNodeList(entityNode, "attributeList");
                this.processAttributeList(xpathapi, attributeListNodeList, xpath, this.entityObject);
                this.entityObject.setDataFormatArray(formatArray);
            }
            catch (Exception e) {
                throw new Exception("Error parsing attributes: " + e.getMessage(), e);
            }
            this.emlDataPackage.add(this.entityObject);
        }
    }

    private TextWidthFixedDataFormat handleTextFixedDataFormatNode(Node node) throws Exception {
        TextWidthFixedDataFormat textWidthFixedDataFormat = null;
        if (node == null) {
            return textWidthFixedDataFormat;
        }
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            String elementName = childNode.getNodeName();
            if (elementName != null && elementName.equals("fieldWidth")) {
                String fieldWidthStr = childNode.getFirstChild().getNodeValue();
                int fieldWidth = new Integer(fieldWidthStr);
                if (isDebugging) {
                    // empty if block
                }
                textWidthFixedDataFormat = new TextWidthFixedDataFormat(fieldWidth);
                continue;
            }
            if (elementName != null && elementName.equals("fieldStartColumn") && textWidthFixedDataFormat != null) {
                String startColumnStr = childNode.getFirstChild().getNodeValue();
                int startColumn = new Integer(startColumnStr);
                if (isDebugging) {
                    // empty if block
                }
                textWidthFixedDataFormat.setFieldStartColumn(startColumn);
                continue;
            }
            if (elementName == null || !elementName.equals("lineNumber") || textWidthFixedDataFormat == null) continue;
            String lineNumberStr = childNode.getFirstChild().getNodeValue();
            int lineNumber = new Integer(lineNumberStr);
            if (isDebugging) {
                // empty if block
            }
            textWidthFixedDataFormat.setLineNumber(lineNumber);
        }
        return textWidthFixedDataFormat;
    }

    private TextDelimitedDataFormat handleComplexDelimitedDataFormatNode(Node node) throws Exception {
        TextDelimitedDataFormat textDelimitedDataFormat = null;
        if (node == null) {
            return textDelimitedDataFormat;
        }
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        Vector<String> quoteList = new Vector<String>();
        for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            String elementName = childNode.getNodeName();
            String fieldDelimiter = null;
            if (elementName != null && elementName.equals("fieldDelimiter")) {
                Node firstChild = childNode.getFirstChild();
                if (firstChild != null) {
                    fieldDelimiter = firstChild.getNodeValue();
                }
                textDelimitedDataFormat = new TextDelimitedDataFormat(fieldDelimiter);
                continue;
            }
            if (elementName != null && elementName.equals("lineNumber") && textDelimitedDataFormat != null) {
                String lineNumberStr = childNode.getFirstChild().getNodeValue();
                int lineNumber = new Integer(lineNumberStr);
                textDelimitedDataFormat.setLineNumber(lineNumber);
                continue;
            }
            if (elementName != null && elementName.equals("collapseDelimiters") && textDelimitedDataFormat != null) {
                String collapseDelimiters = childNode.getFirstChild().getNodeValue();
                textDelimitedDataFormat.setCollapseDelimiters(collapseDelimiters);
                continue;
            }
            if (elementName == null || !elementName.equals("quoteCharacter") || textDelimitedDataFormat == null) continue;
            String quoteCharacter = childNode.getFirstChild().getNodeValue();
            quoteList.add(quoteCharacter);
        }
        if (textDelimitedDataFormat != null) {
            int size = quoteList.size();
            String[] quoteCharacterArray = new String[size];
            for (int i = 0; i < size; ++i) {
                quoteCharacterArray[i] = (String)quoteList.elementAt(i);
            }
            textDelimitedDataFormat.setQuoteCharacterArray(quoteCharacterArray);
        }
        return textDelimitedDataFormat;
    }

    public String nodeToXmlString(Node node) {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(new StringWriter());
            t.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
    }

    private void parseDatasetAbstract(NodeList datasetAbstractNodeList) {
        if (datasetAbstractNodeList != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < datasetAbstractNodeList.getLength(); ++i) {
                Node paraNode = datasetAbstractNodeList.item(i);
                String paraText = paraNode.getTextContent();
                stringBuffer.append(" " + paraText);
            }
            String abstractText = stringBuffer.toString();
            this.emlDataPackage.setAbstract(abstractText);
            this.emlDataPackage.checkDatasetAbstract(abstractText);
        }
    }
}

