/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.impl.CompleterHelper;
import java.util.Arrays;

public class UpdatePayloadOxumCompleter
implements Completer {
    private CompleterHelper helper;
    private BagFactory bagFactory;

    public UpdatePayloadOxumCompleter(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
        this.helper = new CompleterHelper();
    }

    @Override
    public Bag complete(Bag bag) {
        Bag newBag = this.bagFactory.createBag(bag);
        newBag.putBagFiles(bag.getPayload());
        newBag.putBagFiles(bag.getTags());
        BagInfoTxt bagInfo = newBag.getBagInfoTxt();
        if (bagInfo != null) {
            if (bagInfo.getPayloadOxum() != null) {
                bagInfo.generatePayloadOxum(newBag);
            }
            for (Manifest manifest : newBag.getTagManifests()) {
                this.helper.regenerateManifest(newBag, manifest, true, Arrays.asList(newBag.getBagConstants().getBagInfoTxt()), null);
            }
        }
        return newBag;
    }
}

