/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.auth;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.dataone.client.auth.X509Session;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.util.TypeMarshaller;

public class CertificateManager
extends Observable {
    static Log log = LogFactory.getLog(CertificateManager.class);
    private String certificateLocation = null;
    private String certificateMD5Checksum = "";
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private String tlsVersion = null;
    private static final String shippedCAcerts = "/org/dataone/client/auth/d1-trusted-certs.crt";
    private KeyStore d1TrustStore;
    protected static String defaultTlsPreferences = "TLSv1.2, TLS";
    private static String CILOGON_OID_SUBJECT_INFO;
    private static CertificateManager cm;
    private Map<String, X509Certificate> certificates;
    private Map<String, PrivateKey> keys;
    private boolean trustStoreIncludesD1CAs = true;

    public CertificateManager() {
        try {
            this.keyStorePassword = Settings.getConfiguration().getString("certificate.keystore.password", "changeit");
            this.keyStoreType = Settings.getConfiguration().getString("certificate.keystore.type", KeyStore.getDefaultType());
            this.trustStoreIncludesD1CAs = Settings.getConfiguration().getBoolean("certificate.truststore.includeD1CAs", true);
            this.certificates = new HashMap<String, X509Certificate>();
            this.keys = new HashMap<String, PrivateKey>();
            CILOGON_OID_SUBJECT_INFO = Settings.getConfiguration().getString("cilogon.oid.subjectinfo", "1.3.6.1.4.1.34998.2.1");
            this.certificateMD5Checksum = this.getChecksum(this.getCertificateFile());
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("FileNotFound: " + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getChecksum(File file) throws IOException, NoSuchAlgorithmException {
        String checksumValue = "";
        FileInputStream currentCertFileInputStream = null;
        try {
            File currentCertFile = this.getCertificateFile();
            currentCertFileInputStream = new FileInputStream(currentCertFile);
            checksumValue = ChecksumUtil.checksum((InputStream)currentCertFileInputStream, (String)"MD5").getValue();
            if (currentCertFileInputStream == null) return checksumValue;
        }
        catch (FileNotFoundException e) {
            try {
                log.debug((Object)e.getMessage(), (Throwable)e);
                if (currentCertFileInputStream == null) return checksumValue;
            }
            catch (Throwable throwable) {
                if (currentCertFileInputStream == null) throw throwable;
                IOUtils.closeQuietly(currentCertFileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)currentCertFileInputStream);
            return checksumValue;
        }
        IOUtils.closeQuietly((InputStream)currentCertFileInputStream);
        return checksumValue;
    }

    public static CertificateManager getInstance() {
        return CertificateManagerSingleton.instance;
    }

    public String getCertificateLocation() {
        return this.certificateLocation;
    }

    public void setCertificateLocation(String certificateFilePath) {
        String oldLocation = this.certificateLocation;
        String oldChecksum = this.certificateMD5Checksum;
        this.certificateLocation = certificateFilePath;
        try {
            this.certificateMD5Checksum = this.getChecksum(this.getCertificateFile());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.certificateMD5Checksum = "";
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)oldChecksum);
        log.debug((Object)this.certificateMD5Checksum);
        if (!oldChecksum.equals(this.certificateMD5Checksum) || !Objects.equals(oldLocation, this.certificateLocation)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void registerDefaultCertificate() throws IOException {
        File certFile = this.getCertificateFile();
        X509Session session = this.getX509Session(certFile);
        String subjectDN = this.getSubjectDN(session.getCertificate());
        this.registerCertificate(subjectDN, session.getCertificate(), session.getPrivateKey());
    }

    public void registerCertificate(String subjectString, X509Certificate certificate, PrivateKey key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering certificate for: " + subjectString));
        }
        this.certificates.put(subjectString, certificate);
        this.keys.put(subjectString, key);
        if (log.isDebugEnabled()) {
            Set<String> labels = this.certificates.keySet();
            for (String label : labels) {
                log.debug((Object)String.format("   label:%s,  cert:%s, key:%s", label, this.certificates.get(label).getSubjectX500Principal(), this.keys.get(label)));
            }
        }
    }

    private KeyStore loadTrustStore() {
        if (this.d1TrustStore == null) {
            try {
                File loc;
                this.d1TrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.d1TrustStore.load(null, null);
                String auxLocation = Settings.getConfiguration().getString("certificate.truststore.aux.location");
                log.info((Object)("certificate.truststore.aux.location=" + auxLocation));
                int count = 0;
                if (auxLocation != null && (loc = new File(auxLocation)).exists()) {
                    if (loc.isDirectory()) {
                        for (File f : loc.listFiles()) {
                            count += this.loadIntoTrustStore(this.d1TrustStore, new FileReader(f.getAbsolutePath()));
                        }
                    } else {
                        count += this.loadIntoTrustStore(this.d1TrustStore, new FileReader(loc.getAbsolutePath()));
                    }
                }
                if (count == 0) {
                    log.info((Object)"shippedCAcerts=/org/dataone/client/auth/d1-trusted-certs.crt");
                    InputStream shippedCerts = this.getClass().getResourceAsStream(shippedCAcerts);
                    if (shippedCerts != null) {
                        count += this.loadIntoTrustStore(this.d1TrustStore, new InputStreamReader(shippedCerts));
                    } else {
                        log.error((Object)"'shippedCAcerts' file (/org/dataone/client/auth/d1-trusted-certs.crt) could not be found. No DataONE-trusted CA certs loaded");
                    }
                }
                if (log.isDebugEnabled()) {
                    Enumeration<String> aliases = this.d1TrustStore.aliases();
                    while (aliases.hasMoreElements()) {
                        log.debug((Object)("loadTrustStore: " + aliases.nextElement()));
                    }
                    log.debug((Object)("loadTrustStore: " + this.d1TrustStore.aliases()));
                }
            }
            catch (KeyStoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CertificateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.d1TrustStore;
    }

    /*
     * Exception decompiling
     */
    private int loadIntoTrustStore(KeyStore trustStore, Reader certLoc) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public X509Certificate getCACert(String caAlias) {
        X509Certificate caCert = null;
        KeyStore trustStore = this.loadTrustStore();
        try {
            caCert = (X509Certificate)trustStore.getCertificate(caAlias);
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return caCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X509Certificate> getSupplementalCACertificates() {
        ArrayList<X509Certificate> caCerts = null;
        InputStream caStream = null;
        try {
            KeyStore trustStore = this.loadTrustStore();
            Enumeration<String> aliases = trustStore.aliases();
            caCerts = new ArrayList<X509Certificate>();
            while (aliases.hasMoreElements()) {
                String caAlias = aliases.nextElement();
                X509Certificate caCert = (X509Certificate)trustStore.getCertificate(caAlias);
                caCerts.add(caCert);
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(caStream);
        }
        return caCerts;
    }

    public X509Certificate loadCertificate() {
        X509Certificate cert = null;
        try {
            KeyStore keyStore = this.getKeyStore((String)null);
            if (keyStore != null) {
                cert = (X509Certificate)keyStore.getCertificate("cilogon");
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)e.getMessage());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return cert;
    }

    public PrivateKey loadKey() {
        PrivateKey key = null;
        try {
            KeyStore keyStore = this.getKeyStore((String)null);
            key = (PrivateKey)keyStore.getKey("cilogon", this.keyStorePassword.toCharArray());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return key;
    }

    protected String getExtensionValue(X509Certificate X509Certificate2, String oid) throws IOException {
        DEROctetString derOctetString;
        ASN1Primitive derObject;
        String decoded = null;
        byte[] extensionValue = X509Certificate2.getExtensionValue(oid);
        if (extensionValue != null && (derObject = this.toDERObject(extensionValue)) instanceof DEROctetString && (derObject = this.toDERObject((derOctetString = (DEROctetString)derObject).getOctets())) instanceof DERUTF8String) {
            DERUTF8String s = DERUTF8String.getInstance((Object)derObject);
            decoded = s.getString();
        }
        return decoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASN1Primitive toDERObject(byte[] data) throws IOException {
        ASN1InputStream asnInputStream = null;
        ASN1Primitive dero = null;
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            asnInputStream = new ASN1InputStream((InputStream)inStream);
            dero = asnInputStream.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(asnInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)asnInputStream);
        return dero;
    }

    public SubjectInfo getSubjectInfo(X509Certificate certificate) throws IOException, InstantiationException, IllegalAccessException, MarshallingException {
        String subjectInfoValue = this.getExtensionValue(certificate, CILOGON_OID_SUBJECT_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Certificate subjectInfoValue: " + subjectInfoValue));
        }
        SubjectInfo subjectInfo = null;
        if (subjectInfoValue != null) {
            subjectInfo = (SubjectInfo)TypeMarshaller.unmarshalTypeFromStream(SubjectInfo.class, (InputStream)new ByteArrayInputStream(subjectInfoValue.getBytes("UTF-8")));
        }
        return subjectInfo;
    }

    public String getSubjectDN(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        X500Principal principal = certificate.getSubjectX500Principal();
        String dn = principal.getName("RFC2253");
        return dn;
    }

    public String standardizeDN(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("name: " + name));
        }
        X500Principal principal = new X500Principal(name);
        String standardizedName = principal.getName("RFC2253");
        if (log.isDebugEnabled()) {
            log.debug((Object)("standardizedName: " + standardizedName));
        }
        return standardizedName;
    }

    public boolean equalsDN(String dn1, String dn2) {
        return CertificateManager.getInstance().standardizeDN(dn1).equals(CertificateManager.getInstance().standardizeDN(dn2));
    }

    public static boolean verify(X509Certificate cert, X509Certificate caCert) {
        return CertificateManager.verify(cert, caCert, true);
    }

    public static boolean verify(X509Certificate cert, X509Certificate caCert, boolean logExceptions) {
        boolean isValid;
        block10: {
            isValid = false;
            try {
                cert.checkValidity();
                cert.verify(caCert.getPublicKey());
                isValid = true;
            }
            catch (CertificateException e) {
                if (logExceptions) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (InvalidKeyException e) {
                if (logExceptions) {
                    log.error((Object)"Certificate verification failed, invalid key.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchAlgorithmException e) {
                if (logExceptions) {
                    log.error((Object)"Certificate verification failed, no such algorithm.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (NoSuchProviderException e) {
                if (logExceptions) {
                    log.error((Object)"Certificate verification failed, no such provider.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SignatureException e) {
                if (!logExceptions) break block10;
                log.error((Object)"Certificate verification failed, signatures do not match.");
            }
        }
        return isValid;
    }

    public Session getSession(HttpServletRequest request) throws InvalidToken {
        Session session = null;
        X509Certificate x509Cert = this.getCertificate(request);
        if (x509Cert != null) {
            String subjectDN = this.getSubjectDN(x509Cert);
            Subject subject = new Subject();
            subject.setValue(subjectDN);
            session = new Session();
            session.setSubject(subject);
            SubjectInfo subjectInfo = null;
            try {
                subjectInfo = this.getSubjectInfo(x509Cert);
            }
            catch (Exception e) {
                String msg = "Could not get SubjectInfo from certificate for: " + subject.getValue();
                log.error((Object)msg, (Throwable)e);
                throw new InvalidToken("", msg);
            }
            if (subjectInfo == null) {
                subjectInfo = new SubjectInfo();
                Person person = new Person();
                person.setSubject(subject);
                person.setFamilyName("Unknown");
                person.addGivenName("Unknown");
                subjectInfo.addPerson(person);
            }
            session.setSubjectInfo(subjectInfo);
        }
        return session;
    }

    public X509Certificate getCertificate(HttpServletRequest request) {
        X509Certificate[] x509Certificates;
        X509Certificate[] x509CertificateArray;
        int n;
        int n2;
        Object certificate = request.getAttribute("javax.servlet.request.X509Certificate");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.request.X509Certificate  = " + certificate));
        }
        Object sslSession = request.getAttribute("javax.servlet.request.ssl_session");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.request.ssl_session  = " + sslSession));
        }
        if (certificate instanceof X509Certificate[] && (n2 = 0) < (n = (x509CertificateArray = (x509Certificates = (X509Certificate[])certificate)).length)) {
            X509Certificate x509Cert = x509CertificateArray[n2];
            this.displayCertificate(x509Cert);
            return x509Cert;
        }
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory(String subjectString) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, CertificateException, IOException {
        log.info((Object)"Entering getSSLSocketFactory");
        KeyStore keyStore = null;
        try {
            keyStore = this.getKeyStore(subjectString);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Client certificate could not be located. Setting up SocketFactory without it." + e.getMessage()));
        }
        return this.getSSLSocketFactory(keyStore);
    }

    public SSLSocketFactory getSSLSocketFactory(X509Session x509Session) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, CertificateException, IOException {
        return this.getSSLSocketFactory(this.getKeyStore(x509Session));
    }

    private SSLSocketFactory getSSLSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        SSLSocketFactory socketFactory = null;
        SSLContext ctx = this.buildSSLContext();
        X509TrustManager tm = this.getTrustManager();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keyStorePassword.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        ctx.init(keyManagers, new TrustManager[]{tm}, new SecureRandom());
        if (this.trustStoreIncludesD1CAs) {
            log.info((Object)"getSSLSocketFactory: using allow-all hostname verifier");
            socketFactory = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        } else {
            socketFactory = new SSLSocketFactory(ctx);
        }
        return socketFactory;
    }

    private SSLContext buildSSLContext() throws NoSuchAlgorithmException {
        String[] ctxPreferences;
        SSLContext ctx = null;
        String tlsPreferences = Settings.getConfiguration().getString("tls.protocol.preferences", defaultTlsPreferences);
        for (String preference : ctxPreferences = StringUtils.split((String)tlsPreferences, (char)',')) {
            try {
                log.info((Object)("...trying SSLContext protocol: " + preference));
                ctx = SSLContext.getInstance(StringUtils.trim((String)preference));
                log.info((Object)("...setting SSLContext with protocol: " + StringUtils.trim((String)preference)));
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        if (ctx == null) {
            throw new NoSuchAlgorithmException("None of the preferred TLS protocols were found! (" + tlsPreferences + ")");
        }
        return ctx;
    }

    public SSLConnectionSocketFactory getSSLConnectionSocketFactory(String subjectString) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, CertificateException, IOException {
        log.info((Object)"Entering getSSLConnectionSocketFactory");
        KeyStore keyStore = null;
        try {
            keyStore = this.getKeyStore(subjectString);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("Client certificate could not be located. Setting up SocketFactory without it." + e.getMessage()));
        }
        return this.getSSLConnectionSocketFactory(keyStore);
    }

    public SSLConnectionSocketFactory getSSLConnectionSocketFactory(X509Session x509Session) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, CertificateException, IOException {
        return this.getSSLConnectionSocketFactory(this.getKeyStore(x509Session));
    }

    private SSLConnectionSocketFactory getSSLConnectionSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLConnectionSocketFactory socketFactory = null;
        SSLContext ctx = this.buildSSLContext();
        X509TrustManager tm = this.getTrustManager();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keyStorePassword.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        ctx.init(keyManagers, new TrustManager[]{tm}, new SecureRandom());
        if (this.trustStoreIncludesD1CAs) {
            log.info((Object)"getSSLConnectionSocketFactory: using allow-all hostname verifier");
            socketFactory = new SSLConnectionSocketFactory(ctx, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        } else {
            socketFactory = new SSLConnectionSocketFactory(ctx);
        }
        return socketFactory;
    }

    private X509TrustManager getTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        X509TrustManager tm = null;
        X509TrustManager jvmTrustManager = null;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        log.debug((Object)"***** JVM Default Trust Managers ******");
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            log.debug((Object)trustManager);
            if (!(trustManager instanceof X509TrustManager)) continue;
            jvmTrustManager = (X509TrustManager)trustManager;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("Accepted issuers count : " + jvmTrustManager.getAcceptedIssuers().length));
            break;
        }
        if (this.trustStoreIncludesD1CAs) {
            log.info((Object)"creating custom TrustManager");
            final X509TrustManager defaultTrustManager = jvmTrustManager;
            tm = new X509TrustManager(){
                private List<X509Certificate> d1CaCertificates;
                {
                    this.d1CaCertificates = CertificateManager.this.getSupplementalCACertificates();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    boolean trusted = false;
                    List<X509Certificate> combinedIssuers = Arrays.asList(this.getAcceptedIssuers());
                    for (X509Certificate cert : chain) {
                        if (!combinedIssuers.contains(cert)) continue;
                        trusted = true;
                        break;
                    }
                    if (!trusted) {
                        defaultTrustManager.checkClientTrusted(chain, authType);
                    }
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    boolean trusted = false;
                    List<X509Certificate> combinedIssuers = Arrays.asList(this.getAcceptedIssuers());
                    block2: for (X509Certificate cert : chain) {
                        for (X509Certificate caCert : combinedIssuers) {
                            if (!CertificateManager.verify(cert, caCert, false)) continue;
                            trusted = true;
                            continue block2;
                        }
                    }
                    if (!trusted) {
                        try {
                            defaultTrustManager.checkServerTrusted(chain, authType);
                        }
                        catch (CertificateException ce) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"CertMan Custom TrustManager: server cert chain subjectDNs: ");
                                for (X509Certificate cert : chain) {
                                    log.trace((Object)("CertMan Custom TrustManager:   subjDN: " + cert.getSubjectDN() + " / issuerDN: " + cert.getIssuerX500Principal()));
                                }
                            }
                            throw ce;
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    ArrayList<X509Certificate> combinedIssuers = new ArrayList<X509Certificate>();
                    combinedIssuers.addAll(this.d1CaCertificates);
                    combinedIssuers.addAll(Arrays.asList(defaultTrustManager.getAcceptedIssuers()));
                    return combinedIssuers.toArray(new X509Certificate[0]);
                }
            };
        } else {
            log.info((Object)"using JVM TrustManager");
            tm = jvmTrustManager;
        }
        return tm;
    }

    public X509Session selectSession(String subjectString) throws IOException {
        X509Session x509Session = null;
        if (subjectString != null) {
            log.info((Object)("selectSession: looking up registered certificate for: " + subjectString));
            x509Session = X509Session.create(this.certificates.get(subjectString), this.keys.get(subjectString));
        } else {
            try {
                File certFile = this.getCertificateFile();
                x509Session = this.getX509Session(certFile);
            }
            catch (FileNotFoundException e) {
                log.info((Object)("Did not find a certificate for the subject specified: " + subjectString));
            }
        }
        return x509Session;
    }

    private File getCertificateFile() throws FileNotFoundException {
        File certFile = null;
        if (this.certificateLocation == null) {
            log.info((Object)"selectSession: using the default certificate location");
            certFile = this.locateDefaultCertificate();
            log.debug((Object)("selectSession: certificate location = " + certFile));
        } else {
            log.info((Object)("selectSession: Using client certificate location: " + this.certificateLocation));
            certFile = new File(this.certificateLocation);
            if (!certFile.exists()) {
                throw new FileNotFoundException("No certificate located in expected set location: " + this.certificateLocation);
            }
        }
        return certFile;
    }

    private KeyStore getKeyStore(String subjectString) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        X509Session s = this.selectSession(subjectString);
        return this.getKeyStore(s);
    }

    private KeyStore getKeyStore(X509Session x509Session) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (x509Session == null) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        keyStore.load(null, this.keyStorePassword.toCharArray());
        Certificate[] chain = new Certificate[]{x509Session.getCertificate()};
        if (log.isDebugEnabled()) {
            log.debug((Object)("getKeyStore: privateKey value: " + ObjectUtils.identityToString((Object)x509Session.getPrivateKey())));
        }
        keyStore.setKeyEntry("cilogon", x509Session.getPrivateKey(), this.keyStorePassword.toCharArray(), chain);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Session getX509Session(File pemFile) throws FileNotFoundException, IOException {
        PrivateKey privateKey = null;
        X509CertificateObject certificate = null;
        PEMParser pemReader = null;
        try {
            pemReader = new PEMParser((Reader)new FileReader(pemFile));
            Object pemObject = null;
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            while ((pemObject = pemReader.readObject()) != null) {
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo pki = (PrivateKeyInfo)pemObject;
                    privateKey = converter.getPrivateKey(pki);
                    continue;
                }
                if (pemObject instanceof PEMKeyPair) {
                    PEMKeyPair pkp = (PEMKeyPair)pemObject;
                    privateKey = converter.getPrivateKey(pkp.getPrivateKeyInfo());
                    continue;
                }
                if (!(pemObject instanceof X509CertificateHolder)) continue;
                X509CertificateHolder holder = (X509CertificateHolder)pemObject;
                try {
                    certificate = new X509CertificateObject(holder.toASN1Structure());
                }
                catch (CertificateParsingException e) {
                    log.warn((Object)"Could not parse x509 certificate", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pemReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)pemReader);
        return X509Session.create(certificate, privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey loadPrivateKeyFromFile(String fileName, String password) throws IOException {
        Object pemObject = null;
        PrivateKey privateKey = null;
        PEMParser pemReader = null;
        try {
            pemReader = new PEMParser((Reader)new FileReader(fileName));
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            while ((pemObject = pemReader.readObject()) != null) {
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo pki = (PrivateKeyInfo)pemObject;
                    privateKey = converter.getPrivateKey(pki);
                }
                if (pemObject instanceof PEMKeyPair) {
                    PEMKeyPair pkp = (PEMKeyPair)pemObject;
                    privateKey = converter.getPrivateKey(pkp.getPrivateKeyInfo());
                }
                if (!(pemObject instanceof PEMEncryptedKeyPair)) continue;
                log.debug((Object)"Encrypted key - we will use provided password");
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                KeyPair kp = converter.getKeyPair(((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decProv));
                privateKey = kp.getPrivate();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pemReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)pemReader);
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate loadCertificateFromFile(String fileName) throws IOException {
        X509CertificateObject certificate = null;
        PEMParser pemReader = null;
        try {
            pemReader = new PEMParser((Reader)new FileReader(fileName));
            Object pemObject = null;
            while ((pemObject = pemReader.readObject()) != null) {
                if (!(pemObject instanceof X509CertificateHolder)) continue;
                X509CertificateHolder holder = (X509CertificateHolder)pemObject;
                try {
                    certificate = new X509CertificateObject(holder.toASN1Structure());
                    break;
                }
                catch (CertificateParsingException e) {
                    log.warn((Object)"could not parse certificate", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pemReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)pemReader);
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File locateDefaultCertificate() throws FileNotFoundException {
        File fileLocation;
        StringBuffer location = new StringBuffer();
        String tmp = System.getProperty("tmpdir");
        if (tmp == null) {
            tmp = "/tmp";
        }
        String uid = null;
        BufferedReader reader = null;
        try {
            Process process = Runtime.getRuntime().exec("id -u");
            int ret = process.waitFor();
            if (ret == 0) {
                InputStream stream = process.getInputStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                String result = reader.readLine();
                int testUid = Integer.parseInt(result);
                uid = String.valueOf(testUid);
            }
        }
        catch (Exception e) {
            log.warn((Object)"No UID found, using user.name");
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        if (uid == null) {
            uid = System.getProperty("user.name");
        }
        location.append(tmp);
        location.append("/");
        location.append("x509up_u");
        location.append(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculated certificate location: " + location.toString()));
        }
        if (!(fileLocation = new File(location.toString())).exists()) {
            throw new FileNotFoundException("No certificate installed in the default location: " + location.toString());
        }
        return fileLocation;
    }

    public void displayCertificate(X509Certificate cert) {
        if (cert == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            log.debug((Object)(" Issuer: " + cert.getIssuerX500Principal().getName("RFC2253")));
            Date notBefore = cert.getNotBefore();
            DateFormat fmt = SimpleDateFormat.getDateTimeInstance();
            log.debug((Object)("   From: " + fmt.format(notBefore)));
            Date notAfter = cert.getNotAfter();
            log.debug((Object)("     To: " + fmt.format(notAfter)));
            log.debug((Object)("Subject: " + this.getSubjectDN(cert)));
            log.debug((Object)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CILOGON_OID_SUBJECT_INFO = null;
        cm = null;
    }

    private static class CertificateManagerSingleton {
        public static final CertificateManager instance = new CertificateManager();

        private CertificateManagerSingleton() {
        }
    }
}

