/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import org.apache.jena.atlas.logging.Log;

public class SPARQLResult {
    private boolean hasBeenSet = false;
    private ResultSet resultSet = null;
    private Boolean booleanResult = null;
    private Model model = null;

    protected SPARQLResult() {
    }

    public SPARQLResult(Model model) {
        this.set(model);
    }

    public SPARQLResult(ResultSet resultSet) {
        this.set(resultSet);
    }

    public SPARQLResult(boolean booleanResult) {
        this.set(booleanResult);
    }

    public boolean isResultSet() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.resultSet != null;
    }

    public boolean isModel() {
        return this.isGraph();
    }

    public boolean isGraph() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.model != null;
    }

    public boolean isBoolean() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        return this.booleanResult != null;
    }

    public ResultSet getResultSet() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isResultSet()) {
            throw new ResultSetException("Not a ResultSet result");
        }
        return this.resultSet;
    }

    public boolean getBooleanResult() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isBoolean()) {
            throw new ResultSetException("Not a boolean result");
        }
        return this.booleanResult;
    }

    public Model getModel() {
        if (!this.hasBeenSet) {
            throw new ResultSetException("Not set");
        }
        if (!this.isModel()) {
            throw new ResultSetException("Not a graph result");
        }
        return this.model;
    }

    public boolean isHasBeenSet() {
        return this.hasBeenSet;
    }

    protected void set(ResultSet rs) {
        this.resultSet = rs;
        this.hasBeenSet = true;
    }

    protected void set(Model m) {
        this.model = m;
        this.hasBeenSet = true;
    }

    protected void set(boolean r) {
        this.set(new Boolean(r));
    }

    protected void set(Boolean r) {
        this.booleanResult = r;
        this.hasBeenSet = true;
    }

    protected static void addBinding(BindingMap binding, Var var, Node value) {
        Node n = binding.get(var);
        if (n != null) {
            if (n.equals((Object)value)) {
                return;
            }
            Log.warn(SPARQLResult.class, String.format("Multiple occurences of a binding for variable '%s' with different values - ignored", var.getName()));
            return;
        }
        binding.add(var, value);
    }
}

