/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ascii;

import com.hazelcast.impl.ascii.TextCommand;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketTextWriter
implements SocketWriter<TextCommand> {
    private final Connection connection;
    private final Map<Long, TextCommand> responses = new ConcurrentHashMap<Long, TextCommand>(100);
    private long currentRequestId = 0L;

    public SocketTextWriter(Connection connection) {
        this.connection = connection;
    }

    public void enqueue(TextCommand response) {
        long requestId = response.getRequestId();
        if (requestId == -1L) {
            this.connection.getWriteHandler().enqueueSocketWritable(response);
        } else if (this.currentRequestId == requestId) {
            this.connection.getWriteHandler().enqueueSocketWritable(response);
            ++this.currentRequestId;
            this.processWaitingResponses();
        } else {
            this.responses.put(requestId, response);
        }
    }

    private void processWaitingResponses() {
        TextCommand response = this.responses.remove(this.currentRequestId);
        while (response != null) {
            this.connection.getWriteHandler().enqueueSocketWritable(response);
            ++this.currentRequestId;
            response = this.responses.remove(this.currentRequestId);
        }
    }

    @Override
    public boolean write(TextCommand socketWritable, ByteBuffer socketBuffer) throws Exception {
        return socketWritable.writeTo(socketBuffer);
    }
}

