/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConcurrency
extends TestSuite {
    static long SLEEP = 100L;
    static int threadCount = 0;
    static final Model model1 = ModelFactory.createDefaultModel();
    static final Model model2 = ModelFactory.createDefaultModel();

    public static TestSuite suite() {
        return new TestConcurrency();
    }

    public TestConcurrency() {
        super("Model concurrency control");
        this.addTest((Test)new Nesting("Lock nesting 1 - same model", model1, true, true, false));
        this.addTest((Test)new Nesting("Lock nesting 2 - same model", model1, false, false, false));
        this.addTest((Test)new Nesting("Lock nesting 3 - same model", model1, true, false, true));
        this.addTest((Test)new Nesting("Lock nesting 4 - same model", model1, false, true, false));
        this.addTest((Test)new Nesting("Lock nesting 1 - defifferent models", model1, true, model2, true, false));
        this.addTest((Test)new Nesting("Lock nesting 2 - defifferent models", model1, false, model2, false, false));
        this.addTest((Test)new Nesting("Lock nesting 3 - defifferent models", model1, true, model2, false, false));
        this.addTest((Test)new Nesting("Lock nesting 4 - defifferent models", model1, false, model2, true, false));
        this.addTest((Test)new Parallel("Parallel concurrency test"));
    }

    static class Parallel
    extends TestCase {
        int threadTotal = 10;
        volatile int writers = 0;

        Parallel(String testName) {
            super(testName);
        }

        protected void runTest() throws Throwable {
            int i;
            Model model = ModelFactory.createDefaultModel();
            Thread[] threads = new Thread[this.threadTotal];
            boolean getReadLock = true;
            for (int i2 = 0; i2 < this.threadTotal; ++i2) {
                String nextId = "T" + Integer.toString(++threadCount);
                threads[i2] = new Operation(model, getReadLock);
                threads[i2].setName(nextId);
                threads[i2].start();
                getReadLock = !getReadLock;
            }
            boolean problems = false;
            for (i = 0; i < this.threadTotal; ++i) {
                try {
                    threads[i].join(200L * SLEEP);
                    continue;
                }
                catch (InterruptedException intEx) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.threadTotal; ++i) {
                if (threads[i].isAlive()) {
                    try {
                        threads[i].join(200L * SLEEP);
                    }
                    catch (InterruptedException intEx) {
                        // empty catch block
                    }
                }
                if (!threads[i].isAlive()) continue;
                System.out.println("Thread " + threads[i].getName() + " failed to finish");
                problems = true;
            }
            Parallel.assertTrue((String)"Some thread failed to finish", (!problems ? 1 : 0) != 0);
        }

        void doStuff(String label, boolean doThrow) {
            String id = Thread.currentThread().getName();
            try {
                Thread.sleep(SLEEP);
            }
            catch (InterruptedException intEx) {
                // empty catch block
            }
            if (doThrow) {
                throw new RuntimeException(label);
            }
        }

        public void readOperation(boolean doThrow) {
            if (this.writers > 0) {
                System.err.println("Concurrency error: writers around!");
            }
            this.doStuff("read operation", false);
            if (this.writers > 0) {
                System.err.println("Concurrency error: writers around!");
            }
        }

        public void writeOperation(boolean doThrow) {
            ++this.writers;
            this.doStuff("write operation", false);
            --this.writers;
        }

        class Operation
        extends Thread {
            Model model;
            boolean readLock;

            Operation(Model m, boolean withReadLock) {
                this.model = m;
                this.readLock = withReadLock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = 0; i < 2; ++i) {
                    try {
                        this.model.enterCriticalSection(this.readLock);
                        if (this.readLock) {
                            Parallel.this.readOperation(false);
                            continue;
                        }
                        Parallel.this.writeOperation(false);
                        continue;
                    }
                    finally {
                        this.model.leaveCriticalSection();
                    }
                }
            }
        }
    }

    static class Nesting
    extends TestCase {
        Model outerModel;
        Model innerModel;
        boolean outerLock;
        boolean innerLock;
        boolean exceptionExpected;

        Nesting(String testName, Model model, boolean lock1, boolean lock2, boolean exExpected) {
            this(testName, model, lock1, model, lock2, exExpected);
        }

        Nesting(String testName, Model model1, boolean lock1, Model model2, boolean lock2, boolean exExpected) {
            super(testName);
            this.outerModel = model1;
            this.outerLock = lock1;
            this.innerModel = model2;
            this.innerLock = lock2;
            this.exceptionExpected = exExpected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws Throwable {
            boolean gotException = false;
            try {
                this.outerModel.enterCriticalSection(this.outerLock);
                try {
                    try {
                        this.innerModel.enterCriticalSection(this.innerLock);
                    }
                    finally {
                        this.innerModel.leaveCriticalSection();
                    }
                }
                catch (Exception ex) {
                    gotException = true;
                }
            }
            finally {
                this.outerModel.leaveCriticalSection();
            }
            if (this.exceptionExpected) {
                Nesting.assertTrue((String)"Failed to get expected lock promotion error", (boolean)gotException);
            } else {
                Nesting.assertTrue((String)"Got unexpected lock promotion error", (!gotException ? 1 : 0) != 0);
            }
        }
    }
}

