/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.BinaryAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.IntegerAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.StringAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.TelephoneNumberAnonymizer;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.DnSyntaxChecker;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;

public class LdifAnonymizer {
    private Map<Value<?>, Value<?>> valueMap = new HashMap();
    private Map<String, Anonymizer> attributeAnonymizers = new HashMap<String, Anonymizer>();
    private Set<Dn> namingContexts = new HashSet<Dn>();
    private SchemaManager schemaManager;
    private PrintStream out = null;

    public LdifAnonymizer() {
        try {
            this.schemaManager = new DefaultSchemaManager();
        }
        catch (Exception e) {
            this.println("Missing a SchemaManager !");
            System.exit(-1);
        }
        this.init();
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    private void print(String str) {
        if (this.out != null) {
            this.out.print(str);
        }
    }

    private void println(String str) {
        if (this.out != null) {
            this.out.println(str);
        }
    }

    private void println() {
        if (this.out != null) {
            this.out.println();
        }
    }

    public LdifAnonymizer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.init();
    }

    private void init() {
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.1", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.3", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.13", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.241", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.2", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.1", (Anonymizer)new IntegerAnonymizer());
        this.attributeAnonymizers.put("2.5.4.42", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.3", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.20", (Anonymizer)new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.39", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.9", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.51", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.60", (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.4.1.250.1.57", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.7", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.3", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.10", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.12", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.41", (Anonymizer)new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("2.5.4.10", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.11", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.42", (Anonymizer)new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("2.5.4.16", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.7", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.21", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.34", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.4", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.20", (Anonymizer)new TelephoneNumberAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.1", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.0", (Anonymizer)new IntegerAnonymizer());
        this.attributeAnonymizers.put("2.5.4.36", (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.35", (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.216", (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.40", (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.5.4.45", (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.5.4.23", (Anonymizer)new TelephoneNumberAnonymizer());
    }

    public void addAnonAttributeType(AttributeType attributeType) throws LdapException {
        this.schemaManager.add((SchemaObject)attributeType);
        LdapSyntax syntax = attributeType.getSyntax();
        if (syntax.isHumanReadable()) {
            if (syntax.getOid().equals("1.3.6.1.4.1.1466.115.121.1.27")) {
                this.attributeAnonymizers.put(attributeType.getOid(), (Anonymizer)new IntegerAnonymizer());
            }
            if (syntax.getOid().equals("1.3.6.1.4.1.1466.115.121.1.15")) {
                this.attributeAnonymizers.put(attributeType.getOid(), (Anonymizer)new StringAnonymizer());
            }
        } else {
            this.attributeAnonymizers.put(attributeType.getOid(), (Anonymizer)new BinaryAnonymizer());
        }
    }

    public void addAnonAttributeType(AttributeType attributeType, Anonymizer<?> anonymizer) throws LdapException {
        this.schemaManager.add((SchemaObject)attributeType);
        this.attributeAnonymizers.put(attributeType.getOid(), anonymizer);
    }

    public void removeAnonAttributeType(AttributeType attributeType) throws LdapException {
        this.attributeAnonymizers.remove(attributeType);
    }

    public Map<String, Anonymizer> getAttributeAnonymizers() {
        return this.attributeAnonymizers;
    }

    public void addNamingContext(String dn) throws LdapInvalidDnException {
        Dn namingContext = new Dn(this.schemaManager, new String[]{dn});
        this.namingContexts.add(namingContext);
    }

    private Ava anonymizeAva(Ava ava) throws LdapInvalidDnException, LdapInvalidAttributeValueException {
        Value value = ava.getValue();
        AttributeType attributeType = ava.getAttributeType();
        Value<?> anonymizedValue = this.valueMap.get(value);
        Ava anonymizedAva = null;
        if (anonymizedValue == null) {
            DefaultAttribute attribute = new DefaultAttribute(attributeType);
            attribute.add(new Value[]{value});
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
            if (value.isHumanReadable()) {
                if (anonymizer == null) {
                    anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), value.getString());
                } else {
                    Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, (Attribute)attribute);
                    anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), anonymizedAttribute.getString());
                }
            } else if (anonymizer == null) {
                anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), value.getBytes());
            } else {
                Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, (Attribute)attribute);
                anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), anonymizedAttribute.getBytes());
            }
        } else {
            anonymizedAva = value.isHumanReadable() ? new Ava(this.schemaManager, attributeType.getName(), anonymizedValue.getString()) : new Ava(this.schemaManager, attributeType.getName(), anonymizedValue.getBytes());
        }
        return anonymizedAva;
    }

    private Dn anonymizeDn(Dn entryDn) throws LdapException {
        Dn descendant = entryDn;
        Dn namingContext = null;
        for (Dn nc : this.namingContexts) {
            if (!entryDn.isDescendantOf(nc)) continue;
            descendant = entryDn.getDescendantOf(nc);
            namingContext = nc;
            break;
        }
        Rdn[] anonymizedRdns = new Rdn[entryDn.size()];
        int rdnPos = entryDn.size() - 1;
        if (namingContext != null) {
            Iterator iterator = namingContext.iterator();
            while (iterator.hasNext()) {
                Rdn ncRdn;
                anonymizedRdns[rdnPos] = ncRdn = (Rdn)iterator.next();
                --rdnPos;
            }
        }
        for (Rdn rdn : descendant) {
            Rdn anonymizedRdn;
            Ava[] anonymizedAvas = new Ava[rdn.size()];
            int pos = 0;
            for (Ava ava : rdn) {
                Ava anonymizedAva;
                anonymizedAvas[pos] = anonymizedAva = this.anonymizeAva(ava);
                ++pos;
            }
            anonymizedRdns[rdnPos] = anonymizedRdn = new Rdn(this.schemaManager, anonymizedAvas);
            --rdnPos;
        }
        Dn anonymizedDn = new Dn(this.schemaManager, anonymizedRdns);
        return anonymizedDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anonymizeFile(String ldifFile, Writer writer) throws LdapException, IOException {
        File inputFile = new File(ldifFile);
        if (!inputFile.exists()) {
            this.println("Cannot open file " + ldifFile);
            return;
        }
        LdifReader ldifReader = new LdifReader(inputFile, this.schemaManager);
        int count = 0;
        ArrayList<LdifEntry> errors = new ArrayList<LdifEntry>();
        ArrayList<String> errorTexts = new ArrayList<String>();
        try {
            for (LdifEntry ldifEntry : ldifReader) {
                ++count;
                try {
                    Entry entry = ldifEntry.getEntry();
                    DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
                    Dn entryDn = entry.getDn();
                    Dn anonymizedDn = this.anonymizeDn(entryDn);
                    if (anonymizedDn == null) continue;
                    for (Attribute attribute : entry) {
                        AttributeType attributeType = attribute.getAttributeType();
                        if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                            for (Value dnValue : attribute) {
                                String dnStr = dnValue.getString();
                                Dn dn = new Dn(this.schemaManager, new String[]{dnStr});
                                Dn newdDn = this.anonymizeDn(dn);
                                newEntry.add(attributeType, new String[]{newdDn.toString()});
                            }
                            continue;
                        }
                        Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
                        if (anonymizer == null) {
                            newEntry.add(new Attribute[]{attribute});
                            continue;
                        }
                        Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
                        newEntry.add(new Attribute[]{anonymizedAttribute});
                    }
                    newEntry.setDn(anonymizedDn);
                    writer.write(LdifUtils.convertToLdif((Entry)newEntry));
                    writer.write("\n");
                    System.out.print('.');
                    if (count % 100 != 0) continue;
                    this.println();
                }
                catch (Exception e) {
                    System.out.print('*');
                    if (count % 100 == 0) {
                        this.println();
                    }
                    errors.add(ldifEntry);
                    errorTexts.add(e.getMessage());
                }
            }
            this.println();
            if (errors.size() != 0) {
                this.println("There are " + errors.size() + " bad entries");
                int i = 0;
                for (LdifEntry ldifEntry : errors) {
                    this.println("---------------------------------------------------");
                    this.println("error : " + (String)errorTexts.get(i));
                    this.println(ldifEntry.getDn().toString());
                    ++i;
                }
            }
        }
        finally {
            this.println();
            if (errors.size() != 0) {
                this.println("There are " + errors.size() + " bad entries");
            }
            this.println("Nb entries : " + count);
            ldifReader.close();
        }
    }

    private LdifEntry anonymizeChangeModify(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        LdifEntry newLdifEntry = new LdifEntry(this.schemaManager);
        newLdifEntry.setChangeType(ChangeType.Modify);
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        if (anonymizedDn == null) {
            return null;
        }
        newLdifEntry.setDn(anonymizedDn);
        for (Modification modification : ldifEntry.getModifications()) {
            DefaultModification anonymizedModification;
            Attribute attribute = modification.getAttribute();
            AttributeType attributeType = this.schemaManager.getAttributeType(attribute.getId());
            attribute.apply(attributeType);
            if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                Value[] anonymizedValues = new Value[attribute.size()];
                int pos = 0;
                for (Value dnValue : modification.getAttribute()) {
                    Dn dn = new Dn(this.schemaManager, new String[]{dnValue.getString()});
                    Dn newdDn = this.anonymizeDn(dn);
                    anonymizedValues[pos++] = new StringValue(newdDn.toString());
                }
                anonymizedModification = new DefaultModification(modification.getOperation(), attributeType, anonymizedValues);
                newLdifEntry.addModification((Modification)anonymizedModification);
                continue;
            }
            Anonymizer anonymizer = this.attributeAnonymizers.get(attributeType.getOid());
            if (anonymizer == null) {
                newLdifEntry.addModification(modification);
                continue;
            }
            Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
            anonymizedModification = new DefaultModification(modification.getOperation(), anonymizedAttribute);
            newLdifEntry.addModification((Modification)anonymizedModification);
        }
        return newLdifEntry;
    }

    private LdifEntry anonymizeChangeAdd(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        LdifEntry newLdifEntry = new LdifEntry(this.schemaManager);
        newLdifEntry.setChangeType(ChangeType.Add);
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        if (anonymizedDn == null) {
            return null;
        }
        newLdifEntry.setDn(anonymizedDn);
        for (Attribute attribute : ldifEntry) {
            AttributeType attributeType = attribute.getAttributeType();
            DefaultAttribute anonymizedAttribute = new DefaultAttribute(attributeType);
            if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                for (Value dnValue : attribute) {
                    Dn dn = new Dn(this.schemaManager, new String[]{dnValue.getString()});
                    Dn newdDn = this.anonymizeDn(dn);
                    anonymizedAttribute.add(new String[]{newdDn.toString()});
                }
                newLdifEntry.addAttribute(attribute);
                continue;
            }
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
            if (anonymizer == null) {
                newLdifEntry.addAttribute(attribute);
                continue;
            }
            anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
            if (anonymizedAttribute == null) continue;
            newLdifEntry.addAttribute((Attribute)anonymizedAttribute);
        }
        return newLdifEntry;
    }

    private LdifEntry anonymizeChangeDelete(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        if (anonymizedDn == null) {
            return null;
        }
        ldifEntry.setDn(anonymizedDn);
        return ldifEntry;
    }

    private LdifEntry anonymizeChangeModDn(LdifEntry ldifEntry) throws LdapException {
        Dn entryDn = ldifEntry.getDn();
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        if (anonymizedDn == null) {
            return null;
        }
        ldifEntry.setDn(anonymizedDn);
        Dn newRdn = new Dn(this.schemaManager, new String[]{ldifEntry.getNewRdn()});
        Dn anonymizedRdn = this.anonymizeDn(newRdn);
        if (anonymizedRdn == null) {
            return null;
        }
        ldifEntry.setNewRdn(anonymizedRdn.toString());
        Dn newSuperior = new Dn(this.schemaManager, new String[]{ldifEntry.getNewSuperior()});
        Dn anonymizedSuperior = this.anonymizeDn(newSuperior);
        if (anonymizedSuperior == null) {
            return null;
        }
        ldifEntry.setNewSuperior(anonymizedSuperior.toString());
        return ldifEntry;
    }

    private Entry anonymizeEntry(LdifEntry ldifEntry) throws LdapException {
        Entry entry = ldifEntry.getEntry();
        DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
        Dn entryDn = entry.getDn();
        Dn anonymizedDn = this.anonymizeDn(entryDn);
        if (anonymizedDn == null) {
            return null;
        }
        for (Attribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                for (Value dnValue : attribute) {
                    Dn dn = new Dn(this.schemaManager, new String[]{dnValue.getString()});
                    Dn newdDn = this.anonymizeDn(dn);
                    newEntry.add(attributeType, new String[]{newdDn.toString()});
                }
                continue;
            }
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
            if (anonymizer == null) {
                newEntry.add(new Attribute[]{attribute});
                continue;
            }
            Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
            if (anonymizedAttribute == null) continue;
            newEntry.add(new Attribute[]{anonymizedAttribute});
        }
        newEntry.setDn(anonymizedDn);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String anonymize(String ldif) throws LdapException, IOException {
        try (LdifReader ldifReader = new LdifReader(this.schemaManager);){
            List entries = ldifReader.parseLdif(ldif);
            StringBuilder result = new StringBuilder();
            for (LdifEntry ldifEntry : entries) {
                LdifEntry newLdifEntry;
                if (ldifEntry.isEntry() && !ldifEntry.isChangeAdd()) {
                    Entry newEntry = this.anonymizeEntry(ldifEntry);
                    if (newEntry == null) continue;
                    result.append(LdifUtils.convertToLdif((Entry)newEntry));
                    result.append("\n");
                    continue;
                }
                if (ldifEntry.isChangeDelete()) {
                    newLdifEntry = this.anonymizeChangeDelete(ldifEntry);
                    if (ldifEntry == null) continue;
                    result.append(newLdifEntry);
                    result.append("\n");
                    continue;
                }
                if (ldifEntry.isChangeAdd()) {
                    newLdifEntry = this.anonymizeChangeAdd(ldifEntry);
                    if (ldifEntry == null) continue;
                    result.append(newLdifEntry);
                    result.append("\n");
                    continue;
                }
                if (ldifEntry.isChangeModify()) {
                    newLdifEntry = this.anonymizeChangeModify(ldifEntry);
                    if (ldifEntry == null) continue;
                    result.append(newLdifEntry);
                    result.append("\n");
                    continue;
                }
                if (!ldifEntry.isChangeModDn() && !ldifEntry.isChangeModRdn()) continue;
                newLdifEntry = this.anonymizeChangeModDn(ldifEntry);
                if (ldifEntry == null) continue;
                result.append(newLdifEntry);
                result.append("\n");
            }
            String string = result.toString();
            return string;
        }
    }

    public Map<Value<?>, Value<?>> getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map<Value<?>, Value<?>> valueMap) {
        this.valueMap = valueMap;
    }

    public static void main(String[] args) throws IOException, LdapException {
        if (args == null || args.length < 1) {
            System.out.println("No file to anonymize");
            return;
        }
        LdifAnonymizer anonymizer = new LdifAnonymizer();
        String ldifString = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), Charset.defaultCharset()));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            ldifString = sb.toString();
        }
        String result = anonymizer.anonymize(ldifString);
        System.out.println(result);
    }
}

