/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerDirContext;
import org.apache.directory.server.i18n.I18n;

public class ServerLdapContext
extends ServerDirContext
implements LdapContext {
    public ServerLdapContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        super(service, env);
    }

    public ServerLdapContext(DirectoryService service, LdapPrincipal principal, Name dn) throws Exception {
        super(service, principal, dn);
    }

    public ServerLdapContext(DirectoryService service, CoreSession session, Name bindDn) throws Exception {
        super(service, session, bindDn);
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) {
        throw new NotImplementedException();
    }

    @Override
    public LdapContext newInstance(javax.naming.ldap.Control[] requestControls) throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), JndiUtils.toName((Dn)this.getDn()));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        ctx.setRequestControls(requestControls);
        return ctx;
    }

    @Override
    public void reconnect(javax.naming.ldap.Control[] connCtls) throws NamingException {
        this.connectControls = connCtls;
    }

    @Override
    public javax.naming.ldap.Control[] getConnectControls() throws NamingException {
        return this.connectControls;
    }

    @Override
    public void setRequestControls(javax.naming.ldap.Control[] requestControls) throws NamingException {
        this.requestControls = requestControls;
    }

    @Override
    public javax.naming.ldap.Control[] getRequestControls() throws NamingException {
        return this.requestControls;
    }

    @Override
    public javax.naming.ldap.Control[] getResponseControls() throws NamingException {
        return this.responseControls;
    }

    public boolean compare(Dn name, String oid, Object value) throws NamingException {
        StringValue val;
        block13: {
            val = null;
            AttributeType attributeType = null;
            try {
                attributeType = this.getService().getSchemaManager().lookupAttributeTypeRegistry(oid);
            }
            catch (LdapException le) {
                throw new InvalidAttributeIdentifierException(le.getMessage());
            }
            try {
                if (attributeType.getSyntax().isHumanReadable()) {
                    if (value instanceof String) {
                        val = new StringValue(attributeType, (String)value);
                        break block13;
                    }
                    if (value instanceof byte[]) {
                        val = new StringValue(attributeType, Strings.utf8ToString((byte[])((byte[])value)));
                        break block13;
                    }
                    throw new NamingException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
                }
                if (value instanceof String) {
                    val = new BinaryValue(attributeType, Strings.getBytesUtf8((String)((String)value)));
                    break block13;
                }
                if (value instanceof byte[]) {
                    val = new BinaryValue(attributeType, (byte[])value);
                    break block13;
                }
                throw new NamingException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
            }
            catch (LdapInvalidAttributeValueException liave) {
                throw new NamingException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
            }
        }
        CompareOperationContext opCtx = new CompareOperationContext(this.getSession(), name, oid, (Value)val);
        try {
            opCtx.addRequestControls(JndiUtils.fromJndiControls((LdapApiService)this.getDirectoryService().getLdapCodecService(), (javax.naming.ldap.Control[])this.requestControls));
        }
        catch (DecoderException e1) {
            throw new NamingException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
        }
        this.injectReferralControl((OperationContext)opCtx);
        boolean result = false;
        try {
            result = super.getDirectoryService().getOperationManager().compare(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        this.responseControls = this.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
        return result;
    }

    public void ldapUnbind() throws NamingException {
        UnbindOperationContext opCtx = new UnbindOperationContext(this.getSession());
        try {
            opCtx.addRequestControls(JndiUtils.fromJndiControls((LdapApiService)this.getDirectoryService().getLdapCodecService(), (javax.naming.ldap.Control[])this.requestControls));
        }
        catch (DecoderException e1) {
            throw new NamingException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{"unbind encoder exception"}));
        }
        try {
            super.getDirectoryService().getOperationManager().unbind(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        try {
            this.responseControls = JndiUtils.toJndiControls((LdapApiService)this.getDirectoryService().getLdapCodecService(), (Control[])opCtx.getResponseControls());
        }
        catch (EncoderException e) {
            throw new NamingException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{"unbind encoder exception"}));
        }
        this.requestControls = EMPTY_CONTROLS;
    }

    @Override
    public ServerContext getRootContext() throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), (Name)new LdapName(""));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        return ctx;
    }
}

