/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.recman.BaseRecordManager;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequest;
import org.apache.directory.api.ldap.model.message.controls.SortResponse;
import org.apache.directory.api.ldap.model.message.controls.SortResponseControlImpl;
import org.apache.directory.api.ldap.model.message.controls.SortResultCode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.changelog.LogChange;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.shared.NullStringSerializer;
import org.apache.directory.server.core.shared.SortedEntryComparator;
import org.apache.directory.server.core.shared.SortedEntryCursor;
import org.apache.directory.server.core.shared.SortedEntrySerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;

public class DefaultCoreSession
implements CoreSession {
    private final DirectoryService directoryService;
    private final LdapPrincipal authenticatedPrincipal;
    private final LdapPrincipal anonymousPrincipal;
    private LdapPrincipal authorizedPrincipal;
    protected AttributeType objectClassAT;
    private IoSession ioSession;
    private boolean pwdMustChange;

    public DefaultCoreSession(LdapPrincipal principal, DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.authenticatedPrincipal = principal;
        this.anonymousPrincipal = principal.getAuthenticationLevel() == AuthenticationLevel.NONE ? principal : new LdapPrincipal(directoryService.getSchemaManager());
        this.objectClassAT = directoryService.getSchemaManager().getAttributeType("objectClass");
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    private void setReferralHandling(AbstractOperationContext opContext, boolean ignoreReferral) {
        if (ignoreReferral) {
            opContext.ignoreReferral();
        } else {
            opContext.throwReferral();
        }
    }

    public void add(Entry entry) throws LdapException {
        this.add(entry, LogChange.TRUE);
    }

    public void add(Entry entry, boolean ignoreReferral) throws LdapException {
        this.add(entry, ignoreReferral, LogChange.TRUE);
    }

    public void add(Entry entry, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, entry);
        addContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(addContext);
    }

    public void add(Entry entry, boolean ignoreReferral, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, entry);
        addContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)addContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(addContext);
    }

    public void add(AddRequest addRequest) throws LdapException {
        this.add(addRequest, LogChange.TRUE);
    }

    public void add(AddRequest addRequest, LogChange log) throws LdapException {
        AddOperationContext addContext = new AddOperationContext((CoreSession)this, addRequest);
        addContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.add(addContext);
        }
        catch (LdapException e) {
            addRequest.getResultResponse().addAllControls(addContext.getResponseControls());
            throw e;
        }
        addRequest.getResultResponse().addAllControls(addContext.getResponseControls());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value<?> convertToValue(String oid, Object value) throws LdapException {
        StringValue val = null;
        AttributeType attributeType = this.directoryService.getSchemaManager().lookupAttributeTypeRegistry(oid);
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                return new StringValue(attributeType, (String)value);
            }
            if (!(value instanceof byte[])) throw new LdapException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
            return new StringValue(attributeType, Strings.utf8ToString((byte[])((byte[])value)));
        }
        if (value instanceof String) {
            return new BinaryValue(attributeType, Strings.getBytesUtf8((String)((String)value)));
        }
        if (!(value instanceof byte[])) throw new LdapException(I18n.err((I18n)I18n.ERR_309, (Object[])new Object[]{oid}));
        return new BinaryValue(attributeType, (byte[])value);
    }

    public boolean compare(Dn dn, String oid, Object value) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(new CompareOperationContext((CoreSession)this, dn, oid, this.convertToValue(oid, value)));
    }

    public boolean compare(Dn dn, String oid, Object value, boolean ignoreReferral) throws LdapException {
        CompareOperationContext compareContext = new CompareOperationContext((CoreSession)this, dn, oid, this.convertToValue(oid, value));
        this.setReferralHandling((AbstractOperationContext)compareContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(compareContext);
    }

    public void delete(Dn dn) throws LdapException {
        this.delete(dn, LogChange.TRUE);
    }

    public void delete(Dn dn, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, dn);
        deleteContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(deleteContext);
    }

    public void delete(Dn dn, boolean ignoreReferral) throws LdapException {
        this.delete(dn, ignoreReferral, LogChange.TRUE);
    }

    public void delete(Dn dn, boolean ignoreReferral, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, dn);
        deleteContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)deleteContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(deleteContext);
    }

    public LdapPrincipal getAnonymousPrincipal() {
        return this.anonymousPrincipal;
    }

    public LdapPrincipal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.getEffectivePrincipal().getAuthenticationLevel();
    }

    public SocketAddress getClientAddress() {
        if (this.ioSession != null) {
            return this.ioSession.getRemoteAddress();
        }
        return null;
    }

    public Set<Control> getControls() {
        return null;
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal == null) {
            return this.authenticatedPrincipal;
        }
        return this.authorizedPrincipal;
    }

    public Set<OperationContext> getOutstandingOperations() {
        return null;
    }

    public SocketAddress getServiceAddress() {
        if (this.ioSession != null) {
            return this.ioSession.getServiceAddress();
        }
        return null;
    }

    public boolean isConfidential() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public boolean isAdministrator() {
        String normName = this.getEffectivePrincipal().getName();
        return normName.equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    public boolean isAnAdministrator() {
        return this.isAdministrator();
    }

    public Cursor<Entry> list(Dn dn, AliasDerefMode aliasDerefMode, String ... returningAttributes) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        PresenceNode filter = new PresenceNode(this.objectClassAT);
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, dn, SearchScope.ONELEVEL, (ExprNode)filter, returningAttributes);
        searchContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.search(searchContext);
    }

    public Entry lookup(Dn dn, String ... attrIds) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        LookupOperationContext lookupContext = new LookupOperationContext((CoreSession)this, dn, attrIds);
        Entry entry = operationManager.lookup(lookupContext);
        return entry;
    }

    public Entry lookup(Dn dn, Control[] controls, String ... attrIds) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        LookupOperationContext lookupContext = new LookupOperationContext((CoreSession)this, dn, attrIds);
        if (controls != null) {
            lookupContext.addRequestControls(controls);
        }
        Entry entry = operationManager.lookup(lookupContext);
        return entry;
    }

    public void modify(Dn dn, Modification ... mods) throws LdapException {
        this.modify(dn, Arrays.asList(mods), LogChange.TRUE);
    }

    public void modify(Dn dn, List<Modification> mods) throws LdapException {
        this.modify(dn, mods, LogChange.TRUE);
    }

    public void modify(Dn dn, List<Modification> mods, LogChange log) throws LdapException {
        if (mods == null) {
            return;
        }
        ArrayList<DefaultModification> serverModifications = new ArrayList<DefaultModification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext((CoreSession)this, dn, serverModifications);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    public void modify(Dn dn, List<Modification> mods, boolean ignoreReferral) throws LdapException {
        this.modify(dn, mods, ignoreReferral, LogChange.TRUE);
    }

    public void modify(Dn dn, List<Modification> mods, boolean ignoreReferral, LogChange log) throws LdapException {
        if (mods == null) {
            return;
        }
        ArrayList<DefaultModification> serverModifications = new ArrayList<DefaultModification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new DefaultModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext modifyContext = new ModifyOperationContext((CoreSession)this, dn, serverModifications);
        this.setReferralHandling((AbstractOperationContext)modifyContext, ignoreReferral);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(modifyContext);
    }

    public void move(Dn dn, Dn newParent) throws LdapException {
        this.move(dn, newParent, LogChange.TRUE);
    }

    public void move(Dn dn, Dn newParent, LogChange log) throws LdapException {
        MoveOperationContext moveContext = new MoveOperationContext((CoreSession)this, dn, newParent);
        moveContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(moveContext);
    }

    public void move(Dn dn, Dn newParent, boolean ignoreReferral) throws Exception {
        this.move(dn, newParent, ignoreReferral, LogChange.TRUE);
    }

    public void move(Dn dn, Dn newParent, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveOperationContext moveContext = new MoveOperationContext((CoreSession)this, dn, newParent);
        this.setReferralHandling((AbstractOperationContext)moveContext, ignoreReferral);
        moveContext.setLogChange(log);
        operationManager.move(moveContext);
    }

    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    public void moveAndRename(Dn dn, Dn newSuperiorDn, Rdn newRdn, boolean deleteOldRdn, LogChange log) throws LdapException {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext((CoreSession)this, dn, newSuperiorDn, newRdn, deleteOldRdn);
        moveAndRenameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(moveAndRenameContext);
    }

    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws LdapException {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    public void moveAndRename(Dn dn, Dn newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext((CoreSession)this, dn, newParent, newRdn, deleteOldRdn);
        moveAndRenameContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)moveAndRenameContext, ignoreReferral);
        operationManager.moveAndRename(moveAndRenameContext);
    }

    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        this.rename(dn, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, LogChange log) throws LdapException {
        RenameOperationContext renameContext = new RenameOperationContext((CoreSession)this, dn, newRdn, deleteOldRdn);
        renameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(renameContext);
    }

    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws LdapException {
        this.rename(dn, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    public void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        RenameOperationContext renameContext = new RenameOperationContext((CoreSession)this, dn, newRdn, deleteOldRdn);
        renameContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)renameContext, ignoreReferral);
        operationManager.rename(renameContext);
    }

    public Cursor<Entry> search(Dn dn, String filter) throws LdapException {
        return this.search(dn, filter, true);
    }

    public Cursor<Entry> search(Dn dn, String filter, boolean ignoreReferrals) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ExprNode filterNode = null;
        try {
            filterNode = FilterParser.parse((SchemaManager)this.directoryService.getSchemaManager(), (String)filter);
        }
        catch (ParseException pe) {
            throw new LdapInvalidSearchFilterException(pe.getMessage());
        }
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, dn, SearchScope.OBJECT, filterNode, new String[]{null});
        searchContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        this.setReferralHandling((AbstractOperationContext)searchContext, ignoreReferrals);
        return operationManager.search(searchContext);
    }

    public Cursor<Entry> search(Dn dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, String ... returningAttributes) throws LdapException {
        OperationManager operationManager = this.directoryService.getOperationManager();
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, dn, scope, filter, returningAttributes);
        searchContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.search(searchContext);
    }

    public boolean isAnonymous() {
        if (this.authorizedPrincipal == null && this.authenticatedPrincipal == null) {
            return true;
        }
        return this.authenticatedPrincipal.getAuthenticationLevel() == AuthenticationLevel.NONE;
    }

    public boolean compare(CompareRequest compareRequest) throws LdapException {
        CompareOperationContext compareContext = new CompareOperationContext((CoreSession)this, compareRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        boolean result = false;
        try {
            result = operationManager.compare(compareContext);
        }
        catch (LdapException e) {
            compareRequest.getResultResponse().addAllControls(compareContext.getResponseControls());
            throw e;
        }
        compareRequest.getResultResponse().addAllControls(compareContext.getResponseControls());
        return result;
    }

    public void delete(DeleteRequest deleteRequest) throws LdapException {
        this.delete(deleteRequest, LogChange.TRUE);
    }

    public void delete(DeleteRequest deleteRequest, LogChange log) throws LdapException {
        DeleteOperationContext deleteContext = new DeleteOperationContext((CoreSession)this, deleteRequest);
        deleteContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.delete(deleteContext);
        }
        catch (LdapException e) {
            deleteRequest.getResultResponse().addAllControls(deleteContext.getResponseControls());
            throw e;
        }
        deleteRequest.getResultResponse().addAllControls(deleteContext.getResponseControls());
    }

    public boolean exists(String dn) throws LdapException {
        return this.exists(new Dn(new String[]{dn}));
    }

    public boolean exists(Dn dn) throws LdapException {
        HasEntryOperationContext hasEntryContext = new HasEntryOperationContext((CoreSession)this, dn);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.hasEntry(hasEntryContext);
    }

    public void modify(ModifyRequest modifyRequest) throws LdapException {
        this.modify(modifyRequest, LogChange.TRUE);
    }

    public void modify(ModifyRequest modifyRequest, LogChange log) throws LdapException {
        ModifyOperationContext modifyContext = new ModifyOperationContext((CoreSession)this, modifyRequest);
        modifyContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.modify(modifyContext);
        }
        catch (LdapException e) {
            modifyRequest.getResultResponse().addAllControls(modifyContext.getResponseControls());
            throw e;
        }
        modifyRequest.getResultResponse().addAllControls(modifyContext.getResponseControls());
    }

    public void move(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.move(modifyDnRequest, LogChange.TRUE);
    }

    public void move(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        MoveOperationContext moveContext = new MoveOperationContext((CoreSession)this, modifyDnRequest);
        moveContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.move(moveContext);
        }
        catch (LdapException e) {
            modifyDnRequest.getResultResponse().addAllControls(moveContext.getResponseControls());
            throw e;
        }
        modifyDnRequest.getResultResponse().addAllControls(moveContext.getResponseControls());
    }

    public void moveAndRename(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.moveAndRename(modifyDnRequest, LogChange.TRUE);
    }

    public void moveAndRename(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        MoveAndRenameOperationContext moveAndRenameContext = new MoveAndRenameOperationContext((CoreSession)this, modifyDnRequest);
        moveAndRenameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.moveAndRename(moveAndRenameContext);
        }
        catch (LdapException e) {
            modifyDnRequest.getResultResponse().addAllControls(moveAndRenameContext.getResponseControls());
            throw e;
        }
        modifyDnRequest.getResultResponse().addAllControls(moveAndRenameContext.getResponseControls());
    }

    public void rename(ModifyDnRequest modifyDnRequest) throws LdapException {
        this.rename(modifyDnRequest, LogChange.TRUE);
    }

    public void rename(ModifyDnRequest modifyDnRequest, LogChange log) throws LdapException {
        RenameOperationContext renameContext = new RenameOperationContext((CoreSession)this, modifyDnRequest);
        renameContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        try {
            operationManager.rename(renameContext);
        }
        catch (LdapException e) {
            modifyDnRequest.getResultResponse().addAllControls(renameContext.getResponseControls());
            throw e;
        }
        modifyDnRequest.getResultResponse().addAllControls(renameContext.getResponseControls());
    }

    public Cursor<Entry> search(SearchRequest searchRequest) throws LdapException {
        SearchOperationContext searchContext = new SearchOperationContext((CoreSession)this, searchRequest);
        searchContext.setSyncreplSearch(searchRequest.getControls().containsKey("1.3.6.1.4.1.4203.1.9.1.1"));
        OperationManager operationManager = this.directoryService.getOperationManager();
        SortRequest sortControl = (SortRequest)searchRequest.getControls().get("1.2.840.113556.1.4.473");
        SortResponse sortRespCtrl = null;
        ResultResponse done = searchRequest.getResultResponse();
        LdapResult ldapResult = done.getLdapResult();
        if (sortControl != null) {
            sortRespCtrl = this.canSort(sortControl, ldapResult, this.getDirectoryService().getSchemaManager());
            if (sortControl.isCritical() && sortRespCtrl.getSortResult() != SortResultCode.SUCCESS) {
                ldapResult.setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                done.addControl((Control)sortRespCtrl);
                return new EmptyCursor();
            }
        }
        Cursor<Entry> cursor = null;
        try {
            cursor = operationManager.search(searchContext);
            if (sortRespCtrl != null && sortRespCtrl.getSortResult() == SortResultCode.SUCCESS) {
                cursor = this.sortResults(cursor, sortControl, this.getDirectoryService().getSchemaManager());
            }
            if (sortRespCtrl != null) {
                cursor.beforeFirst();
                if (!cursor.next()) {
                    sortRespCtrl = null;
                } else {
                    cursor.previous();
                }
            }
        }
        catch (LdapException e) {
            done.addAllControls(searchContext.getResponseControls());
            throw e;
        }
        catch (Exception e) {
            done.addAllControls(searchContext.getResponseControls());
            throw new LdapException((Throwable)e);
        }
        if (sortRespCtrl != null) {
            done.addControl((Control)sortRespCtrl);
        }
        done.addAllControls(searchContext.getResponseControls());
        return cursor;
    }

    public void unbind() throws LdapException {
        UnbindOperationContext unbindContext = new UnbindOperationContext((CoreSession)this);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(unbindContext);
    }

    public void unbind(UnbindRequest unbindRequest) throws LdapException {
        UnbindOperationContext unbindContext = new UnbindOperationContext((CoreSession)this, unbindRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(unbindContext);
    }

    private SortResponse canSort(SortRequest sortControl, LdapResult ldapResult, SchemaManager schemaManager) {
        SortResponseControlImpl resp = new SortResponseControlImpl();
        List keys = sortControl.getSortKeys();
        if (keys.size() > 1) {
            ldapResult.setDiagnosticMessage("Cannot sort results based on more than one attribute");
            resp.setSortResult(SortResultCode.UNWILLINGTOPERFORM);
            return resp;
        }
        SortKey sk = (SortKey)keys.get(0);
        AttributeType at = schemaManager.getAttributeType(sk.getAttributeTypeDesc());
        if (at == null) {
            ldapResult.setDiagnosticMessage("No attribute with the name " + sk.getAttributeTypeDesc() + " exists in the server's schema");
            resp.setSortResult(SortResultCode.NOSUCHATTRIBUTE);
            resp.setAttributeName(sk.getAttributeTypeDesc());
            return resp;
        }
        String mrOid = sk.getMatchingRuleId();
        if (mrOid != null) {
            MatchingRule mr = at.getOrdering();
            if (mr != null && !mrOid.equals(mr.getOid())) {
                ldapResult.setDiagnosticMessage("Given matchingrule " + mrOid + " is not applicable for the attribute " + sk.getAttributeTypeDesc());
                resp.setSortResult(SortResultCode.INAPPROPRIATEMATCHING);
                resp.setAttributeName(sk.getAttributeTypeDesc());
                return resp;
            }
            try {
                schemaManager.lookupComparatorRegistry(mrOid);
            }
            catch (LdapException e) {
                ldapResult.setDiagnosticMessage("Given matchingrule " + mrOid + " is not supported");
                resp.setSortResult(SortResultCode.INAPPROPRIATEMATCHING);
                resp.setAttributeName(sk.getAttributeTypeDesc());
                return resp;
            }
        }
        MatchingRule mr = at.getOrdering();
        if (mr == null) {
            mr = at.getEquality();
        }
        ldapResult.setDiagnosticMessage("Matchingrule is required for sorting by the attribute " + sk.getAttributeTypeDesc());
        resp.setSortResult(SortResultCode.INAPPROPRIATEMATCHING);
        resp.setAttributeName(sk.getAttributeTypeDesc());
        if (mr == null) {
            return resp;
        }
        try {
            schemaManager.lookupComparatorRegistry(mr.getOid());
        }
        catch (LdapException e) {
            return resp;
        }
        resp.setSortResult(SortResultCode.SUCCESS);
        return resp;
    }

    private Cursor<Entry> sortResults(Cursor<Entry> unsortedEntries, SortRequest control, SchemaManager schemaManager) throws CursorException, LdapException, IOException {
        unsortedEntries.beforeFirst();
        Entry first = null;
        if (unsortedEntries.next()) {
            first = (Entry)unsortedEntries.get();
        }
        if (!unsortedEntries.next()) {
            unsortedEntries.beforeFirst();
            return unsortedEntries;
        }
        SortKey sk = (SortKey)control.getSortKeys().get(0);
        AttributeType at = schemaManager.getAttributeType(sk.getAttributeTypeDesc());
        SortedEntryComparator comparator = new SortedEntryComparator(at, sk.getMatchingRuleId(), sk.isReverseOrder(), schemaManager);
        SortedEntrySerializer keySerializer = new SortedEntrySerializer();
        SortedEntrySerializer.setSchemaManager(schemaManager);
        File file = File.createTempFile("replica", ".sorted-data");
        BaseRecordManager recMan = new BaseRecordManager(file.getAbsolutePath());
        BTree btree = new BTree((RecordManager)recMan, (Comparator)comparator, (Serializer)keySerializer, (Serializer)NullStringSerializer.INSTANCE);
        btree.insert((Object)first, (Object)"", false);
        btree.insert(unsortedEntries.get(), (Object)"", false);
        while (unsortedEntries.next()) {
            Entry entry = (Entry)unsortedEntries.get();
            btree.insert((Object)entry, (Object)"", false);
        }
        unsortedEntries.close();
        return new SortedEntryCursor((BTree<Entry, String>)btree, (RecordManager)recMan, file);
    }

    public boolean isPwdMustChange() {
        return this.pwdMustChange;
    }

    public void setPwdMustChange(boolean pwdMustChange) {
        this.pwdMustChange = pwdMustChange;
    }
}

