/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public abstract class BERCharacterString
extends BERElement {
    protected String m_value;
    private byte[] byte_buf;

    public BERCharacterString() {
        this.m_value = null;
    }

    public BERCharacterString(InputStream inputStream, int[] nArray) throws IOException {
        block3: {
            this.m_value = null;
            int n = BERElement.readLengthOctets(inputStream, nArray);
            if (n <= 0) break block3;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)inputStream.read();
                ++n2;
            }
            nArray[0] = nArray[0] + n;
            try {
                this.m_value = new String(byArray, "UTF8");
            }
            catch (Throwable throwable) {}
        }
    }

    public BERCharacterString(String string) {
        this.m_value = null;
        this.m_value = string;
    }

    public BERCharacterString(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        this.m_value = null;
        int n = BERElement.readLengthOctets(inputStream, nArray);
        int[] nArray2 = new int[1];
        BERElement bERElement = null;
        if (n == -1) {
            do {
                nArray2[0] = 0;
                bERElement = BERElement.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement == null) continue;
                BERCharacterString bERCharacterString = (BERCharacterString)bERElement;
                String string = bERCharacterString.getValue();
                this.m_value = this.m_value == null ? string : String.valueOf(this.m_value) + string;
            } while (bERElement != null);
        } else {
            nArray[0] = nArray[0] + n;
            while (n > 0) {
                nArray2[0] = 0;
                bERElement = BERElement.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement != null) {
                    BERCharacterString bERCharacterString = (BERCharacterString)bERElement;
                    String string = bERCharacterString.getValue();
                    this.m_value = this.m_value == null ? string : String.valueOf(this.m_value) + string;
                }
                n -= nArray2[0];
            }
        }
    }

    public BERCharacterString(byte[] byArray) {
        this.m_value = null;
        try {
            this.m_value = new String(byArray, "UTF8");
        }
        catch (Throwable throwable) {}
    }

    public abstract int getType();

    public String getValue() {
        return this.m_value;
    }

    public abstract String toString();

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        if (this.m_value == null) {
            BERElement.sendDefiniteLength(outputStream, 0);
        } else {
            try {
                this.byte_buf = this.m_value.getBytes("UTF8");
                BERElement.sendDefiniteLength(outputStream, this.byte_buf.length);
            }
            catch (Throwable throwable) {}
            outputStream.write(this.byte_buf, 0, this.byte_buf.length);
        }
    }
}

