/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class CompareRequestDecorator
extends SingleReplyRequestDecorator<CompareRequest>
implements CompareRequest {
    private byte[] attrIdBytes;
    private byte[] attrValBytes;
    private int compareRequestLength;
    private int avaLength;

    public CompareRequestDecorator(LdapApiService codec, CompareRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public Dn getName() {
        return ((CompareRequest)this.getDecorated()).getName();
    }

    public CompareRequest setName(Dn name) {
        ((CompareRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Value<?> getAssertionValue() {
        return ((CompareRequest)this.getDecorated()).getAssertionValue();
    }

    public CompareRequest setAssertionValue(String value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
        return this;
    }

    public CompareRequest setAssertionValue(byte[] value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
        return this;
    }

    public String getAttributeId() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    public CompareRequest setAttributeId(String attrId) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attrId);
        return this;
    }

    public CompareRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public CompareRequest addControl(Control control) {
        return (CompareRequest)super.addControl(control);
    }

    public CompareRequest addAllControls(Control[] controls) {
        return (CompareRequest)super.addAllControls(controls);
    }

    public CompareRequest removeControl(Control control) {
        return (CompareRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        Dn entry = this.getName();
        this.compareRequestLength = 1 + TLV.getNbBytes((int)Dn.getNbBytes((Dn)entry)) + Dn.getNbBytes((Dn)entry);
        this.attrIdBytes = Strings.getBytesUtf8((String)this.getAttributeId());
        this.avaLength = 1 + TLV.getNbBytes((int)this.attrIdBytes.length) + this.attrIdBytes.length;
        Value<?> assertionValue = this.getAssertionValue();
        if (assertionValue instanceof BinaryValue) {
            this.attrValBytes = this.getAssertionValue().getBytes();
            this.avaLength += 1 + TLV.getNbBytes((int)this.attrValBytes.length) + this.attrValBytes.length;
        } else {
            this.attrValBytes = Strings.getBytesUtf8((String)this.getAssertionValue().getString());
            this.avaLength += 1 + TLV.getNbBytes((int)this.attrValBytes.length) + this.attrValBytes.length;
        }
        this.compareRequestLength += 1 + TLV.getNbBytes((int)this.avaLength) + this.avaLength;
        return 1 + TLV.getNbBytes((int)this.compareRequestLength) + this.compareRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)110);
            buffer.put(TLV.getBytes((int)this.compareRequestLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])Dn.getBytes((Dn)this.getName()));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        BerValue.encode((ByteBuffer)buffer, (byte[])this.attrIdBytes);
        BerValue.encode((ByteBuffer)buffer, (byte[])this.attrValBytes);
        return buffer;
    }
}

