/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.rest;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.dataone.client.D1Node;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.auth.X509Session;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.DefaultHttpMultipartRestClient;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.types.v2.OptionList;
import org.dataone.service.util.BigIntegerMarshaller;
import org.dataone.service.util.D1Url;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.TypeMarshaller;

public abstract class MultipartD1Node
implements D1Node {
    protected static Log log = LogFactory.getLog(MultipartD1Node.class);
    protected MultipartRestClient defaultRestClient;
    protected MultipartRestClient latestRestClient;
    protected Session latestSession;
    private String nodeBaseServiceUrl;
    private NodeReference nodeId;
    protected Session defaultSession;
    protected NodeType nodeType;

    protected static void closeLoudly(InputStream is) throws ServiceFailure {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
            }
        }
    }

    protected MultipartRestClient getRestClient(Session sessionFromMethod) throws ServiceFailure {
        if (sessionFromMethod == null) {
            this.latestRestClient = this.defaultRestClient;
        } else if (sessionFromMethod instanceof X509Session && ((X509Session)sessionFromMethod).getMultipartRestClient() != null) {
            this.latestRestClient = ((X509Session)sessionFromMethod).getMultipartRestClient();
        } else if (sessionFromMethod instanceof AuthTokenSession && ((AuthTokenSession)sessionFromMethod).getMultipartRestClient() != null) {
            this.latestRestClient = ((AuthTokenSession)sessionFromMethod).getMultipartRestClient();
        } else {
            try {
                String subjectString = sessionFromMethod.getSubject() == null ? null : sessionFromMethod.getSubject().getValue();
                this.latestRestClient = new HttpMultipartRestClient(subjectString);
            }
            catch (IOException | ClientSideException e) {
                throw new ServiceFailure("0000", "Error creating MultipartRestClient for API Session parameter: " + e.getLocalizedMessage());
            }
        }
        if (this.latestRestClient.getSession() instanceof X509Session) {
            try {
                this.latestRestClient.getSession().checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                throw new ServiceFailure("0000", "Certificate is expired (or not yet valid): " + e.getLocalizedMessage());
            }
        }
        return this.latestRestClient;
    }

    protected MultipartD1Node(MultipartRestClient client, String nodeBaseServiceUrl, Session session) {
        this.setNodeBaseServiceUrl(nodeBaseServiceUrl);
        this.defaultRestClient = client;
        this.defaultSession = session;
        this.latestSession = session;
    }

    public MultipartD1Node(MultipartRestClient client, String nodeBaseServiceUrl) {
        this(client, nodeBaseServiceUrl, null);
    }

    public MultipartD1Node(Session session, String nodeBaseServiceUrl) {
        this(null, nodeBaseServiceUrl, session);
    }

    @Deprecated
    public MultipartD1Node(String nodeBaseServiceUrl) throws IOException, ClientSideException {
        this.setNodeBaseServiceUrl(nodeBaseServiceUrl);
        this.defaultRestClient = new DefaultHttpMultipartRestClient();
        this.defaultSession = null;
    }

    @Deprecated
    public MultipartD1Node() {
    }

    @Override
    public String getNodeBaseServiceUrl() {
        return this.nodeBaseServiceUrl;
    }

    public void setNodeBaseServiceUrl(String nodeBaseServiceUrl) {
        if (nodeBaseServiceUrl != null && !nodeBaseServiceUrl.endsWith("/")) {
            nodeBaseServiceUrl = nodeBaseServiceUrl + "/";
        }
        this.nodeBaseServiceUrl = nodeBaseServiceUrl;
    }

    @Override
    public NodeReference getNodeId() {
        return this.nodeId;
    }

    @Override
    public void setNodeId(NodeReference nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getLatestRequestUrl() {
        return this.latestRestClient.getLatestRequestUrl();
    }

    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "monitor/ping");
        Header[] headers = null;
        try {
            headers = this.getRestClient(this.defaultSession).doGetRequestForHeaders(url.getUrl(), null);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        Date date = null;
        for (Header header : headers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("header: %s = %s", header.getName(), header.getValue()));
            }
            if (!header.getName().equals("Date")) continue;
            date = DateTimeMarshaller.deserializeDateToUTC((String)header.getValue());
        }
        if (date == null) {
            throw new ServiceFailure("0000", "Could not get date information from response's 'Date' header.");
        }
        return date;
    }

    public InputStream get(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources {
        return this.get(this.defaultSession, pid);
    }

    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources {
        AutoCloseInputStream is = null;
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        try {
            url.addNextPathElement(pid.getValue());
        }
        catch (IllegalArgumentException e) {
            throw new NotFound("0000", "'pid' cannot be null nor empty");
        }
        InputStream remoteStream = null;
        try {
            remoteStream = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.get.timeout", null));
            is = new AutoCloseInputStream(remoteStream);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return is;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean systemMetadataChanged(Session session, Identifier pid, long serialVersion, Date dateSystemMetadataLastModified) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "dirtySystemMetadata");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (pid != null) {
            mpe.addParamPart("pid", pid.getValue());
        }
        mpe.addParamPart("dateSysMetaLastModified", DateTimeMarshaller.serializeDateToUTC((Date)dateSystemMetadataLastModified));
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.describe(this.defaultSession, pid);
    }

    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        BigInteger content_length;
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new NotFound("0000", "'pid' cannot be null nor empty");
        }
        url.addNextPathElement(pid.getValue());
        Header[] headers = null;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        try {
            for (Header header : headers = this.getRestClient(session).doHeadRequest(url.getUrl(), null)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("header: %s = %s", header.getName(), header.getValue()));
                }
                headersMap.put(header.getName(), header.getValue());
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        String objectFormatIdStr = (String)headersMap.get("DataONE-ObjectFormat");
        String last_modifiedStr = (String)headersMap.get("Last-Modified");
        String content_lengthStr = (String)headersMap.get("Content-Length");
        String checksumStr = (String)headersMap.get("DataONE-Checksum");
        String serialVersionStr = (String)headersMap.get("DataONE-SerialVersion");
        try {
            content_length = BigIntegerMarshaller.deserializeBigInteger((String)content_lengthStr);
        }
        catch (MarshallingException e) {
            throw new ServiceFailure("0", "Could not convert the returned content_length string (" + content_lengthStr + ") to a BigInteger: " + e.getMessage());
        }
        Date last_modified = null;
        try {
            if (last_modifiedStr != null) {
                last_modified = DateTimeMarshaller.deserializeDateToUTC((String)last_modifiedStr.trim());
            }
        }
        catch (NullPointerException e) {
            throw new ServiceFailure("0", "Could not parse the returned date string " + last_modifiedStr + ". The date string needs to be either ISO 8601 compliant or http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1 compliant: " + e.getMessage());
        }
        Checksum checksum = new Checksum();
        if (checksumStr != null) {
            String[] cs = checksumStr.split(",");
            checksum.setAlgorithm(cs[0]);
            if (cs.length > 1) {
                checksum.setValue(cs[1]);
            } else {
                throw new ServiceFailure("0", "malformed checksum header returned, checksum value not returned in the response");
            }
        }
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(objectFormatIdStr);
        BigInteger serialVersion = null;
        try {
            serialVersion = BigIntegerMarshaller.deserializeBigInteger((String)serialVersionStr);
        }
        catch (MarshallingException e) {
            throw new ServiceFailure("0", "Could not convert the returned serialVersion string (" + serialVersionStr + ") to a BigInteger: " + e.getMessage());
        }
        return new DescribeResponse(formatId, content_length, last_modified, checksum, serialVersion);
    }

    public Checksum getChecksum(Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.getChecksum(this.defaultSession, pid, checksumAlgorithm);
    }

    public Checksum getChecksum(Session session, Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        if (pid == null) {
            throw new NotFound("0000", "PID cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "checksum");
        url.addNextPathElement(pid.getValue());
        url.addNonEmptyParamPair("checksumAlgorithm", checksumAlgorithm);
        Checksum checksum = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            checksum = this.deserializeServiceType(Checksum.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return checksum;
    }

    public boolean isAuthorized(Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        return this.isAuthorized(this.defaultSession, pid, action);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAuthorized(Session session, Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "isAuthorized");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        if (action != null) {
            url.addNonEmptyParamPair("action", action.xmlValue());
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.generateIdentifier(this.defaultSession, scheme, fragment);
    }

    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "generate");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (scheme == null) {
            throw new InvalidRequest("0000", "'scheme' cannot be null");
        }
        smpe.addParamPart("scheme", scheme);
        if (fragment != null) {
            smpe.addParamPart("fragment", fragment);
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), smpe, null);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.archive(this.defaultSession, pid);
    }

    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "archive");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPutRequest(url.getUrl(), null, null);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.delete(this.defaultSession, pid);
    }

    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doDeleteRequest(url.getUrl(), null);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public InputStream query(Session session, String queryEngine, String encodedQuery) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "query");
        try {
            url.addNextPathElement(queryEngine);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequest("0000", "'queryEngine' parameter cannot be null or empty");
        }
        if (StringUtils.isEmpty((String)encodedQuery)) {
            throw new InvalidRequest("0000", "'encodedQuery' parameter cannot be null or empty");
        }
        String finalUrl = url.getUrl() + "/" + encodedQuery;
        AutoCloseInputStream is = null;
        try {
            is = new AutoCloseInputStream(this.getRestClient(session).doGetRequest(finalUrl, null));
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return is;
    }

    public QueryEngineDescription getQueryEngineDescription(Session session, String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "query");
        try {
            url.addNextPathElement(queryEngine);
        }
        catch (IllegalArgumentException e) {
            throw new NotFound("0000", "'queryEngine' cannot be null nor empty");
        }
        QueryEngineDescription description = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            description = this.deserializeServiceType(QueryEngineDescription.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return description;
    }

    public QueryEngineList listQueryEngines(Session session) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "query");
        InputStream is = null;
        QueryEngineList engines = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            engines = this.deserializeServiceType(QueryEngineList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return engines;
    }

    protected <T> T deserializeServiceType(Class<T> domainClass, InputStream is) throws ServiceFailure {
        try {
            return (T)TypeMarshaller.unmarshalTypeFromStream(domainClass, (InputStream)is);
        }
        catch (MarshallingException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
    }

    protected InputStream view(Session session, String theme, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "views");
        if (StringUtils.isBlank((String)theme)) {
            url.addNextPathElement("default");
        } else {
            url.addNextPathElement(theme);
        }
        if (id == null || StringUtils.isBlank((String)id.getValue())) {
            throw new NotFound("0000", "'pid' cannot be null nor empty");
        }
        url.addNextPathElement(id.getValue());
        InputStream remoteStream = null;
        try {
            remoteStream = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.get.timeout", null));
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return new AutoCloseInputStream(remoteStream);
    }

    protected OptionList listViews(Session session) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        if (session == null) {
            session = this.defaultSession;
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "views");
        OptionList optionList = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.get.timeout", null));
            optionList = this.deserializeServiceType(OptionList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return optionList;
    }
}

