/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.impl.MultipartD1Node;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedMetadataType;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.ChecksumAlgorithmList;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.types.v2.OptionList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.D1Url;

public class MultipartCNode
extends MultipartD1Node
implements CNode {
    protected static Log log = LogFactory.getLog(MultipartCNode.class);
    private Integer nodelistRefreshIntervalSeconds = 120;

    @Deprecated
    public MultipartCNode(String nodeBaseServiceUrl) throws IOException, ClientSideException {
        super(nodeBaseServiceUrl);
        this.nodeType = NodeType.CN;
        this.nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    }

    public MultipartCNode(MultipartRestClient mrc, String nodeBaseServiceUrl) {
        super(mrc, nodeBaseServiceUrl);
        this.nodeType = NodeType.CN;
        this.nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    }

    public MultipartCNode(MultipartRestClient mrc, String nodeBaseServiceUrl, Session session) {
        super(mrc, nodeBaseServiceUrl, session);
        this.nodeType = NodeType.CN;
        this.nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    }

    @Override
    public String getNodeBaseServiceUrl() {
        D1Url url = new D1Url(super.getNodeBaseServiceUrl());
        url.addNextPathElement("v2");
        return url.getUrl();
    }

    public ObjectFormatList listFormats() throws ServiceFailure, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        ObjectFormatList formatList = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            formatList = this.deserializeServiceType(ObjectFormatList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return formatList;
    }

    public ObjectFormatIdentifier addFormat(Session session, ObjectFormatIdentifier formatid, ObjectFormat format) throws ServiceFailure, NotFound, NotImplemented, InvalidRequest, NotAuthorized, InvalidToken {
        if (formatid == null || StringUtils.isBlank((String)formatid.getValue())) {
            throw new NotFound("0000", "'formatid' cannot be null nor empty");
        }
        if (format == null) {
            throw new ServiceFailure("0000", "'format' cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        url.addNextPathElement(formatid.getValue());
        ObjectFormatIdentifier formatID = null;
        try {
            SimpleMultipartEntity mpe = new SimpleMultipartEntity();
            mpe.addFilePart("format", (Object)format);
            InputStream is = this.getRestClient(this.defaultSession).doPostRequest(url.getUrl(), mpe, null);
            formatID = this.deserializeServiceType(ObjectFormatIdentifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (MarshallingException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IOException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return formatID;
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier formatid) throws ServiceFailure, NotFound, NotImplemented {
        ObjectFormat objectFormat = null;
        boolean useObjectFormatCache = false;
        useObjectFormatCache = Settings.getConfiguration().getBoolean("CNode.useObjectFormatCache", useObjectFormatCache);
        if (useObjectFormatCache) {
            try {
                objectFormat = ObjectFormatCache.getInstance().getFormat(formatid);
            }
            catch (BaseException be) {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
            }
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        url.addNextPathElement(formatid.getValue());
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            objectFormat = this.deserializeServiceType(ObjectFormat.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return objectFormat;
    }

    public ObjectList listObjects(Session session, Date fromDate, Date toDate, ObjectFormatIdentifier formatid, NodeReference nodeId, Identifier identifier, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        if (toDate != null && fromDate != null && !toDate.after(fromDate)) {
            throw new InvalidRequest("1000", "fromDate must be before toDate in listObjects() call. " + fromDate + " " + toDate);
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (formatid != null) {
            url.addNonEmptyParamPair("formatId", formatid.getValue());
        }
        if (nodeId != null) {
            url.addNonEmptyParamPair("nodeId", nodeId.getValue());
        }
        if (identifier != null) {
            url.addNonEmptyParamPair("identifier", identifier.getValue());
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        ObjectList objectList = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return objectList;
    }

    public ChecksumAlgorithmList listChecksumAlgorithms() throws ServiceFailure, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "checksum");
        ChecksumAlgorithmList algorithmList = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            algorithmList = this.deserializeServiceType(ChecksumAlgorithmList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return algorithmList;
    }

    public org.dataone.service.types.v2.Log getLogRecords(Session session, Date fromDate, Date toDate, String event, String idFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "log");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (event != null) {
            url.addNonEmptyParamPair("event", event);
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        url.addNonEmptyParamPair("idFilter", idFilter);
        org.dataone.service.types.v2.Log log = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.getLogRecords.timeout", null));
            log = this.deserializeServiceType(org.dataone.service.types.v2.Log.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return log;
    }

    @Override
    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        return super.getCapabilities();
    }

    public NodeList listNodes() throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        NodeList nodelist = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            nodelist = this.deserializeServiceType(NodeList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return nodelist;
    }

    public Node getNodeCapabilities(NodeReference nodeRef) throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        url.addNextPathElement(nodeRef.getValue());
        Node node = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            node = this.deserializeServiceType(Node.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return node;
    }

    public Identifier reserveIdentifier(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "reserve");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (pid == null) {
            throw new InvalidRequest("0000", "PID cannot be null");
        }
        smpe.addParamPart("pid", pid.getValue());
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), smpe, Settings.getConfiguration().getInteger("D1Client.CNode.reserveIdentifier.timeout", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasReservation(Session session, Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, InvalidRequest, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "reserve");
        try {
            if (subject != null) {
                url.addNonEmptyParamPair("subject", subject.getValue());
            }
            if (pid != null) {
                url.addNextPathElement(pid.getValue());
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid == null) {
            throw new InvalidRequest("0000", "PID cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            if (object == null) {
                mpe.addFilePart("object", "");
            } else {
                mpe.addFilePart("object", object);
            }
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        catch (MarshallingException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.create.timeouts", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    @Override
    public boolean updateSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        return super.updateSystemMetadata(session, pid, sysmeta);
    }

    public Identifier registerSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.registerSystemMetadata.timeouts", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean synchronize(Session session, Identifier pid) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "synchronize");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("pid", pid.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.registerSystemMetadata.timeouts", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidSystemMetadata) {
                    throw (InvalidSystemMetadata)be;
                }
                if (!(be instanceof InvalidToken)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidToken)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setObsoletedBy(Session session, Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "obsoletedBy");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (obsoletedByPid != null) {
            mpe.addParamPart("obsoletedByPid", obsoletedByPid.getValue());
        }
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    @Override
    public SystemMetadata getSystemMetadata(Session session, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.getSystemMetadata(session, id);
    }

    public ObjectLocationList resolve(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "resolve");
        if (pid == null) {
            throw new NotFound("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        ObjectLocationList oll = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null, false);
            oll = this.deserializeServiceType(ObjectLocationList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return oll;
    }

    @Override
    public InputStream get(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        try {
            return super.get(pid);
        }
        catch (InsufficientResources e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        try {
            return super.get(session, pid);
        }
        catch (InsufficientResources e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
    }

    public Checksum getChecksum(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Checksum cs = null;
        try {
            cs = super.getChecksum(session, pid, null);
        }
        catch (InvalidRequest e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return cs;
    }

    public ObjectList search(String queryType, D1Url queryD1url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.search(this.defaultSession, queryType, queryD1url);
    }

    public ObjectList search(Session session, String queryType, D1Url queryD1url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        String pathAndQueryString = queryD1url.getUrl();
        return this.search(session, queryType, pathAndQueryString);
    }

    public ObjectList search(Session session, String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "search");
        url.addNextPathElement(queryType);
        String finalUrl = url.getUrl() + "/select" + query;
        ObjectList objectList = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(finalUrl, null);
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return objectList;
    }

    public Identifier setRightsHolder(Session session, Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "owner");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (userId == null) {
            throw new InvalidRequest("0000", "parameter 'userId' cannot be null");
        }
        mpe.addParamPart("userId", userId.getValue());
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setAccessPolicy(Session session, Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accessRules");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("accessPolicy", (Object)accessPolicy);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Subject registerAccount(Session session, Person person) throws ServiceFailure, NotAuthorized, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("person", (Object)person);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Subject subject = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InvalidCredentials) {
                throw (InvalidCredentials)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subject;
    }

    public Subject updateAccount(Session session, Person person) throws ServiceFailure, NotAuthorized, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken, NotFound {
        if (person.getSubject() == null) {
            throw new NotFound("0000", "'person.subject' cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        url.addNextPathElement(person.getSubject().getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("person", (Object)person);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Subject subject = null;
        try {
            InputStream is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidCredentials) {
                throw (InvalidCredentials)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subject;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyAccount(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/verification");
        if (subject == null) {
            throw new InvalidRequest("0000", "'subject' cannot be null");
        }
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), null, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public SubjectInfo getSubjectInfo(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        if (subject == null) {
            throw new NotFound("0000", "'subject' cannot be null");
        }
        url.addNextPathElement(subject.getValue());
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    public SubjectInfo listSubjects(Session session, String query, String status, Integer start, Integer count) throws InvalidRequest, ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        url.addNonEmptyParamPair("query", query);
        url.addNonEmptyParamPair("status", status);
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mapIdentity(Session session, Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/map");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (primarySubject != null) {
            mpe.addParamPart("primarySubject", primarySubject.getValue());
        }
        if (secondarySubject != null) {
            mpe.addParamPart("secondarySubject", secondarySubject.getValue());
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof IdentifierNotUnique)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (IdentifierNotUnique)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("subject", subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof IdentifierNotUnique)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (IdentifierNotUnique)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public SubjectInfo getPendingMapIdentity(Session session, Subject subject) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean confirmMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), null, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean denyMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doDeleteRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/map");
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doDeleteRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Subject createGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "groups");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("group", (Object)group);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Subject subject = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subject;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "groups");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("group", (Object)group);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateNodeCapabilities(Session session, NodeReference nodeid, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, NotFound, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        if (nodeid != null) {
            url.addNextPathElement(nodeid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("node", (Object)node);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof NotFound)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotFound)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public NodeReference register(Session session, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, IdentifierNotUnique, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("node", (Object)node);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        NodeReference nodeRef = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
            nodeRef = this.deserializeServiceType(NodeReference.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return nodeRef;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReplicationStatus(Session session, Identifier pid, NodeReference nodeRef, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaNotifications");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("nodeRef", nodeRef.getValue());
        mpe.addParamPart("status", status.xmlValue());
        try {
            if (failure != null) {
                mpe.addFilePart("failure", failure.serialize(0));
            }
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof NotFound)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotFound)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReplicationPolicy(Session session, Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaPolicies");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("policy", (Object)policy);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNodeAuthorized(Session session, Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaAuthorizations");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        if (targetNodeSubject != null) {
            url.addNonEmptyParamPair("targetNodeSubject", targetNodeSubject.getValue());
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateReplicationMetadata(Session session, Identifier pid, Replica replicaMetadata, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaMetadata");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("replicaMetadata", (Object)replicaMetadata);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteReplicationMetadata(Session session, Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "removeReplicaMetadata");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (nodeId != null) {
            mpe.addParamPart("nodeId", nodeId.getValue());
        }
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    @Override
    public InputStream view(Session session, String theme, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return super.view(session, theme, id);
    }

    public OptionList listViews() throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return super.listViews(null);
    }

    public SubjectInfo echoCredentials(Session session) throws NotImplemented, ServiceFailure, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "diag/subject");
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    public SystemMetadata echoSystemMetadata(Session session, SystemMetadata sysmeta) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidToken, InvalidRequest, IdentifierNotUnique, InvalidSystemMetadata {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "diag/sysmeta");
        SystemMetadata echoedSysmeta = null;
        try {
            SimpleMultipartEntity mpe = new SimpleMultipartEntity();
            mpe.addFilePart("sysmeta", (Object)sysmeta);
            InputStream is = this.getRestClient(this.defaultSession).doPostRequest(url.getUrl(), mpe, null);
            echoedSysmeta = this.deserializeServiceType(SystemMetadata.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (MarshallingException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IOException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return echoedSysmeta;
    }

    public InputStream echoIndexedObject(Session session, String queryEngine, SystemMetadata sysmeta, InputStream object) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidToken, InvalidRequest, InvalidSystemMetadata, UnsupportedType, UnsupportedMetadataType, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "diag/object");
        InputStream echoedObject = null;
        try {
            SimpleMultipartEntity mpe = new SimpleMultipartEntity();
            mpe.addParamPart("queryEngine", queryEngine);
            mpe.addFilePart("sysmeta", (Object)sysmeta);
            if (object == null) {
                mpe.addFilePart("object", "");
            } else {
                mpe.addFilePart("object", object);
            }
            echoedObject = this.getRestClient(this.defaultSession).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            if (be instanceof UnsupportedMetadataType) {
                throw (UnsupportedMetadataType)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (MarshallingException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IOException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return echoedObject;
    }
}

