/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.impl;

import java.io.IOException;
import java.io.InputStream;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.D1Url;

public abstract class MultipartD1Node
extends org.dataone.client.rest.MultipartD1Node {
    public MultipartD1Node(MultipartRestClient client, String nodeBaseServiceUrl, Session session) {
        super(client, nodeBaseServiceUrl, session);
    }

    public MultipartD1Node(MultipartRestClient client, String nodeBaseServiceUrl) {
        super(client, nodeBaseServiceUrl, null);
    }

    @Deprecated
    public MultipartD1Node(String nodeBaseServiceUrl) throws IOException, ClientSideException {
        super(nodeBaseServiceUrl);
    }

    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(super.getNodeBaseServiceUrl(), "");
        Node node = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            node = this.deserializeServiceType(Node.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return node;
    }

    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        InputStream is = null;
        SystemMetadata sysmeta = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.getSystemMetadata.timeout", null));
            sysmeta = this.deserializeServiceType(SystemMetadata.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return sysmeta;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (MarshallingException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.registerSystemMetadata.timeouts", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidSystemMetadata) {
                    throw (InvalidSystemMetadata)be;
                }
                if (!(be instanceof InvalidToken)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidToken)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }
}

