/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ;

import java.net.InetAddress;
import java.util.Hashtable;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPConnection;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIntegrationUtils
extends IntegrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServerIntegrationUtils.class);
    private static final String CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final int DEFAULT_PORT = 10389;
    private static final String DEFAULT_ADMIN = "uid=admin,ou=system";
    private static final String DEFAULT_PASSWORD = "secret";

    public static LdapContext getWiredContext(LdapServer ldapServer) throws Exception {
        return ServerIntegrationUtils.getWiredContext(ldapServer, null);
    }

    public static LdapContext getWiredContext(LdapServer ldapServer, String principalDn, String password) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + InetAddress.getLocalHost().getHostName() + ":" + ldapServer.getPort());
        env.put("java.naming.security.principal", principalDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContext(LdapServer ldapServer, Control[] controls) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + InetAddress.getLocalHost().getHostName() + ":" + ldapServer.getPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, JndiUtils.toJndiControls((LdapApiService)ldapServer.getDirectoryService().getLdapCodecService(), (Control[])controls));
    }

    public static LdapContext getWiredContextThrowOnRefferal(LdapServer ldapServer) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + InetAddress.getLocalHost().getHostName() + ":" + ldapServer.getPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "throw");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContextRefferalIgnore(LdapServer ldapServer) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + InetAddress.getLocalHost().getHostName() + ":" + ldapServer.getPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "ignore");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContextFollowOnRefferal(LdapServer ldapServer) throws Exception {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://" + InetAddress.getLocalHost().getHostName() + ":" + ldapServer.getPort());
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.referral", "follow");
        return new InitialLdapContext(env, null);
    }

    public static LdapConnection getWiredConnection(LdapServer ldapServer) throws Exception {
        String testServer = System.getProperty("ldap.test.server", null);
        if (testServer == null) {
            return ServerIntegrationUtils.getWiredConnection(ldapServer, DEFAULT_ADMIN, DEFAULT_PASSWORD);
        }
        LOG.debug("ldap.test.server = " + testServer);
        String admin = System.getProperty(testServer + ".admin", DEFAULT_ADMIN);
        LOG.debug(testServer + ".admin = " + admin);
        String password = System.getProperty(testServer + ".password", DEFAULT_PASSWORD);
        LOG.debug(testServer + ".password = " + password);
        String host = System.getProperty(testServer + ".host", InetAddress.getLocalHost().getHostName());
        LOG.debug(testServer + ".host = " + host);
        int port = Integer.parseInt(System.getProperty(testServer + ".port", Integer.toString(10389)));
        LOG.debug(testServer + ".port = " + port);
        LdapNetworkConnection conn = new LdapNetworkConnection(host, port);
        conn.bind(admin, password);
        return conn;
    }

    public static LDAPConnection getNsdkWiredConnection(LdapServer ldapServer) throws Exception {
        String testServer = System.getProperty("ldap.test.server", null);
        if (testServer == null) {
            return ServerIntegrationUtils.getNsdkWiredConnection(ldapServer, DEFAULT_ADMIN, DEFAULT_PASSWORD);
        }
        LOG.debug("ldap.test.server = " + testServer);
        String admin = System.getProperty(testServer + ".admin", DEFAULT_ADMIN);
        LOG.debug(testServer + ".admin = " + admin);
        String password = System.getProperty(testServer + ".password", DEFAULT_PASSWORD);
        LOG.debug(testServer + ".password = " + password);
        String host = System.getProperty(testServer + ".host", InetAddress.getLocalHost().getHostName());
        LOG.debug(testServer + ".host = " + host);
        int port = Integer.parseInt(System.getProperty(testServer + ".port", Integer.toString(10389)));
        LOG.debug(testServer + ".port = " + port);
        LDAPConnection conn = new LDAPConnection();
        conn.connect(3, host, port, admin, password);
        return conn;
    }

    public static LdapConnection getWiredConnection(LdapServer ldapServer, String principalDn, String password) throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection(InetAddress.getLocalHost().getHostName(), ldapServer.getPort());
        connection.bind(principalDn, password);
        return connection;
    }

    public static LdapConnection getLdapConnection(LdapServer ldapServer) throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection(InetAddress.getLocalHost().getHostName(), ldapServer.getPort());
        return connection;
    }

    public static LDAPConnection getNsdkWiredConnection(LdapServer ldapServer, String principalDn, String password) throws Exception {
        LDAPConnection connection = new LDAPConnection();
        connection.connect(3, InetAddress.getLocalHost().getHostName(), ldapServer.getPort(), principalDn, password);
        return connection;
    }

    public static LdapConnection getAdminConnection(LdapServer ldapServer) throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection(InetAddress.getLocalHost().getHostName(), ldapServer.getPort());
        connection.bind(DEFAULT_ADMIN, DEFAULT_PASSWORD);
        return connection;
    }
}

