/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.knownhost;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.maven.wagon.providers.ssh.knownhost.StreamKnownHostsProvider;
import org.codehaus.plexus.util.FileUtils;

public class FileKnownHostsProvider
extends StreamKnownHostsProvider {
    private final File file;

    public FileKnownHostsProvider(File file) throws IOException {
        super(file.exists() ? new FileInputStream(file) : new ByteArrayInputStream("".getBytes()));
        this.file = file;
    }

    public FileKnownHostsProvider() throws IOException {
        this(new File(System.getProperty("user.home"), ".ssh/known_hosts"));
    }

    public void storeKnownHosts(String contents) throws IOException {
        this.file.getParentFile().mkdirs();
        FileUtils.fileWrite((String)this.file.getAbsolutePath(), (String)contents);
    }

    public File getFile() {
        return this.file;
    }
}

