/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.portal;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.loader.ClientEnvironmentUtil;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Handler;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.configuration.Settings;
import org.dataone.portal.TokenGenerator;
import org.dataone.service.types.v1.Session;

public class PortalCertificateManager {
    private static final String DEFAULT_OA4MP_CONFIG_PATH = "/var/lib/tomcat7/webapps/portal/WEB-INF/client.xml";
    private String configFile = Settings.getConfiguration().getString("oa4mp.client.config.file", "/var/lib/tomcat7/webapps/portal/WEB-INF/client.xml");
    private String configName = null;
    private static int maxAttempts = 10;
    private static PortalCertificateManager instance;
    public static Log log;

    public static PortalCertificateManager getInstance() {
        if (instance == null) {
            instance = new PortalCertificateManager();
        }
        return instance;
    }

    public PortalCertificateManager() {
    }

    public PortalCertificateManager(String configFile) {
        this.configFile = configFile;
    }

    public void closeLoggers() throws Exception {
        Handler[] handlers;
        ClientEnvironment ce = ClientEnvironmentUtil.load((File)new File(this.configFile), (String)this.configName);
        for (Handler h : handlers = ce.getMyLogger().getLogger().getHandlers()) {
            h.close();
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setCookie(String identifier, HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie("oa4mp_client_req_id", identifier);
        cookie.setMaxAge(64800);
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
    }

    public Cookie getCookie(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getCookies() != null) {
            for (Cookie cookie : httpServletRequest.getCookies()) {
                if (!cookie.getName().equals("oa4mp_client_req_id")) continue;
                return cookie;
            }
        }
        return null;
    }

    public void removeCookie(HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie("oa4mp_client_req_id", "removeMe");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
    }

    public X509Certificate getCertificate(HttpServletRequest request) throws Exception {
        Asset credential = this.getCredentials(request);
        if (credential == null || credential.getCertificates() == null || credential.getCertificates().length < 1) {
            return null;
        }
        return credential.getCertificates()[0];
    }

    public PrivateKey getPrivateKey(HttpServletRequest request) throws Exception {
        Asset credential = this.getCredentials(request);
        if (credential == null) {
            return null;
        }
        return credential.getPrivateKey();
    }

    public Asset getCredentials(String identifier) throws Exception {
        if (identifier != null) {
            ClientEnvironment ce = ClientEnvironmentUtil.load((File)new File(this.configFile), (String)this.configName);
            Asset asset = null;
            int attempts = 0;
            while (asset == null) {
                try {
                    asset = ce.getAssetStore().get(identifier);
                }
                catch (Exception e) {
                    log.warn((Object)(attempts + " - Error getting transaction, trying again. " + e.getMessage()));
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)("Could not wait for credentials: " + ie.getMessage()));
                        throw e;
                    }
                    if (++attempts <= maxAttempts) continue;
                    throw e;
                }
            }
            return asset;
        }
        return null;
    }

    public Asset getCredentials(HttpServletRequest request) throws Exception {
        Cookie[] cookies = request.getCookies();
        String identifier = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("oa4mp_client_req_id")) continue;
                identifier = cookie.getValue();
                return this.getCredentials(identifier);
            }
        }
        return null;
    }

    public Session putPortalCertificateOnRequest(HttpServletRequest request) throws Exception {
        Session session = CertificateManager.getInstance().getSession(request);
        if (session == null) {
            X509Certificate certificate = PortalCertificateManager.getInstance().getCertificate(request);
            log.debug((Object)("Proxy certificate for the request = " + certificate));
            if (certificate != null) {
                X509Certificate[] x509Certificates = new X509Certificate[]{certificate};
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)x509Certificates);
                log.debug((Object)"Added proxy certificate to the request");
            }
            session = CertificateManager.getInstance().getSession(request);
        }
        return session;
    }

    public void registerPortalCertificateWithCertificateManger(HttpServletRequest request) throws Exception {
        X509Certificate certificate = PortalCertificateManager.getInstance().getCertificate(request);
        if (certificate != null) {
            PrivateKey key = PortalCertificateManager.getInstance().getPrivateKey(request);
            String subjectName = CertificateManager.getInstance().getSubjectDN(certificate);
            if (subjectName != null && key != null && certificate != null) {
                CertificateManager.getInstance().registerCertificate(subjectName, certificate, key);
            }
        }
    }

    public Session registerPortalCertificateAndPlaceOnRequest(HttpServletRequest request) throws Exception {
        Session session = CertificateManager.getInstance().getSession(request);
        if (session == null) {
            PortalCertificateManager.getInstance().putPortalCertificateOnRequest(request);
            PortalCertificateManager.getInstance().registerPortalCertificateWithCertificateManger(request);
            session = CertificateManager.getInstance().getSession(request);
        }
        return session;
    }

    public Session getSession(HttpServletRequest request) {
        String token;
        Session session = null;
        try {
            session = CertificateManager.getInstance().getSession(request);
        }
        catch (Exception e) {
            log.warn((Object)("For request " + request + ":" + e.getMessage()), (Throwable)e);
        }
        if (session == null && (token = request.getHeader("Authorization")) != null) {
            try {
                token = token.split(" ")[1];
                session = TokenGenerator.getInstance().getSession(token);
            }
            catch (IndexOutOfBoundsException e) {
                log.warn((Object)("For request " + request + ": Could not extract a valid token from the request's Authorization header ('" + token + "') in order to set the Session. Continuing..."));
            }
            catch (Exception e) {
                log.warn((Object)("For request " + request + ":" + e.getMessage()), (Throwable)e);
            }
        }
        if (session == null) {
            try {
                session = this.registerPortalCertificateAndPlaceOnRequest(request);
            }
            catch (Exception e) {
                log.warn((Object)("For request " + request + ":" + e.getMessage()), (Throwable)e);
            }
        }
        return session;
    }

    static {
        log = LogFactory.getLog(PortalCertificateManager.class);
    }
}

