/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SyncRequestValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SyncRequestValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;

public class SyncRequestValueDecorator
extends ControlDecorator<SyncRequestValue>
implements SyncRequestValue {
    private int syncRequestValueLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public SyncRequestValueDecorator(LdapApiService codec) {
        super(codec, (Control)new SyncRequestValueImpl());
    }

    public SyncRequestValueDecorator(LdapApiService codec, SyncRequestValue control) {
        super(codec, (Control)control);
    }

    public SynchronizationModeEnum getMode() {
        return ((SyncRequestValue)this.getDecorated()).getMode();
    }

    public void setMode(SynchronizationModeEnum mode) {
        ((SyncRequestValue)this.getDecorated()).setMode(mode);
    }

    public byte[] getCookie() {
        return ((SyncRequestValue)this.getDecorated()).getCookie();
    }

    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty((byte[])cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((SyncRequestValue)this.getDecorated()).setCookie(copy);
        } else {
            ((SyncRequestValue)this.getDecorated()).setCookie(null);
        }
    }

    public boolean isReloadHint() {
        return ((SyncRequestValue)this.getDecorated()).isReloadHint();
    }

    public void setReloadHint(boolean reloadHint) {
        ((SyncRequestValue)this.getDecorated()).setReloadHint(reloadHint);
    }

    public int computeLength() {
        this.syncRequestValueLength = 3;
        if (this.getCookie() != null) {
            this.syncRequestValueLength += 1 + TLV.getNbBytes((int)this.getCookie().length) + this.getCookie().length;
        }
        if (this.isReloadHint()) {
            this.syncRequestValueLength += 3;
        }
        this.valueLength = 1 + TLV.getNbBytes((int)this.syncRequestValueLength) + this.syncRequestValueLength;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.syncRequestValueLength));
        buffer.put(UniversalTag.ENUMERATED.getValue());
        buffer.put((byte)1);
        buffer.put(BerValue.getBytes((int)this.getMode().getValue()));
        if (this.getCookie() != null) {
            BerValue.encode((ByteBuffer)buffer, (byte[])this.getCookie());
        }
        if (this.isReloadHint()) {
            BerValue.encode((ByteBuffer)buffer, (boolean)this.isReloadHint());
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)this.syncRequestValueLength));
                buffer.put(UniversalTag.ENUMERATED.getValue());
                buffer.put((byte)1);
                buffer.put(BerValue.getBytes((int)this.getMode().getValue()));
                if (this.getCookie() != null) {
                    BerValue.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                }
                if (this.isReloadHint()) {
                    BerValue.encode((ByteBuffer)buffer, (boolean)this.isReloadHint());
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncRequestValueContainer container = new SyncRequestValueContainer(this);
        DECODER.decode(bb, (Asn1Container)container);
        return this;
    }
}

