/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.io.File;
import java.net.URL;
import java.util.UUID;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService {
    private static final String DIRECTORY_CACHESERVICE_XML = "directory-cacheservice.xml";
    private static final Logger LOG = LoggerFactory.getLogger(CacheService.class);
    private CacheManager cacheManager;
    private boolean initialized;

    public CacheService() {
    }

    public CacheService(CacheManager cachemanager) {
        this.cacheManager = cachemanager;
        if (cachemanager != null) {
            this.initialized = true;
        }
    }

    public void initialize(InstanceLayout layout) {
        this.initialize(layout, null);
    }

    public void initialize(InstanceLayout layout, String instanceId) {
        Configuration cc;
        if (this.initialized) {
            LOG.debug("CacheService was already initialized, returning");
            return;
        }
        LOG.debug("CacheService initialization, for instance {}", (Object)instanceId);
        if (this.cacheManager != null && this.cacheManager.getStatus() == Status.STATUS_ALIVE) {
            LOG.warn("cache service was already initialized and is alive");
            this.initialized = true;
            return;
        }
        String cachePath = null;
        if (layout != null) {
            File configFile = new File(layout.getConfDirectory(), DIRECTORY_CACHESERVICE_XML);
            if (!configFile.exists()) {
                LOG.info("no custom cache configuration was set, loading the default cache configuration");
                cc = ConfigurationFactory.parseConfiguration((URL)this.getClass().getClassLoader().getResource(DIRECTORY_CACHESERVICE_XML));
            } else {
                LOG.info("loading cache configuration from the file {}", (Object)configFile);
                cc = ConfigurationFactory.parseConfiguration((File)configFile);
            }
            cachePath = layout.getCacheDirectory().getAbsolutePath();
        } else {
            LOG.info("no custom cache configuration was set, loading the default cache configuration");
            cc = ConfigurationFactory.parseConfiguration((URL)this.getClass().getClassLoader().getResource(DIRECTORY_CACHESERVICE_XML));
            cachePath = FileUtils.getTempDirectoryPath();
        }
        String confName = UUID.randomUUID().toString();
        cc.setName(confName);
        if (cachePath == null) {
            cachePath = FileUtils.getTempDirectoryPath();
        }
        cachePath = cachePath + File.separator + confName;
        cc.getDiskStoreConfiguration().setPath(cachePath);
        this.cacheManager = new CacheManager(cc);
        this.initialized = true;
    }

    public void destroy() {
        if (!this.initialized) {
            return;
        }
        LOG.info("clearing all the caches");
        this.initialized = false;
        this.cacheManager.clearAll();
        this.cacheManager.shutdown();
    }

    public Cache getCache(String name) {
        if (!this.initialized) {
            LOG.error("Cannot fetch the cache named {}, the CacheServcie is not initialized", (Object)name);
            throw new IllegalStateException("CacheService was not initialized");
        }
        LOG.info("fetching the cache named {}", (Object)name);
        Cache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            LOG.info("No cache with name {} exists, creating one", (Object)name);
            this.cacheManager.addCache(name);
            cache = this.cacheManager.getCache(name);
        }
        return cache;
    }

    public void remove(String name) {
        if (this.cacheManager.cacheExists(name)) {
            LOG.info("Removing the cache named {}", (Object)name);
            this.cacheManager.removeCache(name);
        } else {
            LOG.info("Cannot removing the cache named {}, it does not exist", (Object)name);
        }
    }
}

