/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.util.cli.CLIReflectionUtil;
import edu.uiuc.ncsa.security.util.cli.CommandLineTokenizer;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.ExitException;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.cli.MalformedCommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;

public class CLIDriver {
    public static final String EXIT_COMMAND = "/exit";
    public static final int OK_RC = 0;
    public static final int ABNORMAL_RC = -1;
    public static final int USER_EXIT_RC = 10;
    public static final int SHUTDOWN_RC = -10;
    public static final int HELP_RC = 100;
    private Commands[] commands;
    CommandLineTokenizer CLT = new CommandLineTokenizer();
    boolean isDone = false;
    boolean debug = false;
    BufferedReader bufferedReader;

    public CLIDriver(Commands ... cci) {
        this.setCLICommands(cci);
    }

    public Commands[] getCLICommands() {
        return this.commands;
    }

    protected void setCLICommands(Commands[] commands) {
        this.commands = commands;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    public BufferedReader getBufferedReader() {
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.bufferedReader;
    }

    protected String readline() throws IOException {
        return this.getBufferedReader().readLine();
    }

    public void start() {
        String prompt = this.commands[0].getPrompt();
        block8: while (!this.isDone) {
            try {
                this.say2(prompt);
                String cmdLine = this.readline();
                switch (this.execute(cmdLine)) {
                    case 100: {
                        this.listCLIMethods();
                        continue block8;
                    }
                    case -10: {
                        this.isDone = false;
                        this.quit(null);
                        return;
                    }
                    case 10: {
                        this.say("User exit encountered");
                        continue block8;
                    }
                    case 0: {
                        continue block8;
                    }
                }
                this.say("Command not found/understood. Try typing help or exit.");
                this.listCLIMethods();
            }
            catch (Throwable ioe) {
                if (this.debug) {
                    ioe.printStackTrace();
                }
                this.say("Internal error reading line:/n" + ioe.getMessage());
            }
        }
    }

    protected int execute(String cmdLine) {
        try {
            Vector cmdV = this.CLT.tokenize(cmdLine);
            if (cmdV.size() > 0) {
                String cmdS = (String)cmdV.elementAt(0);
                if (cmdS.toLowerCase().equals("exit") || cmdS.toLowerCase().equals("quit")) {
                    return -10;
                }
                if (cmdS.toLowerCase().equals("help")) {
                    return 100;
                }
                InputLine cliAV = new InputLine(cmdV);
                for (int i = 0; i < this.getCLICommands().length; ++i) {
                    try {
                        CLIReflectionUtil.invokeMethod(this.commands[i], cmdS, cliAV);
                        return 0;
                    }
                    catch (InvocationTargetException itx) {
                        if (this.debug) {
                            itx.printStackTrace();
                        }
                        if (itx.getTargetException() != null && itx.getTargetException() instanceof ExitException) {
                            return 10;
                        }
                        if (itx.getCause() != null) {
                            this.say("Exception. The cause is: " + itx.getCause().getMessage());
                            continue;
                        }
                        this.say("Invocation target exception encountered:" + itx.getTargetException());
                        continue;
                    }
                    catch (Exception nsmx) {
                        if (!this.debug) continue;
                        this.say(" Could not execute command. Message:" + nsmx.getMessage());
                        nsmx.printStackTrace();
                    }
                }
            }
        }
        catch (MalformedCommandException mcx) {
            this.say("  >>Couldn't parse the command");
        }
        return -1;
    }

    protected void listCLIMethods() {
        this.say("Here are the commands available:");
        String[] tempCCIN = CLIReflectionUtil.getCommandsNameList(this.getCLICommands());
        for (int i = 0; i < tempCCIN.length; ++i) {
            this.say(tempCCIN[i]);
        }
        this.say("To get more information on a command type\n");
        this.say("command --help");
    }

    public void quit(InputLine inputLine) {
        this.shutdown();
    }

    protected void shutdown() {
        this.say("exiting ...");
    }

    protected void say(String x) {
        System.out.println(x);
    }

    protected void say2(String x) {
        System.out.print(x);
    }
}

