/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.core.util.IdentifiableImpl;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.ProtectedAsset;
import edu.uiuc.ncsa.security.delegation.token.Verifier;

public class BasicTransaction
extends IdentifiableImpl
implements Cacheable {
    AuthorizationGrant authorizationGrant;
    AccessToken accessToken;
    Verifier verifier;
    ProtectedAsset protectedAsset;

    public BasicTransaction(Identifier identifier) {
        super(identifier);
    }

    public BasicTransaction(AuthorizationGrant ag) {
        super(BasicIdentifier.newID((String)ag.getToken()));
        this.setAuthorizationGrant(ag);
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public boolean hasAuthorizationGrant() {
        return this.authorizationGrant != null;
    }

    public boolean hasProtectedAsset() {
        return this.protectedAsset != null;
    }

    public boolean hasVerifier() {
        return this.verifier != null;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authorizationGrant;
    }

    public void setAuthorizationGrant(AuthorizationGrant authorizationGrant) {
        this.authorizationGrant = authorizationGrant;
        this.setIdentifier(BasicIdentifier.newID((String)authorizationGrant.getToken()));
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }

    public ProtectedAsset getProtectedAsset() {
        return this.protectedAsset;
    }

    public void setProtectedAsset(ProtectedAsset protectedAsset) {
        this.protectedAsset = protectedAsset;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BasicTransaction)) {
            return false;
        }
        BasicTransaction t = (BasicTransaction)((Object)obj);
        if (!BeanUtils.checkEquals((Object)this.getAuthorizationGrant(), (Object)t.getAuthorizationGrant())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getAccessToken(), (Object)t.getAccessToken())) {
            return false;
        }
        return BeanUtils.checkEquals((Object)this.getVerifier(), (Object)t.getVerifier());
    }

    public String toString() {
        String out = "Transaction[";
        out = out + "id=" + this.getIdentifierString() + ", auth grant=" + (this.hasAuthorizationGrant() ? this.getAuthorizationGrant() : "(none)");
        out = out + ", verifier=" + (!this.hasVerifier() ? "(none)" : this.getVerifier());
        out = out + ", access token=" + (this.hasAccessToken() ? this.getAccessToken() : "(none)");
        return out + "]";
    }
}

