/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArgType;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.procedure.ProcLib;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public abstract class PropertyFunctionBase
implements PropertyFunction {
    PropFuncArgType subjArgType;
    PropFuncArgType objFuncArgType;

    protected PropertyFunctionBase() {
        this(PropFuncArgType.PF_ARG_EITHER, PropFuncArgType.PF_ARG_EITHER);
    }

    protected PropertyFunctionBase(PropFuncArgType subjArgType, PropFuncArgType objFuncArgType) {
        this.subjArgType = subjArgType;
        this.objFuncArgType = objFuncArgType;
    }

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (this.subjArgType.equals(PropFuncArgType.PF_ARG_SINGLE) && argSubject.isList()) {
            throw new QueryBuildException("List arguments (subject) to " + predicate.getURI());
        }
        if (this.subjArgType.equals(PropFuncArgType.PF_ARG_LIST) && !argSubject.isList()) {
            throw new QueryBuildException("Single argument, list expected (subject) to " + predicate.getURI());
        }
        if (this.objFuncArgType.equals(PropFuncArgType.PF_ARG_SINGLE) && argObject.isList()) {
            throw new QueryBuildException("List arguments (object) to " + predicate.getURI());
        }
        if (this.objFuncArgType.equals(PropFuncArgType.PF_ARG_LIST) && !argObject.isList()) {
            throw new QueryBuildException("Single argument, list expected (object) to " + predicate.getURI());
        }
    }

    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        return new RepeatApplyIterator(input, argSubject, predicate, argObject, execCxt);
    }

    public abstract QueryIterator exec(Binding var1, PropFuncArg var2, Node var3, PropFuncArg var4, ExecutionContext var5);

    class RepeatApplyIterator
    extends QueryIterRepeatApply {
        private ExecutionContext execCxt;
        private PropFuncArg argSubject;
        private Node predicate;
        private PropFuncArg argObject;

        public RepeatApplyIterator(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
            super(input, execCxt);
            this.argSubject = argSubject;
            this.predicate = predicate;
            this.argObject = argObject;
        }

        protected QueryIterator nextStage(Binding binding) {
            QueryIterator iter = PropertyFunctionBase.this.exec(binding, this.argSubject, this.predicate, this.argObject, super.getExecContext());
            if (iter == null) {
                iter = ProcLib.noResults(this.execCxt);
            }
            return iter;
        }

        protected void details(IndentedWriter out, SerializationContext sCxt) {
            out.print("PropertyFunction [" + FmtUtils.stringForNode(this.predicate, sCxt) + "]");
            out.print("[");
            this.argSubject.output(out, sCxt);
            out.print("][");
            this.argObject.output(out, sCxt);
            out.print("]");
            out.println();
        }
    }
}

