/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.OneToManyMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TempNodeCache {
    protected OneToManyMap ipMap = new OneToManyMap();
    protected Map classMap = new HashMap();

    public TempNodeCache(InfGraph infgraph) {
    }

    public synchronized Node getTemp(Node instance, Node prop, Node pclass) {
        NodePair ip = new NodePair(instance, prop);
        Node result = null;
        Iterator i = this.ipMap.getAll(ip);
        while (i.hasNext()) {
            Node t = (Node)i.next();
            if (pclass != null) {
                Object tClass = this.classMap.get(t);
                if (tClass == null || !tClass.equals(pclass)) continue;
                result = t;
                break;
            }
            result = t;
            break;
        }
        if (result == null) {
            result = Node.createAnon();
            this.ipMap.put(ip, result);
            if (pclass != null) {
                this.classMap.put(result, pclass);
            }
        }
        return result;
    }

    public static class NodePair {
        protected Node first;
        protected Node second;

        public NodePair(Node first, Node second) {
            this.first = first;
            this.second = second;
        }

        public Node getFirst() {
            return this.first;
        }

        public Node getSecond() {
            return this.second;
        }

        public boolean equals(Object o) {
            return o instanceof NodePair && this.first.equals(((NodePair)o).first) && this.second.equals(((NodePair)o).second);
        }

        public int hashCode() {
            return this.first.hashCode() ^ this.second.hashCode() << 1;
        }
    }
}

